/*
re-implementation of adt::Stack

*/

adt::Stack:=
proc()
  option escape;
  local Stack;
begin


  Stack:= newDomain(genident("Stack"));

  Stack::stack:= [args()];

  Stack::empty:= () -> bool(nops(Stack::stack) = 0);

  Stack::nops:= () -> nops(Stack::stack);

  Stack::depth:= Stack::nops;

  Stack::top:= () -> if nops(Stack::stack) = 0 then
                       FAIL
                     else
                       op(Stack::stack, nops(Stack::stack))
                     end_if;

  Stack::push:=
  proc(x)
  begin
    Stack::stack:= append(Stack::stack, x)
  end_proc;

  Stack::pop:=
  proc()
    local a, n;
  begin
    if (n:= nops(Stack::stack)) = 0 then
      return(FAIL)
    end_if;
    a:= Stack::stack[n];
    delete Stack::stack[n];
    a
  end_proc;

  Stack::reverse:=
  proc()
  begin
    Stack::stack:= revert(Stack::stack)
  end_proc;

  Stack::copy:=
  proc()
  begin
    adt::Stack(op(Stack::stack))
  end_proc;

  Stack
end_proc: