/**
   adt::Queue -- the abstract data type queue


   Calling Sequence:

       adt::Queue([obj1, obj2, ... objn])


   Methods:

     enqueue  -- put a new element at the end of the queue
     dequeue  -- get and delete the front element of the queue
     front    -- get the front element of the queue
     empty    -- queue empty ?
     length   -- length of the queue
     clear    -- clearing the queue
     reverse  -- reverts the order of the queue

   Examples:

>> A := adt::Queue(1,2,3,4,5)

                                  Queue1

>> A::enqueue(42)

                                    42

>> A::front()

                                     1

>> A::dequeue()

                                     1

>> A::front()  

                                     2

>> A::empty()

                                   FALSE

>> A::reverse()


>> A::front()

                                    42

>> A::clear()


>> A::empty()  

                                   TRUE

**/
adt::Queue :=  proc() option escape; local DOM;
begin
  DOM := newDomain(genident("Queue")):
  DOM::QUEUE := [args()];

  DOM::enqueue := value -> (DOM::QUEUE := append(DOM::QUEUE, value); value);

  DOM::dequeue :=
    proc()
      local value;
    begin
      if DOM::empty() then return(FAIL) end_if;
      value := DOM::QUEUE[1];
      delete DOM::QUEUE[1];
      value
    end_proc:

  DOM::empty := () -> bool(nops(DOM::QUEUE) = 0):
  DOM::front :=  () -> if DOM::empty() then FAIL else DOM::QUEUE[1] end_if:
  DOM::length := () -> nops(DOM::QUEUE):
  DOM::clear := () -> (DOM::QUEUE := []; null()):
  DOM::reverse := () -> (DOM::QUEUE := revert(DOM::QUEUE); null()):
		     
  DOM
end_proc:

