

// bij 26.01.1999

/**
   adt::Tree -- the abstract data type "tree"


   Calling Sequence:

       adt::Tree([root, nod_1, ... nod_n])
                 nod_i   -> subtree | leaf
                 subtree -> [name, nod_1, ..., nod_k]

   Methods:


   Examples:

>> T:= adt::Tree([proc1, proc2, [proc3, proc4, proc5], [proc6]])

                                  Tree1

>> T::print()

                               proc1
                               |
                               +-- proc2
                               |
                               +-- proc3
                               |   |
                               |   +-- proc4
                               |   |
                               |   `-- proc5
                               |
                               `-- proc6


>> T::chars(["|", "|", "_", "|", " "]) 

                         ["|", "|", "_", "|", " "]
>> T::print()                         

                                proc1
                                |
                                |__ proc2
                                |
                                |__ proc3
                                |   |
                                |   |__ proc4
                                |   |
                                |   |__ proc5
                                |
                                |__ proc6



**/

adt::Tree:=
  proc()
    option escape;
    local DOM;
  begin
    DOM:= newDomain(genident("Tree")):
    DOM::TREE:= args();
    DOM::tree:= () -> if args(0) = 0 then DOM::TREE else DOM::TREE:= args(1) end_if;

//    DOM::TRSTstart:=
//      proc()
//        local cnt;
//      begin
//        cnt:=
//          proc(l)
//          begin
//            if domtype(l) = DOM_LIST then
//              l:= map(l, cnt);
//              return(l)
//            else
//              return(1)
//            end_if
//          end_proc:
//        DOM::TRST:= cnt(DOM::TREE)
//      end_proc:

//    DOM::TRSTstart():

    DOM::INDENT:= 4;
    DOM::indent:= () -> if args(0) = 0 then DOM::INDENT else DOM::INDENT:= args(1) end_if:

    DOM::CHARS:= ["|", "+", "-", "`", " "];
    DOM::chars:= () -> if args(0) = 0 then DOM::CHARS
                       elif args() = [] then DOM::CHARS:= ["|", "+", "-", "`", " "]
                       else DOM::CHARS:= args(1) end_if;

    DOM::OPTIONS:= {};
    DOM::options:= () -> if args(0) = 0 then DOM::OPTIONS else DOM::OPTIONS:= args(1) end_if:

    DOM::type:= "Tree";
    DOM::domtype:= () -> hold(adt::Tree);

    DOM::expose:= () -> stdlib::Exposed(output::tree(DOM::TREE, DOM::INDENT, DOM::CHARS, DOM::OPTIONS)):
    DOM::print := () -> print(Unquoted, output::tree(DOM::TREE, DOM::INDENT, DOM::CHARS, DOM::OPTIONS)):

    DOM::nops:=
      proc()
      begin
        nops(DOM::TREE) - 1 // ohne Wurzel
      end_proc:

    DOM::op:=
      proc(cnt)
        name Tree::op;
        local rop;
      begin
        rop:=
          proc(ltree, cnt)
          begin
            if domtype(cnt) = DOM_INT then
              if nops(ltree) >= cnt then
                if domtype(op(ltree, cnt)) = DOM_LIST then
                  return(op(ltree, cnt))
                else
                  return(op(ltree, cnt))
                end_if
              else
                FAIL
              end_if
            elif domtype(cnt) = DOM_LIST and nops(cnt) = 1 then
              return(rop(ltree, op(cnt)))
            elif domtype(cnt) = DOM_LIST and nops(cnt) > 1 then
              if domtype(op(ltree, op(cnt, 1))) = DOM_LIST then
                return(rop(op(ltree, op(cnt, 1)), [op(cnt, 2..nops(cnt))]))
              else
                return(op(op(ltree, op(cnt, 1)), [op(cnt, 2..nops(cnt))]))
              end_if
            else
              error("Illegal second argument")
            end_if
          end_proc:
        
        if args(0) = 0 then
          rop:= op(map(DOM::TREE, X->if domtype(X) = DOM_LIST then adt::Tree(X) else X end_if),
                   2..nops(DOM::TREE))
        elif domtype(cnt) = DOM_INT then
          rop:= rop(DOM::TREE, cnt + 1)
        elif domtype(cnt) = DOM_LIST then
          rop:= rop(DOM::TREE, map(cnt, _plus, 1))
        elif type(cnt) = "_range" then
          rop:= op(map(DOM::TREE, X->if domtype(X) = DOM_LIST then adt::Tree(X) else X end_if),
                   map(cnt, _plus, 1))
        else
          error("Illegal second argument")
        end_if;

        if domtype(rop) = DOM_LIST then
          rop:= adt::Tree(rop);
          //rop::print();
        end_if;
        rop
      end_proc:

    // commutative operators
//    DOM::COMOP:= {}:
//    DOM::commop:= () -> if args(0) = 0 then DOM::COMOP else DOM::COMOP:= args(1) end_if:

//    DOM::commutate_set:=
//      proc()
//      begin
//      end_proc:

//    DOM::commutate:= // (set of commutative operators)
//      proc(soco = dom::COMOP, opt = null())
//        local rcom, j;
//      begin
//        if nops(dom::TREE) = 1 then
//          dom
//        end_if;

//        j:= FALSE;
//        rcom:=
//          proc(ltree, stat)
//            local n, l, i, ns, ls, k;
//          begin
//            //print("rcom", args());
//            if domtype(ltree) = DOM_LIST then
//              n:= op(ltree, 1);
//              l:= [op(ltree, 2..nops(ltree))];
//              ns:= op(stat, 1);
//              ls:= [op(stat, 2..nops(stat))];
//              if contains(soco, n) and op(stat, 1) < nops(l) then // comm op
//                j:= TRUE;
//                return([n, op(append(subsop(l, 1 = null()), op(l, 1)))],
//                       [ns + 1, op(append(subsop(ls, 1 = null()), op(ls, 1)))])
//                       //subsop(stat, 1 = op(stat, 1) + 1))
//              else
//                i:= 1;
//                while not(j) and i <= nops(l) do
//                  k:= rcom(op(l, i), op(stat, i + 1));
//                  l:= subsop(l, i = op(k, 1));
//                  ls:= subsop(ls, i = op(k, 2));
//                  i:= i + 1
//                end_while;
//                return([n] . l, [ns] . ls)
//              end_if;
//            else
//              ltree, stat
//            end_if
//          end_proc:
//        rcom:= rcom(dom::TREE, dom::TRST);
//        if not(j) then
//          warning("all shuffles done");
//          DOM::TRST:= dom::TRSTstart()
//        end_if;
//        //print(rcom);
//        DOM::TREE:= op(rcom, 1);
//        DOM::TRST:= op(rcom, 2);
//        dom
//      end_proc:

    DOM::expr:=
      proc()
        local t2e;
      begin

        t2e:=
          proc(li)
          begin
            if domtype(li) = DOM_LIST then
              li:= map(li, t2e);
              return(op(li, 1)(op(li, 2..nops(li))))
            else
              return(li)
            end_if
          end_proc:
        
        t2e(DOM::TREE)
        
      end_proc:

    DOM
  end_proc:

