combinat::choose:=proc(s,k) local n;
//===================================================================
// erzeugt eine Sequenz aller k-elementigen Teilmengen der Menge N.  
// N kann auch eine natuerliche Zahl sein, welche dann wie die Menge 
// {1,2,...,N}  behandelt wird. Oder anders gesehen:  choose liefert 
// alle Moeglichkeiten, k ununterscheidbare Kugeln auf  N Faecher zu 
// verteilen, wobei die Eintraege jeder k-elementigen Menge die Po-  
// sitionen der  k Kugeln in den  N Faechern angeben. Die Laenge der 
// Ergebnis-Sequenz betraegt binomial(N,k) bzw  binomial(nops(N),k). 
//===================================================================
begin
   // Do the parameter checking
   if testargs() then
     if args(0) <> 2 then
       error("Wrong number of arguments") ;
     end_if ;
     if type(k) <> DOM_INT or k < 0 then
       error("Second argument must be a nonnegative integer") ;
     end_if ;
     if type(s) <> DOM_SET and ( type(s) <> DOM_INT or s < 0 ) then
       error("First argument must be a set or a nonnegative integer") ;
     end_if ;
   end_if ;
   if type(s)=DOM_INT then combinat::choose({$1..s},k)
   elif k>(n:=nops(s)) then null()
   elif k=n then s
   elif k=0 then {}
   elif k=1 then op(map(s,DOM_SET))
   else 
      // Zurueckfuehren auf den Fall n-1: 
      subsop(s,1=null());
      // Die k-te Kugel fortwaehrend in das Fach  op(s,1)  legen,   
      // und k-1 Kugeln auf die restlichen  n-1  Faecher verteilen. 
      op(map([combinat::choose(%,k-1)],_union,{op(s,1)})),
      // Dazu kommen alle Moeglichkeiten, k Kugeln auf 
      // die n-1 Faecher OHNE  op(s,1)  zu verteilen:  
      combinat::choose(%,k)
   end_if
end_proc:

