/*++
combinat::modStirling(q,n,k)  - computes the modified Stirling number
				sigma_k^{(n)}(q)

++*/

combinat::modStirling :=
proc(q:DOM_INT,n:DOM_INT,k:DOM_INT):DOM_INT
  option remember;
  local i;
begin
  if testargs() and ((k>n) or (k<0) or (n<0)) then
    error("illegal arguments");
  end_if;
  case k
    of 0 do return(1);
    of 1 do return((n^2+(2*q+1)*n)/2);
    of n do return(_mult( i $ i=(q+1)..(q+n)));
    otherwise
      return
      (combinat::modStirling(q,n-1,k)+
       (q+n)*combinat::modStirling(q,n-1,k-1));
  end_case;
end_proc:
