//      
/* 23.3.93, kamo
 permute(n) - permutations of a list

If n is an integer, then permute(n) returns a list with all permutations of [1,...,n]. 
If n is a list, a list of all permutations of n is returned.

*/
combinat::permute:=
proc(n)
  local list,perm, Nops, duplicate, i;
begin
  
  perm :=
  proc(list)
    local i, elem, result, res;
  begin
    case nops(list)
      of 0 do
        // fall through 
      of 1 do
        return([list])
      of 2 do
        return([[op(list,1),op(list,2)],[op(list,2),op(list,1)]])
    end_case;
    result := [];
    for i from 1 to nops(list) do
      elem := list[i]:
      res := perm(subsop(list, i=null()));
      result := result.map(res, append, elem);
    end_for;
    result;
  end_proc;

  //  main program of combinat::permute

  if args(0) < 1 or args(0) > 2 then
    error("Wrong number of arguments");
  end_if;
  
  if testtype(n,DOM_INT) then
    if n < 0 then
      error("Argument must be a list or a non-negative integer");
    end_if;
    case n
      of 0 do return([[]]); 
      of 1 do return([[1]]); 
      otherwise list := [$1..n];
    end_case;
  else
    list := n;
  end_if;

  if not testtype(list,DOM_LIST) then
    error("Argument must be a list or a non-negative integer");
  end_if;

  if args(0) = 2 then
    if args(2) <> Duplicate then
      error("Unknown option '".expr2text(args(2))."'") ;
    end_if ;
    duplicate:= 1 ;
  else
    // A list which is constructed from a number can't create duplicate
    // entries in the list, so keep duplicate entries because they
    // can't exist :)
    if testtype(n,DOM_INT) then
      duplicate:= 1 ;
    else
      duplicate:= 0 ;
    end_if ;
  end_if ;

  if duplicate = 1 then
    perm:= perm(list);
  else
    perm:= perm(list);
    Nops:= nops(perm);
    zip(perm, [bool(contains(perm,op(perm,i))=i) $ i = 1..Nops],
           (x,y) -> if y then x else null() end);
  end_if ;

end_proc:
