
/*++
 combinat::powerset(n) - powerset of a set

If n is an integer, then powerset(n) returns a set with all subsets of
{1,...,n}.  If n is a set, a set of all subsets of n is returned.
If n is a list, a set of all sublists is returned.

new implementation using combinat::subwords
++*/



combinat::powerset:= 
proc(n) 
  local i, res;
begin
  if n::dom::powerset <> FAIL then
    return(n::dom::powerset(n))
  end_if;
  
  /*
DOM_INT -> DOM_SET
*/
  if domtype(n) = DOM_INT then
    if n < 0 then
      error("argument must be a set or a non-negative integer!");
    end_if;
    case n
      of 0 do return({{}}); 
      of 1 do return({{},{1}}); 
      otherwise
        n := {$1..n};
    end_case;
  end_if;

  case domtype(n)
    of DOM_LIST do
      return({op(combinat::subwords(n))})
    of DOM_SET do   
      res := {{}};
      for i in n do
        res := res union map(res, _union,  {i});
      end_for;
      return(res);
    otherwise
      error("Illegal argument")
  end_case
end_proc:
