//    
/*++
Cat::AbelianGroup -- the category of abelian groups

An Cat::AbelianGroup is a Cat::CancellationAbelianMonoid where the operation '+'
is invertible.

Methods:-
_negate(x)     - returns the (additive) inverse of x
_subtract(x,y) - returns z such that y+z = x
equal(x,y)     - returns TRUE iff x = y
++*/

category Cat::AbelianGroup
    category Cat::CancellationAbelianMonoid;

    _negate;
    
    _subtract := proc(x,y) begin dom::_plus(x, dom::_negate(y)) end_proc;

    equal := proc(x,y) begin
	dom::iszero(dom::_subtract(x, y))
    end_proc;

    intmult := domains::repeatedSquaring(dom, "_plus", "zero", "_negate");
begin

end_category:


