//    
/*++
Cat::AbelianMonoid -- the category of abelian monoids

An Cat::AbelianMonoid is a Cat::AbelianSemiGroup with a neutral element "zero"
according to the operation '+'.

Use axiom 'Ax::normalRep' to state that "zero" is always represented
canonically.

If a domain has not the axion 'Ax::normalRep' then "zero" is only one
possible representation of the neutral element. Use "iszero" to
test for 0 in such a case.

Entries:-
zero         - the neutral Element according to '_plus'

Methods:-
iszero(x)    - returns TRUE iff x is zero
intmult(x,i) - returns x+x+...+x (i times) for a positive integer i and
	       zero for i=0
++*/

category Cat::AbelianMonoid
    category Cat::AbelianSemiGroup;
    axiom (if dom::hasProp(Ax::canonicalRep) then Ax::normalRep end_if);

    zero;

    iszero := ( if dom::hasProp(Ax::normalRep) then
	proc(x) begin bool(x = dom::zero) end_proc
    else
	proc(x) begin bool(dom::equal(x, dom::zero)) end_proc
    end_if );

    intmult := domains::repeatedSquaring(dom, "_plus", "zero");
begin

end_category:


