//    
/*++
Cat::HomogeneousFiniteProduct -- the category of homogeneous finite products

Cat::HomogeneousFiniteProduct(Set)

A homogeneous finite product is a homogeneous finite collection where each
element has the same number of elements.

Entries:-
dimen - the number of elements in the product

Methods:-
zip(x,y,f)        - calls f(x.i,y.i) for all elements x.i, y.i and builds a
		    new element of this from the results.
zipCanFail(x,y,f) - same as zip but returns FAIL if one of the results of f is FAIL.
++*/

category Cat::HomogeneousFiniteProduct( Set )

    category
     // a product is a module over each rng for which the components are one 
       if   Set::hasProp(Cat::DifferentialRing) then Cat::DifferentialRing
       elif Set::hasProp(Cat::PartialDifferentialRing) then Cat::PartialDifferentialRing
       elif Set::hasProp(Cat::CommutativeRing) then Cat::CommutativeRing
       elif Set::hasProp(Cat::Ring) then Cat::Ring
       elif Set::hasProp(Cat::Rng) then Cat::Rng 
       elif Set::hasProp(Cat::AbelianGroup) then Cat::AbelianGroup
       elif Set::hasProp(Cat::CancellationAbelianMonoid) then Cat::CancellationAbelianMonoid
       elif Set::hasProp(Cat::AbelianMonoid) then Cat::AbelianMonoid
       elif Set::hasProp(Cat::AbelianSemiGroup) then Cat::AbelianSemiGroup
       end_if,      
       if   Set::hasProp(Cat::SkewField) then Cat::SkewField end_if,
       if   Set::hasProp(Cat::Group) then Cat::Group
       elif Set::hasProp(Cat::Monoid) then Cat::Monoid
       elif Set::hasProp(Cat::SemiGroup) then Cat::SemiGroup
       end_if,
       if Set::hasProp(Cat::CommutativeRing) then
      	   Cat::Algebra(Set)
       elif Set::hasProp(Cat::Ring) then
      	   (Cat::LeftModule(Set), Cat::RightModule(Set))
       end_if,
       Cat::HomogeneousFiniteCollection(Set);
          
    dimen; zip; zipCanFail;
    
    nops := dom::dimen;
    
    characteristic := if Set::hasProp(Cat::Ring) then Set::characteristic end_if;
    
    /* One could principally implement all the algebraic operations here, but they
      will be slow if _index and set_index are slow, which most often will be the
      case. So we avoid the work and let the domain implementors do it... */


begin
     if args(0) <> 1 then error("wrong no of args") end_if;
     if Set::hasProp(Cat::BaseCategory) <> TRUE then error("not a set") end_if;
end_category:
