//    
/*++
Cat::HomogeneousFiniteCollection -- the category of homogeneous finite collections

Cat::HomogeneousFiniteCollection(Set)

A homogeneous finite collection is a finite collection where each element is
from the same domain Set.

Entries:-
elemDom - the domain where the elements are from
++*/

category Cat::HomogeneousFiniteCollection( Set )
    
    category Cat::FiniteCollection,
        if Set::hasProp(Cat::OrderedSet) then Cat::OrderedSet end_if;
    
    elemDom := Set;
    
    _less := if Set::hasProp(Cat::OrderedSet) then
	    // order elements lexicographically 
	    proc(x,y) local i; begin
	    	for i from 1 to min(dom::nops(x), dom::nops(y)) do
	    	    if not Set::equal(dom::_index(x,i), dom::_index(y,i)) then
	    	    	return(bool(Set::_less(dom::_index(x,i), dom::_index(y,i))))
	    	    end_if
	    	end_for;
	    	bool(dom::nops(x) < dom::nops(y))
	    end_proc
    end_if;

begin
    if args(0) <> 1 then error("wrong no of args") end_if;
    if Set::hasProp(Cat::BaseCategory) <> TRUE then 
        error("not of category 'Cat::BaseCategory'")
    end_if
end_category:
