//    
/*++
Cat::LeftModule -- the category of left-R-modules

Cat::LeftModule(R)

R - a Cat::Rng

A Cat::LeftModule is a Cat::AbelianGroup together with a Cat::Rng R with an
left multiplikation '*' : (R,this) -> this.

Axioms for ring elements a, b and module elements x, y:
	(a * b) * x = a * (b * x)
	(a + b) * x = a * x + b * x
	a * (x + y) = a * x + a * y

Beware: If a Cat::SemiGroup is also a Cat::LeftModule the multiplication '*'
has 2 signatures: '*' : (this,this) -> this and '*' : (R,this) -> this.
The implementation of the multiplication must handle this. The same
kind of problem is occuring if a domain is a Cat::LeftModule over more
than one rng.

Methods:-
_mult(r,x) - returns the left multiplikation r*x of x by the rng element r
++*/

category Cat::LeftModule( R: Cat::Rng )

    category Cat::AbelianGroup ;

    _mult;

end_category:

