/*   
*/
/*++
Cat::OrderedSet -- the category of ordered sets

An Cat::OrderedSet is a set with a (complete) order relation '<'.

Use the axiom Ax::canonicalOrder to signal that elements of a domain are
canonically ordered as MuPAD expressions.

Methods:
_less(x,y)    - return TRUE iff x < y
_leequal(x,y) - return TRUE iff x < y or x = y
sort(l)	      - returns ascending sorted list if l ist a list of elements
++*/

category Cat::OrderedSet
    category Cat::BaseCategory;

    _less := if dom::hasProp(Ax::canonicalOrder) then
	bool @ _less
    else
        toBeDefined
    end_if;

    _leequal := if dom::hasProp(Ax::canonicalOrder) then
	bool @ _leequal
    else
	proc(a, b) begin
	    dom::_less(a, b) or dom::equal(a, b)
	end_proc
    end_if;

    sort := if dom::hasProp(Ax::canonicalOrder) then
	sort
    else
	proc() begin sort(args(1), dom::_less) end_proc 
    end_if;

    min :=  if dom::hasProp(Ax::canonicalOrder) then
	proc() local m, i; begin
	    if args(0) = 0 then error("no args") end_if;
	    m:= args(1);
	    for i from 2 to args(0) do
		if args(i) < m then m:= args(i) end_if
	    end_for;
	    m
	end_proc
    else
	proc() local m, i; begin
	    if args(0) = 0 then error("no args") end_if;
	    m:= args(1);
	    for i from 2 to args(0) do
		if dom::_less(args(i), m) then m:= args(i) end_if
	    end_for;
	    m
	end_proc
    end_if ;

    max :=  if dom::hasProp(Ax::canonicalOrder) then
	proc() local m, i; begin
	    if args(0) = 0 then error("no args") end_if;
	    m:= args(1);
	    for i from 2 to args(0) do
		if m < args(i) then m:= args(i) end_if
	    end_for;
	    m
	end_proc
    else
	proc() local m, i; begin
	    if args(0) = 0 then error("no args") end_if;
	    m:= args(1);
	    for i from 2 to args(0) do
		if dom::_less(m, args(i)) then m:= args(i) end_if
	    end_for;
	    m
	end_proc
    end_if ;

begin

end_category:

