//    
/*++
Cat::QuotientField -- the category of quotient fields over R

Cat::QuotientField(R)

R - integral domain

Methods:
numer(x)     - returns the numerator of x
denom(x)     - returns the denominator of x
retract(x)   - returns numer(x)/denom(x) if this is an element of R and
	       FAIL otherwise
++*/

category Cat::QuotientField( R )
    category Cat::Field, Cat::Algebra(R),
       if R::hasProp(Cat::OrderedSet) then Cat::OrderedSet end_if ;

    numer; denom;

    characteristic := R::characteristic;
    
    iszero := R::iszero @ dom::numer;

    _less :=  if R::hasProp(Cat::OrderedSet) then
	if not dom::hasProp(Ax::canonicalOrder) then
	    proc(x,y) begin
		R::_less(R::_mult(dom::numer(x), dom::denom(y)),
			 R::_mult(dom::numer(y), dom::denom(x)))
	    end_proc
	end_if
    end_if ;

    equal := proc(x,y) begin
	R::equal(R::_mult(dom::numer(x), dom::denom(y)),
		 R::_mult(dom::numer(y), dom::denom(x)))
    end_proc;

    retract := proc(x) begin
	R::_divide(dom::numer(x), dom::denom(x))
    end_proc;

begin
      if args(0) <> 1 then error("wrong no of args") end_if;
      if R::hasProp(Cat::IntegralDomain) <> TRUE then
	error("no integral domain")
      end_if;
end_category:

// end of file 
