/*
    Cat::SquareMatrix -- the category of square matrices

    Cat::SquareMatrix(R)

    R - coefficient domain (a Cat::Rng)

    The category Cat::SquareMatrix(R) represents the Cat::Rng
    of square matrices (of fixed order) over the coefficient domain 
    Cat::Rng R.

    The super-category of Cat::SquareMatrix(R) is Cat::Matrix(R).
    This ensures that a method for Cat::Matrix(R) may be used by
    Cat::SquareMatrix(R).
*/

category Cat::SquareMatrix( R )
    category 
        if R::hasProp(Cat::Ring) then Cat::Ring else Cat::Rng end_if,
        Cat::Matrix(R);

    // entries and methods:
    characteristic := if R::hasProp(Cat::Ring) then
        R::characteristic
    end_if;

// -----------------------------------------
//          body of the category
// -----------------------------------------
begin
    // initialisation 
    if args(0) <> 1 then error("wrong no of args") end_if;
     if R::hasProp(Cat::Rng) <> TRUE then
	error("coefficients must be from a Cat::Rng")
    end_if;
end_category:
