//    
/*++
Cat::UnivariatePolynomial -- the category of univariate polynomials

Cat::UnivariatePolynomial(R)

R - coefficient ring

Methods:
pdivide(p,q) - returns a sequence b,s,r such that b*p = q*s + r,
	       degree(r) < degree(q) and b = lcoeff(q)^k
pquo(p,q)    - returns pdivide(p,q)[2]
prem(p,q)    - returns pdivide(p,q)[3]
++*/

category Cat::UnivariatePolynomial( R )
    category 
      if R::hasProp(Cat::Field) then Cat::EuclideanDomain end_if ,
      Cat::Polynomial(R), Cat::DifferentialRing ;

    pdivide; pquo; prem;

begin
      if args(0) <> 1 then error("wrong no of args") end_if;
      if R::hasProp(Cat::CommutativeRing) <> TRUE then
	error("no commutative ring")
      end_if;
end_category:

