/*++
	Cat::VectorSpace  --  the categories of vectorspaces

	VectorSpace( F )

	F: a Cat::Field

	A Cat::VectorSpace( F ) is a vectorspace over a field F.
	The scalar product has to be implemented by the method
        "_mult" of the domain that belongs to this category as
        '*': (F,this) -> this and '*': (this,F) -> this.
++*/

category Cat::VectorSpace( F )

   category Cat::Module( F );

begin
// Init = 
    if args(0) <> 1 then
	error("wrong no of args")
    end_if;
    if F::hasProp( Cat::Field ) <> TRUE then
	error("argument must be of category 'Cat::Field'")
    end_if;
end_category:


// end of file 
