//    

/*++
func_call -- create a new axiom using axiom constructor

func_call(AC,a1,...)

AC     - axiom constructor
a1,... - actual parameters of axiom

The axiom is an element of the domain 'Axiom'. It merely holds the
constructor and the closure of the axiom.

One can't remember the existing axioms with 'option remember'
because of the implicit 'option hold' of func_call.
++*/

AxiomConstructor::func_call:= proc(AC)
    option noDebug;
    local call, ecall, A, ta, tp, i;
    save clos;
begin
    // 'func_call' has option hold implicitly 
    AC:= context(AC);
    call:= context([args(2..args(0))]);

    // test args 
    if testargs() then
	if args(0) = 0 then error("wrong no of args") end;
	if domtype(AC) <> AxiomConstructor then error("illegal argument") end;
    end;

    // compute closure, assign to clos 
    ta:= testargs(TRUE);
    tp:= Pref::typeCheck(Always);
    i:= traperror( extop(AC,1)(op(call)) );
    testargs(ta);
    Pref::typeCheck(tp);
    if i <> 0 then lasterror() end;

    ecall:= [ op(clos, op(clos,[0,2])..nops(clos)) ];

    // does the axiom already exist? 
    A:= slot(extop(AC,2), ecall);
    if A <> FAIL then return(A) end_if;

    // create axiom and remember it 
    A:= new(Axiom, AC, clos);
    slot(extop(AC,2), ecall, A);
    A
end_proc:

// end of file 
