/*   
*/
/*++
Axiom -- the domain of axioms

Axioms are - up to now - only a device to attach attributes to domains
and categories.  An axiom is an element of the domain 'Axiom'. Axioms
may depend upon parameters and are created by axiom constructors
(elements of the domain 'AxiomConstructor').

An axiom has the following operands:

0    - the domain 'Axiom'
1    - the axiom constructor
2    - the closure of the axiom

None of the methods defined here are normally called directly by the
category implementor or user. They are called implizitly.
++*/

Axiom:= newDomain("Axiom"):
Axiom::info:= "Domain 'Axiom'":
Axiom::interface:= {}:
Axiom::create_dom:= hold(Axiom):
Axiom::subs:= x -> x:

/*++
new -- create a new Axiom using constructor

new(AC, clos)

AC     - axiom constructor
clos   - closure
++*/

Axiom::new:= proc(AC: AxiomConstructor, clos: DOM_PROC_ENV): Axiom
    option noDebug;
begin
    new(Axiom, clos)
end_proc:


/*++
print -- print Axiom

print(A)

A - axiom
++*/

Axiom::print:= proc(AA: Axiom)
  local p, nam, A;
begin
    A:= extop(AA, 2);
    p:= op(A, 1);
    nam:= op(p, 6);
    if op(p,1) = NIL then
	nam
    else
	p:= op(A,[0,2]);
	subsop(hold(sin)(op(A, p..(p+op(A,[0,3])-1))), 0=nam)
    end
end_proc:

Axiom::create_dom_elem:= Axiom::print:

/*++
TeX -- return TeX-formatted string

TeX(A)

A - axiom
++*/

Axiom::TeX:= proc(A: Axiom): DOM_STRING
begin
    generate::TeX(Axiom::print(A))
end_proc:


/*++
testtype -- test type of axiom

testtype(e, T)

e - expression
T - type

Returns TRUE if e is an Axiom and T is Axiom and FAIL otherwise.
++*/

Axiom::testtype:= proc(e, T)
begin
    if T = Axiom then
	if domtype(e) = Axiom then
	    return(TRUE)
	end_if
    end_if;
    FAIL
end_proc:

/*++
constructor -- return constructor of Axiom

constructor(A)

A - axiom
++*/

Axiom::constructor:= proc(A: Axiom): AxiomConstructor
begin
    extop(A,1)
end_proc:

/*++
printInfo -- print information about axiom

printInfo(A)

A - axiom
++*/

Axiom::printInfo:= proc(A: Axiom): DOM_NULL
    save PRETTYPRINT;
begin
    PRETTYPRINT:= FALSE;
    print(Unquoted, expr2text(A)." -- axiom constructed by ".
    		    expr2text(extop(A,1)))
end_proc:

// end of file 
