//    

/*++
getNamedEntry -- get entry of category, changing it into domain entry

getNamedEntry(CC,e)

C - category
e - entry name

Called by 'Category::slot' to get a domain entry which is used
explicitly in a category constructor definition. This method may
not be called in any other context!

The global variable '__dom__' is used as the actual domain to create the
entry for (too bad). It ist defined in CategoryConstructor::getEntry.
++*/

CategoryConstructor::getNamedEntry:= proc(C: Category, e: DOM_STRING)
    option noDebug;
    local d, res;
begin
    if domtype(__dom__) <> DOM_DOMAIN then
	error("wrong context")
    end_if;
    d:= extop(extop(C,1),5);
    if not contains(d, e) then
	error("missing direct domain entry \"".e."\"")
    end_if;

    // evaluate entry in closure of category 
    res := _eval_entry(indexval(d, e), __dom__, extop(C,2));
    if res = null() then
      NIL
    else
      res;
    end_if;
end_proc:

// end of file 
