//    

/*++
allEntries -- get all entries of category

allEntries(Dom,defined,undefined)

Dom       - domain to create entries for
defined   - set with defined entries
undefined - set with 'to be defined' entries

Searches for entries in line with getEntry. The names of the
entries are inserted in the set 'undefined' and 'defined'.
A list with the two sets is returned.
++*/

CategoryConstructor::allEntries:= proc(DOM: DOM_DOMAIN, d: DOM_SET, u: DOM_SET)
    option noDebug;
    local r, e, i, C, entries;
    save __dom__;
begin
    __dom__:= DOM;
    i:= 1;
    while (C:= DomainConstructor::getCategory(DOM, i)) <> FAIL do
    	i:= i+1;
	// search for entries in category constructor 
	entries:= extop(extop(C,1),5);
	for e in entries do
	    if op(e,2) = FAIL then next end_if;
	    e:= op(e,1);
	    if contains(d, e) then next end_if;
	    if contains(u, e) then next end_if;

	    // evaluate entry in closure of category 
	    r:= _eval_entry(indexval(entries, e), DOM, extop(C,2));

	    // toBeDefined means: entry should have been defined elsewhere 
	    if r = hold(toBeDefined) then
		u:= u union {e}
	    elif r <> NIL and r <> null() then
		d:= d union {e}
	    end_if;
	end_for;
    end_while;
    [ d, u ]
end_proc:

// end of file 
