//    

/*++
func_call -- create new category using constructor

func_call(CC,a1,...)

CC     - category constructor
a1,... - actual category parameters

The category is an element of the domain 'Category'. It merely holds
the constructor and a closure. Entries are created later on
the fly when a domain needs them.

One can't remember the existing categories with 'option remember'
because of the implicit 'option hold' of func_call.
++*/

CategoryConstructor::func_call:= proc(CC)
    option noDebug;
    local call, ecall, C, ta, tp, i;
    save clos;
begin
    // 'func_call' has option hold implicitly 
    CC:= context(CC);
    call:= context([args(2..args(0))]);

    // test arguments 
    if testargs() then
        if args(0) = 0 then error("wrong no of args") end_if;
        if domtype(CC) <> CategoryConstructor then
            error("illegal argument")
        end_if;
    end_if;

    // compute closure, assign to clos 
    ta:= testargs(TRUE);
    tp:= Pref::typeCheck(Always);
    i:= traperror( extop(CC,1)(op(call)) );
    testargs(ta);
    Pref::typeCheck(tp);
    if i <> 0 then lasterror() end;

    ecall:= [ op(clos, op(clos,[0,2])..nops(clos)) ];

    // does the category already exist? 
    C:= slot(extop(CC,2), ecall);
    if C <> FAIL then return(C) end_if;

    // create category and remember it 
    C:= new(Category, CC, clos);
    slot(extop(CC,2), ecall, C);
    C
end_proc:

// end of file 
