//    

/*++
getEntry -- get entry of category and change it into domain entry

getEntry(Dom,e)

Dom - domain to create entry for
e   - entry name

If the entry is found it is changed into an entry for domain
Dom and returned. getEntry returns [FAIL,FAIL] if no entry with
name e is found.

The domain '__dom__' is used as a global variable by 'getNamedEntry' in
order to get the domain for which to create the entry in that method
(too bad, but hides the details to the category implementor).
++*/

CategoryConstructor::getEntry:= proc(DOM: DOM_DOMAIN, e: DOM_STRING)
    option noDebug;
    local C, r, i;
    save __dom__;
begin
    __dom__:= DOM;
    r := NIL;
    i:= 1;
    while (C:= DomainConstructor::getCategory(DOM, i)) <> FAIL do
    	i:= i+1;
	// search for entry in category constructor 
	r:= extop(extop(C,1),5);
	if contains(r, e) then
	    // evaluate entry in closure of category 
	    r:= _eval_entry(indexval(r, e), DOM, extop(C,2));
	    if r <> NIL and r <> null() then
		return([r, C])
	    end_if;
	end_if;
    end_while;
    [FAIL, FAIL]
end_proc:

// end of file 
