//    

/*++
printInfo -- print information about constructor

printInfo(CC)

CC - category constructor

printInfo prints some information about CC onto the screen.
++*/

CategoryConstructor::printInfo:= proc(CC: CategoryConstructor): DOM_NULL
    option noDebug;
    local p, t, lp, fp, subsDOMVARs;
    save  PRETTYPRINT;
begin
    PRETTYPRINT:= FALSE;
    p:= proc() begin print(Unquoted, args()) end_proc ;
    p("-- Category Constructor:");
    t:= extop(CC,1);
    // local parameters:
    lp:= [op( t,2 )];
    // formal parameters:
    fp:= [op( t,1 )];
    if lp = [NIL] then
        subsDOMVARs:= proc(p)
            // substitute the local variables by their names
            local i;
        begin
            subs( p, DOM_VAR(0,1+i)=fp[i] $ i=1..nops(fp), Unsimplified );
        end
    else
        subsDOMVARs:= proc(p)
            // substitute the local variables by their names
            local i;
        begin
            subs( p,DOM_VAR(0,1+i)=lp[i] $ i=1..nops(lp),
                    DOM_VAR(0,1+nops(lp)+i)=fp[i] $ i=1..nops(fp),
            Unsimplified );
        end
    end_if;

    if CC["info_str"] = FAIL then
        // frankp: Warum soll hier der Body ausgegeben werden??
	// p(extop(CC,1));
	p(expr2text(op(t,6)))
    else
	p(expr2text(op(t,6))." -- ".CC["info_str"])
    end_if;
    p("");
    if fp = [NIL] then
	p("-- No Parameters.");
    else
	p("-- Formal Parameters:");
	p(op(fp))
    end_if;
    p("");
    p("-- Direct Super-Categories:");
    p(op(subsDOMVARs(extop(CC,3))));
    p("");
    if extop(CC,4) = [] then
	p("-- No Direct Axioms.");
    else
	p("-- Direct Axioms:");
	p(op(subsDOMVARs(extop(CC,4))));
    end_if;
    p("");
    t:= extop(CC,5);
    case nops(t)
    of 0 do
        p("-- No Entries.");
        break;
    of 1 do
	p("-- Entry:");
	p(op(t, [1,1]));
	break;
    otherwise
	p("-- Entries:");
	p(op(sort([map(op(t), op, 1)])));
    end_case;
    null()
end_proc:

// end of file 
