//    
/*++
CategoryConstructor -- the domain of category constructors

A category constructors is used to create categories depending upon
parameters.

Normally no methods of the domain 'CategoryConstructor' are
called by the category constructor implementor. All methods are
called implicitly.

A category constructor is an element of CategoryConstructor with the
following operands:

0 - the domain CategoryConstructor
1 - the init-procedure of the constructor (a procedure)
2 - a domain containing the categories constructed so far
3 - a list of expressions which must evaluate to categories
4 - a list of expressions which must evaluate to axioms
5 - a domain with the entries for the categories to construct

Category instances are created by the method 'func_call'. The initialization
procedure (op 1) is called with the actual parameters and is used to
create a closure for the category to create.

Newly created categories are remembered by the constructor. If a category
with the same parameters is to be constructed the existing category is
returned.

When a new domain is created all the categories and axioms of the domain are
created too, depending on the actual parameters of the category. To create
the direct super-categories of a category the 3th op of the category
constructor contains an expression which is evaluated in the closure
of the category. This must yield a list of super-categories as result.

If a domain entry is evaluated (via 'slot' or '::') which is not already
created by the domain constructor, the entry is looked up by the domain
constructor. If there is no entry in the domain constructor the categories
of the domain will be asked to create the entry via
'CategoryConstructor::getEntry'.

The categories in turn ask their constructors to create the entry using the
category closure. If the constructor has a definition for the entry, this
entry is changed into a domain entry and returned as result of the look-up:
The entry is evaluated in the catgories closure, the result is returned.
++*/

CategoryConstructor:= newDomain("CategoryConstructor"):
CategoryConstructor::info:= "Domain: 'CategoryConstructor'":
CategoryConstructor::interface:= {}:
CategoryConstructor::create_dom:= hold(CategoryConstructor) :
CategoryConstructor::subs:= proc() begin args(1) end_proc :

alias(path = pathname("DOMAINS", "CONSTR"));

CategoryConstructor::getNamedEntry:= loadproc(CategoryConstructor::getNamedEntry, path, "CCNamEnt");
CategoryConstructor::allEntries:= loadproc(CategoryConstructor::allEntries, path, "CCallEnt");
CategoryConstructor::func_call:= loadproc(CategoryConstructor::func_call, path, "CCfcall");
CategoryConstructor::getEntry:= loadproc(CategoryConstructor::getEntry, path, "CCgetEnt");
CategoryConstructor::print:= loadproc(CategoryConstructor::print, path, "CCprint");
CategoryConstructor::create_dom_elem:= loadproc(CategoryConstructor::create_dom_elem, path, "CCprint");
CategoryConstructor::testtype:= loadproc(CategoryConstructor::testtype, path, "CCttype");
CategoryConstructor::TeX:= loadproc(CategoryConstructor::TeX, path, "CCtex");
CategoryConstructor::entryOrigins:= loadproc(CategoryConstructor::entryOrigins, path, "CCentOri");
CategoryConstructor::_index:= loadproc(CategoryConstructor::_index, path, "CCindex");
CategoryConstructor::printInfo:= loadproc(CategoryConstructor::printInfo, path, "CCprInfo");

// end of file 
