//    

/*++
getSuperDomainEntry -- get entry of super-domain

getSuperDomainEntry(Dom, e)

Dom - domain for which to create entry
e   - name of entry

Creates super-domain entry e for 'target' domain 'Dom' on the fly.
Categories of the super-domains are not involved!
++*/

DomainConstructor::getSuperDomainEntry:= proc(DOM: DOM_DOMAIN, e: DOM_STRING)
    option noDebug;
    local SD, r;
begin
    r := NIL;
    for SD in DOM::super_domains do
    	// search for entry in super-domain constructor 
    	r:= extop(SD::constructor,4);
    	if contains(r, e) then
    	    // evaluate entry in closure of super-domain 
    	    r:= _eval_entry(indexval(r, e), DOM, SD::closure);
    	    if r <> NIL and r <> null() then
        		return([r, SD])
    	    end_if;
    	end_if;
    end_for;
    [FAIL, FAIL]
end_proc:

// end of file 
