//    

/*++
func_call -- create new domain using constructor

func_call(DC, a1,...)

DC     - domain constructor
a1,... - actual parameters of the domain to construct

Creates a domain with actual parameters ai. Only entries for the
constructor, the closure, the name, the
super-domains, the direct axioms and the direct categories and their
axioms are inserted into the domain. Other entries are created on the
fly using 'DomainConstructor::getEntry'. The new domain is returned.

One can't remember the existing domains with 'option remember'
because of the implicit 'option hold' of func_call. (n:=7:
Z7:=Dom::IntegerMod(n): Z7::_plus: bool(Z7=Dom::IntegerMod(7)); would
result in FALSE.)
++*/

DomainConstructor::func_call:= proc(DC)
    option noDebug;
    local DOM, call, ecall, init, C, S, A, ta, tp, i;
    save clos;
begin
    // 'func_call' has option hold implicitly 
    DC:= context(DC);
    call:= context([args(2..args(0))]);

    // test arguments 
    if testargs() then
        if args(0) = 0 then error("wrong no of args") end_if;
        if domtype(DC) <> DomainConstructor then
            error("no domain constructor")
        end_if;
    end_if;

    // compute closure, assign to clos 
    init:= extop(DC,1);

    ta:= testargs(TRUE);
    tp:= Pref::typeCheck(Always);
    i:= traperror( init(op(call)) );
    testargs(ta);
    Pref::typeCheck(tp);
    if i <> 0 then lasterror() end;

    // create domain 
    ecall:= [ op(clos, op(clos,[0,2])..nops(clos)) ];
    if ecall = [] then
	DOM:= newDomain(op(init, 6))
    else
        DOM:= newDomain(subsop(hold(clos)(op(ecall)), 0=op(init, 6)))
    end_if;

    // did the domain already exist? 
    if DOM::constructor <> FAIL then
	return(DOM);
    end_if;

    DOM::constructor:= DC;
    DOM::closure:= clos;

    DOM::super_domains:= [];
    DOM::categories:= [];
    DOM::categories_idx:= 1;
    DOM::axioms:= {};
    DOM::make_slot:= DomainConstructor::getEntry;

    // list super-domains 
    S:= DOM;
    while extop(S::constructor,5) <> NIL do
	S:= _eval_entry(extop(S::constructor,5)[1], DOM, S::closure);
	if domtype(S) <> DOM_DOMAIN then
	    error("invalid super-domain")
	end_if;
        if domtype(S::constructor) <> DomainConstructor then
	    error("invalid super-domain")
        end_if;
	DOM::super_domains:= append(DOM::super_domains, S)
    end_while;

    // list direct axioms 
    A:= extop(DC,3);
    DOM::axioms:= { _eval_entry(A[i], DOM, clos) $ i=1..nops(A) }
		  minus { NIL };

    if DOM::axioms <> {} then
	if map(DOM::axioms, domtype) <> {Axiom} then
	    error("invalid axiom")
	end_if
    end_if;

    // list direct categories and their axioms 
    for C in extop(DC,2) do
	// make category 
	C:= _eval_entry(C, DOM, clos);
	if C = NIL or C = null() then next end_if;
	if contains(DOM::categories, C) <> 0 then next end_if;
	if domtype(C) <> Category then
	    error("invalid category")
	end_if;
	DOM::categories:= append(DOM::categories, C);
	// make axioms of categories 
	A:= extop(extop(C,1),4);
	A:= { _eval_entry(A[i], DOM, extop(C,2)) $ i=1..nops(A) }
	    minus { NIL };
	if A <> {} then
	    if map(A, domtype) <> {Axiom} then
		error("invalid axiom")
	    end_if;
	    DOM::axioms:= DOM::axioms union A;
	end_if;
    end_for;

    // allow for final initialization
    DOM::initDomain();
    DOM
end_proc:

// end of file 
