/*++
getEntry -- get entry of domain

getEntry(Dom,e)

Dom - domain
e   - name of entry

Creates domain entry e on the fly, depending on the domain 'Dom' and its
actual parameters. The new entry is returned (and inserted into the
domain by 'slot').
++*/

DomainConstructor::getEntry:= proc(DOM: DOM_DOMAIN, e: DOM_STRING)
    option noDebug;
    local m;
begin
    m:= DomainConstructor::makeEntry(DOM, e)[1];

    // give method a name
    if domtype(m) = DOM_PROC then
        // Here we must use the expression, no string. Otherwise procname is
        // broken and errors show the string as the name of the procedure where the
        // error is raised.
        m:= subsop(m, 6=hold(slot)(DOM::key, e))
    end_if;
    m
end_proc:
