//    

/*++
hasProp -- check if a domain has a certain property

hasProp(Dom, attr)

Dom  - domain
attr - attribute to check for (super-domain, category, axiom or constructor)

hasProp returns TRUE, if the domain has super-domain, category or axiom
'attr' or a constructor of one of these objects. The method normally is not
called directly but rather by the entry 'hasProp' of a domain. (This method
is defined by the domain 'Dom::BaseDomain'.)
++*/

DomainConstructor::hasProp:=
proc(DOM: DOM_DOMAIN, attr): DOM_BOOL
  option noDebug;
  local i, C;
begin
  if testargs() then
    if args(0) <> 2 then error("wrong no of args") end_if;
    if DOM::axioms = FAIL or DOM::categories = FAIL then
      error("not created by constructor")
    end_if;
  end_if;

  case domtype(attr)
    of Axiom do
         // incrementally loading categories, thereby creating their axioms
         i:= 1;
         while TRUE do
           if contains(DOM::axioms, attr) then
             return(TRUE)
           end_if;
           if DOM::categories_idx > nops(DOM::categories) then
             return(FALSE);
           end_if;
           if DomainConstructor::getCategory(DOM, i) = FAIL then
             return(FALSE)
           end_if;
           i:= i+1;
         end_while;
         break;
    of AxiomConstructor do
         i:= 1;
         while TRUE do
           if contains(map(DOM::axioms, extop, 1), attr) then
             return(TRUE)
           end_if;
           if DOM::categories_idx > nops(DOM::categories) then
             return(FALSE);
           end_if;
           if DomainConstructor::getCategory(DOM, i) = FAIL then
             return(FALSE)
           end_if;
           i:= i+1;
         end_while;
         break;
    of Category do
         if contains(DOM::categories, attr) <> 0 then
           TRUE
         elif DOM::categories_idx > nops(DOM::categories) then
           FALSE
         else
           // incrementelly loading categories
           i:= 1;
           while (C:= DomainConstructor::getCategory(DOM, i)) <> FAIL do
             if C = attr then return(TRUE) end_if;
             i:= i+1
           end_while;
           FALSE
         end_if;
         break;
    of CategoryConstructor do
         if contains(map(DOM::categories, extop, 1), attr) <> 0 then
           TRUE
         elif DOM::categories_idx > nops(DOM::categories) then
           FALSE
         else
           i:= 1;
           while (C:= DomainConstructor::getCategory(DOM, i)) <> FAIL do
             if extop(C,1) = attr then return(TRUE) end_if;
             i:= i+1
           end_while;
           FALSE
         end_if;
         break;
    of DOM_DOMAIN do
         if DOM = attr then
           TRUE
         else
           bool(contains(DOM::super_domains, attr) <> 0)
         end_if;
         break;
    of DomainConstructor do
         if DOM::constructor = attr then
           TRUE
         else
           bool(contains(map(DOM::super_domains, slot, "constructor"),
                         attr) <> 0)
         end_if;
         break;
    otherwise
         error("attribute has invalid type ".expr2text(domtype(attr)));
    end_case
end_proc:

domains::hasProp:= DomainConstructor::hasProp:

// end of file 
