//    

/*++
printInfo -- print information about constructor

printInfo(DC)

DC - domain constructor

printInfo prints some information about DC onto the screen.
++*/

DomainConstructor::printInfo:= proc(DC: DomainConstructor): DOM_NULL
    option noDebug;
    local p, t, nlp, fp, subsDOMVARs;
    save  PRETTYPRINT;
begin
    PRETTYPRINT:= FALSE;
    p:= proc() option noDebug; begin print(Unquoted, args()) end_proc ;
    p("-- Domain Constructor:");
    t:= extop(DC,1);

    // local parameters:
    lp:= [op( t,2 )];
    // formal parameters:
    fp:= [op( t,1 )];
    if lp = [NIL] then
        subsDOMVARs:= proc(p)
            // substitute the local variables by their names
            local i;
        begin
            subs( p, DOM_VAR(0,1+i)=fp[i] $ i=1..nops(fp), Unsimplified );
        end
    else
        subsDOMVARs:= proc(p)
            // substitute the local variables by their names
            local i;
        begin
            subs( p,DOM_VAR(0,1+i)=lp[i] $ i=1..nops(lp),
                    DOM_VAR(0,1+nops(lp)+i)=fp[i] $ i=1..nops(fp),
            Unsimplified );
        end
    end_if;

    if DC["info_str"] = FAIL then
	p(expr2text(op(t,6)))
    else
	p(expr2text(op(t,6))." -- ".DC["info_str"])
    end_if;
    p("");
    if fp = [NIL] then
	p("-- No Parameters.");
    else
	p("-- Formal Parameters:");
	p(op(fp));
    end_if;
    p("");
    p("-- Super-Domain:");
    p(if extop(DC,5) = NIL then " --- " else subsDOMVARs(extop(DC,5)[1]) end_if);
    p("");
    p("-- Direct Categories:");
    p(op(subsDOMVARs(extop(DC,2))));
    p("");
    if extop(DC,3) = [] then
	p("-- No Direct Axioms.");
    else
	p("-- Direct Axioms:");
	p(op(subsDOMVARs(extop(DC,3))));
    end_if;
    p("");
    t:= extop(DC,4);
    case nops(t)
    of 0 do
        p("-- No Entries.");
        break;
    of 1 do
	p("-- Entry:");
	p(op(t, [1,1]));
	break;
    otherwise
	p("-- Entries:");
	p(op(sort([map(op(t), op, 1)])));
    end_case;
    null()
end_proc:

// end of file 
