//    
/*++
Dom::ArithmeticalExpression -- the domain of arithmetical expressions

The domain of arithmetical expressions built up by the internal
operators '+', '*', etc. This domain has almost no algebraic
structure because expressions have no normal form (rational expressions
for example are not normalized to zero).

Use Dom::ExpressionField if you can supply a normalizing function
for a class of expressions which makes that class a field.

Entries:-
zero             - the element 0
one              - the element 1

Methods:-
iszero(e)        - returns TRUE iff e is zero
_plus(x1,x2,...) - returns the sum of the xi
_negate(x)       - returns -x
_subtract(x,y)   - returns x-y
_mult(x1,x2,...) - returns the product of the xi
_invert(x)       - returns 1/x
intmult(x,i)     - returns i times x
_power(x,y)      - returns x^y
_divide(x,y)     - returns x/y
max(x1,x2,...)   - the maximum of x1,x2,...
min(x1,x2,...)   - the minimum of x1,x2,...
norm(x)          - the absolute value of x

convert(e)       - convert the expression e into an Dom::ArithmeticalExpression,
		   ie. e itself
++*/

domain Dom::ArithmeticalExpression
  inherits Dom::Expression;
  category Cat::BaseCategory;
    axiom Ax::systemRep;

      zero:= 0;
      
      iszero:= iszero;
      
      one:= 1;

      _plus:= _plus;
      
      _negate:= _negate;
      
      _subtract:= proc(x,y) begin x - y end_proc;

      _mult:= _mult;

      _invert:= _invert;

      intmult:= _mult;

      _power:= _power;

      _divide:= _divide;

      D:= D;

      diff:= diff;

      max:= max;

      min:= min;

      norm:= abs;

      convert:=
      proc(e)
      begin
        if e::dom::expr <> FAIL then
          e:= e::dom::expr(e)
        end_if;
        
        if domtype(e) <> DOM_EXPR then
          if testtype(e, Type::Arithmetical) = TRUE then
            return(e)
          else
            return(FAIL)
          end_if
        else
          // assume everything is ok
          e
        end_if;
      end_proc;

begin
  NIL
end_domain:

