//    
/*++
Dom::BaseDomain -- the base domain of the 'domains'-library

Methods:
equal(x,y)	   - tests if x and y are equal (for Ax::canonicalRep only)
TeX(x)		   - returns string for object x in TeX-format
subs(x,...)	   - returns x
subsex(x,...)	   - returns x

hasProp(a)         - tests if this domain has super-domain, category, axiom
		     or constructor a
getAxioms()        - returns set with direct axioms
allAxioms()        - returns set with all axioms
getSuperDomain()   - returns direct super-domain
allSuperDomains()  - returns list with all super-domains
getCategories()    - returns list with direct categories
allCategories()    - returns list with all categories
whichEntry(e)      - returns domain or category defining entry e
allEntries()       - returns set with all entry names
undefinedEntries() - returns set with all entrys not defined yet
info()		   - prints some information
++*/

domain Dom::BaseDomain

category Cat::BaseCategory;

  interface:= {
		   hold(equal),
		   hold(TeX),
		   hold(subs),
		   hold(subsex),
		   hold(hasProp),
		   hold(getAxioms),
		   hold(allAxioms),
		   hold(getSuperDomain),
		   hold(allSuperDomains),
		   hold(getCategories),
		   hold(allCategories),
		   hold(whichEntry),
		   hold(allEntries),
		   hold(undefinedEntries),
		   hold(info)
		   };

  create_dom:= dom::key;
  
  convert_to:=
    proc(e, T)
    begin
      case T
        of dom do return(e);
        of Dom::Expression do return(dom::expr(e));
      end_case;
      FAIL
    end_proc;

  equal:= if dom::hasProp(Ax::canonicalRep) then
            bool @ _equal
          else
            proc()
            begin
              if (bool@_equal)(args())=TRUE then
                TRUE
              else
                UNKNOWN
              end_if
            end_proc
          end_if;

    TeX:= e->generate::TeX(dom::expr(e));

    subs:= e->e;

    subsex:= e->e;

    hasProp:= proc(e)
                option noDebug;
              begin
                DomainConstructor::hasProp(dom, e)
              end;

    getAxioms:= ()->DomainConstructor::axioms(dom);

    allAxioms:= proc() begin
    	// force loading all categories now 
    	dom::allCategories();
    	dom::axioms
    end_proc;

    getSuperDomain:= ()->dom::super_domains[1];

    allSuperDomains:= ()->dom::super_domains;

    getCategories:= ()->DomainConstructor::categories(dom);

    allCategories:= proc() local i; begin
	// force loading all categories now 
        i:= 1;
        while DomainConstructor::getCategory(dom, i) <> FAIL do
            i:= i+1
        end_while;
        dom::categories
     end_proc;

    whichEntry:= e->DomainConstructor::whichEntry(dom, e);

//    allEntries:= ()->DomainConstructor::allEntries(dom);
    allEntries:=
    proc()
      local DOM;
    begin
      DOM:=dom;
      select(DomainConstructor::allEntries(dom), i->bool(slot(DOM,i)<>FAIL));
    end_proc;

    undefinedEntries:= ()->DomainConstructor::undefinedEntries(dom);
    
    printMethods:=
    proc(SORT = sort, OPT = hold(Table))
      local Methods, Undef, Domains, DOM, DOMN, OUT, M;
      save PRETTYPRINT;
    begin
      if contains({hold(Table), hold(Tree)}, SORT) then
        OPT:= SORT;
        SORT:= id
      end_if;
      
      DOM:= dom;
      Undef:= dom::undefinedEntries();
      Methods:= dom::allEntries() minus Undef;
      Methods:= map(Methods, proc(M)
                             begin
                               [M, expr2text(DomainConstructor::whichEntry(DOM, M))]
                             end_proc);
  
      DOMN:= expr2text(dom);
      OUT:= select(Methods, X->op(X, 2) = DOMN);
      Methods:= Methods minus OUT;
      OUT:= SORT(map([op(OUT)], op, 1));
      if Undef <> {} then
        Undef:= op(SORT([op(Undef)]))
      else
        Undef:= null()
      end_if;
      
      Methods:= SORT([op(Methods)], _if(SORT = sort, (X, Y)->(op(X, 2) >= op(Y, 2)), null()));
      
      Domains:= SORT([op(map({op(Methods)}, op, 2))]);
  
      
      if OPT = hold(Tree) then
  
        OUT:= append([DOMN], OUT);
        if Undef <> null() then
          OUT:= append(OUT, [["undefined", Undef]])
        end_if;
        for M in Domains do
          OUT:= append(OUT, [M, op(SORT(map([op(select(Methods, X->op(X, 2) = M))], op, 1)))])
        end_for;
        OUT:= adt::Tree(OUT);
        OUT::options({hold(Small)});
        OUT::print();
        return(OUT)
  
      else // Table
  
        PRETTYPRINT:= FALSE;
        print(Unquoted, DOMN);
        output::tableForm(OUT, ", ");
        for M in Domains do
          print();
          print(Unquoted, M);
          output::tableForm(SORT(map([op(select(Methods, X->op(X, 2) = M))], op, 1)), ", ")
        end_for
      end_if
    end_proc;

    info:= proc()
          local axioms, p, nam, tab, expo; 
          save PRETTYPRINT;   
     begin
        PRETTYPRINT:= FALSE;
        p:= ()->(print(Unquoted, args()));
        p("-- Domain:");
	nam:= (if dom::Name = FAIL then dom::key else dom::Name end_if);
        if dom::info_str = FAIL then
	    print(nam)
        else
	    p(expr2text(nam)." -- ".dom::info_str)
        end_if;
        p("");
        p("-- Constructor:");
        print(dom::constructor);
        p("");
        p("-- Super-Domains:");
	output::tableForm(dom::allSuperDomains(),
			  Append = ",", Unquoted, Sort=FALSE);
        p("");
        p("-- Categories:");
	output::tableForm(dom::allCategories(),
			  Append = ",", Unquoted, Sort=FALSE);
        p("");
        axioms := dom::allAxioms();
        if nops(axioms) = 0 then
	    p("-- No Axioms.")
        else
	    p("-- Axioms:");
	    output::tableForm(axioms,
			      Append = ",", Unquoted);
        end_if;
        p("");
        p("-- Entries:");
	output::tableForm(dom::allEntries(), Append = ",", Unquoted);

        // Get the interface and the exported entries
	 tab := dom::interface;
	 if domtype(tab) <> DOM_SET then tab := {}; end_if;
	 if not testtype(tab, Type::SetOf(DOM_IDENT)) then
	     error("in attribute \"interface\"")
	 end_if;

	 expo:= dom::exported;
	 if domtype(expo) <> DOM_SET then expo:= {} end_if;
	 if domtype(dom::_exported) = DOM_SET then
	     expo:= expo union dom::_exported
	 end_if;

         // Print the interface
	 p("");
	 if nops(tab) > 0 then
	     p("-- Interface:");
	     output::tableForm(select(tab, f -> not contains(expo, f)),
			       hold(Append) = ",", Unquoted)
	 else
	     p("-- No Interface.");
	 end_if;

         // Print the exported entries
	 if nops(expo) <> 0 then
	     p("n-- Exported:");
	     output::tableForm(expo, hold(Append) = ",", hold(Unquoted));
	 end_if;
	 null():
    end_proc;

end_domain:

