//               

// stefanw, 12.03.1996 

/*++

Dom::DihedralGroup(n) - dihedral group of order n, i.e. the group generated by
elements s and d such that o(s)=2, o(d)=n and ds=sd^(-1)

n - integer >= 1

An element is represented as a domain element with operands:

0 - domain Dom::DihedralGroup(n)
1 - a list [a,b ] of two integers, with 0<=a<=1 and 0<=b<=n-1
    representing s^a d^b

++*/

domain Dom::DihedralGroup(n)
  inherits Dom::BaseDomain;
  category Cat::Group;
  axiom Ax::canonicalRep;

    size:= 2*n;

    one:= new(dom, [0,0]);


    convert:= (()->((
	case domtype(args(1))
	of dom do 
		return(args(1));
	of DOM_ARRAY do 
		return(dom::convert([op(args(1))]));
	of DOM_LIST do
	 if nops(args(1)) <> 2 then 
		error("List of length two expected");
	 elif {op(map(args(1),domtype)) } <> { DOM_INT } then
		error("List must consist of integers");
	 else
	 	return(new(dom, [op(args(1),1)mod 2,op(args(1),2) mod n]));
	 end_if;
	end_case;
        FAIL
    )));

    convert_to:= (()->((
	case args(2)
	of DOM_LIST do	
		 return(extop(args(1),1));
	of dom do return(args(1));
	end_case;
	FAIL
    )));

    
	

    expr:= (()->( extop(args(1),1) ));  /* gibt nicht DOM_EXPR, sondern
					 DOM_LIST zurueck */ 
					 

    print:= (()->( extop(args(1),1) ));



    _mult:= (()->((
    	if args(0) = 2 then
	    if domtype(args(2)) <> dom or 
	       domtype(args(1)) <> dom then
	    	    FAIL
	    elif op(extop(args(2),1),1) mod 2=0 then
		    new(dom,[op(extop(args(1),1),1) mod 2,
			op(extop(args(1),1),2)+op(extop(args(2),1),2) mod n])
	            // s^a*d^b*d^c gives s^a*d^(b+c) 
	    else  
		    new(dom,[op(extop(args(1),1),1)+1 mod 2,
			op(extop(args(2),1),2)-op(extop(args(1),1),2) mod n])
	            /* s^a*d^b*s*d^c= s^a*d^(b-1)*(d*s)*d^c
				   = s^a*d^(b-1)*s*d^(c-1)
				   =  ...
				   = s^(a+1)*d(c-b)     */
	    end_if
    	elif args(0) = 1 then
    	    args(1)
    	else
    	    _mult(args(1..(args(0) div 2)));
    	    _mult(args(((args(0) div 2) + 1)..args(0)));
	    if (%2)::dom::_mult <> FAIL then (%2)::dom::_mult(%2, %1)
	    elif (%1)::dom::_mult <> FAIL then (%1)::dom::_mult(%2, %1)
	    else _mult(%2, %1)
	    end_if
    	end_if
    )));

    _power:= proc(a:dom, k:DOM_INT)

	begin
	if k<0 then
		return(dom::_power(dom::_invert(a), -k))
	end_if;
	if op(extop(args(1),1),1)=1 then
		if args(2) mod 2 = 0 then 
			new(dom,[0,0])
		else
		   args(1)
		end_if
	else
		new(dom,[0,op(extop(a,1),2)*k mod n])
	end_if
	end_proc;


    _invert:= (()->((
	if op(extop(args(1),1),1)=1 then
		args(1)
	else
		new(dom,[0, n-op(extop(args(1),1),2) mod n])
	end_if
	 )));



//    "_divide" : defined in Cat::Group  

	order:= (()->((	
	 if op(extop(args(1),1),1)=1 then 2
	 else n/igcd(n,op(extop(args(1),1),2))
	 end_if
	)));


    allElements:=
    proc()
      local i,j;
    begin
      [new(dom, [i, j]) $i=0..1 $j=0..n-1]
    end_proc;

    TeX:= (()->(
	expr2text(extop(args(1),1))
    ));

    random:= (()->(	
		new(dom,[random() mod 2,random() mod n])
	));
			
		
begin
    if args(0) <> 1 then error("wrong no of args") end_if;
     if domtype(n) <> DOM_INT then
	 error("argument must be integer")
     end_if;
     if n < 1 then
	 error("argument must be positive")
     end_if
end_domain:

// end of file 
