//    

// Dom::DistributedPolynomial is deprecated
// Please use Dom::UnivariatePolynomial, Dom::MultivariatePolynomial
// or Dom::Polynomial.

/*++ ---------------- DistPoly.mu ---------------------

Description:
This domain represents polynomials  over arbitrary commutative rings. 
It is somehow a basic domain for distributed polynomials from which one can
easy create new distributed polynomial domains.
Most of the functions for DOM_POLY are available.
Note: It is highly recommend to use only coefficient rings with unique zero
      representation.

Call:

 Dom::DistributedPolynomial(Vars, Ring, Order) 
 where
   Vars    => list of indeterminates; 
              empty list denotes arbitrary many indeterminates
              * Default: []
   Ring    => arbitrary commutative ring of the Domains-package;
              * Default: Dom::ExpressionField(normal)
   Order   => set a term order. Currently is possible: 
              LexOrder, DegreeOrder, DegInvLexOrder;
              or any object of type Dom::MonomOrdering          
              * Default: LexOrder

Methods: 

 - used Parameter:
    ++ a,b,t    : this Domain
    ++ c        : Ring
    ++ d,v,ais  : DOM_LIST
    ++ x        : DOM_IDENT
    ++ x0,x1,vs : DOM_EXPR
    ++ eis      : DOM_EXPR
    ++ t    = term  (e.g. x*y)
    ++ d    = degree vector
    ++ v    = variable list
    ++ vs   = sequence of variables 
    ++ ais  = list or set of elements of this Domain
    ++ x    = variable
    ++ x0,x1= delimiter of a range
    ++ eis  = sequence of length nops(Vars) of either ring elements or 
    ++        elements of this domain.
 - adaptIndets(a, b, ...)
    ++ determines the indeterminates of all arguments, extends them such that 
    ++ all have the same indeterminates and returns this adapted arguments.
 - diff(a, vs)
    ++ returns the partial derivative of a w.r.t vs.
 - dimension(ais, <Order>)
    ++ computes the dimension of the affine variety generated by the 
    ++ polynomials in ais. //It is assumed that ais is already a Grbner basis.
 - func_call(a,eis <Expr>)
    ++ applies the sequence eis to the polynomial a. If the option Expr is 
    ++ choosen a is converted into an expression and eis is substituted for
    ++ the variables respectively. In case eis is a sequence of ring elements 
    ++ this function overloads evalp.
 - groebner(ais, <Order>, <Reorder>)
    ++ returns reduced normalized Grbner-basis for the polynomials ais.
    ++ (see GroebnerPackage).
 - ground(a)
    ++ returns the ground term of a, i.e. that term in which the 
    ++ indeterminates of a do not occur.
 - int(a)
 - int(a, x)
 - int(a, x = x0..x1)
    ++ int(a, x) returns the antiderivative of the polynomial a
    ++ with respect to x as an element either of this domain if R is a Field
    ++ or an element of a polynomial domain over Dom::Fraction(R) otherwise, 
    ++ or FAIL if the antiderivative cannot converted into one of the previous
    ++ given domain. If a has only one variable (e.g. if indets(a)=[x]),
    ++ it is possible to call simply int(a).
    ++ int( f, x = x0..x1 ) returns the definite integral of a from x0 to x1,
    ++ or FAIL if the definite integral of a is not an element
    ++ of this domain or an element of a polynomial domain over 
    ++ Dom::Fraction(R).
 - isone(a) 
    ++ tests if a is the multiplicative unit of this domain.
 - printMonomial(c, d, v) 
    ++ returns an ordered expression c*v^d. 
 - printTerm(d)
 - printTerm(d, v) if Vars=[]
    ++ returns an ordered sequence of the indeterminates Vars resp. v 
    ++ (with their powers d).
 - makeIntegral(a)
    ++ multiplies a by the lcm of all coefficients denominators.  
 - monic(a)
    ++ divides a by its leading coefficient, i.e. the leading coefficient of
    ++ of the resulting polynomial is 1.
 - normalForm(a, ais, <Order>)
    ++ returns the normal form of a modulo the polynomials ais.
 - numericSolve(a,..) 
   numericSolve(ais,..)
    ++ tries to find numerically the zeros of a or the system ais. The return
    ++ can be any type returned by numeric::solve.
 - orderedVariableList(a)
    ++ returns the ordered list of variables as specified in generating the
    ++ domain. If no variable was specified, a sorted list of variables is
    ++ returned.
 - ordering
    ++ returns the chosen term order in 'Order'. 
 - realSolve(a,..)
    ++ returns a list representing intervals (also a list) for real roots of 
    ++ the univariate polynomial a. See polylib::realroots.
 - reductum(a)
    ++ returns the reductum of a, i.e  a-lmonomial(a).
 - ringmult(a, c)
    ++ multiplies a by the coefficient ring element c.
 - Rep(a)
    ++ returns the representation of a.
 - sign(a)
    ++ determines the sign of a, which is 0 if a is zero, 1 if a is either
    ++ a positive constant or a positive monomial or an unevaluated positive
    ++ single expression, -1 otherwise.
 - SPolynomial(a,b, <Order>)
    ++ returns the S-Polynomial of a and b.
 - TeXCoeff(c)
    ++ returns a string, which consists of the TeX representation of c.
 - TeXTerm(t)
    ++ returns a string, which consists of the ordered TeX representation of t.
 - variables
    ++ returns the chosen list of variables 'Vars'. 

All Entries:
D, Dpoly, Factor, Rep, SPolynomial, TeX, TeXCoeff, TeXTerm, TeXindet, _div\
ide, _invert, _mult, _negate, _plus, _power, _subtract, allAxioms, allCate\
gories, allEntries, allSuperDomains, associates, characteristic, coeff, co\
effRing, coerce, content, convert, convert_to, create_dom, decompose, degr\
ee, degreevec, diff, dimension, divide, divides, equal, equiv, euclideanDe\
gree, evalp, expr, factor, func_call, gcd, gcdex, getAxioms, getCategories\
, getSuperDomain, groebner, ground, has, hasProp, idealGenerator, indets, \
info, int, intmult, irreducible, isNeg, isUnit, isone, iszero, key, lcm, l\
coeff, ldegree, lmonomial, lterm, mainvar, makeIntegral, mapcoeffs, monic,\
 mult, multcoeffs, new, normalForm, nterms, nthcoeff, nthmonomial, nthterm\
, numericSolve, one, orderedVariableList, ordering, pdioe, pdivide, pivotS\
ize, plus, poly, pquo, prem, primpart, print, printMethods, printMonomial,\
 printTerm, quo, random, realSolve, reductum, rem, resultant, ringmult, si\
gn, solve, sqrfree, subs, subsex, tcoeff, testtype, undefinedEntries, unit\
Normal, unitNormalRep, variables, whichEntry, zero

Example:

>> DP := Dom::DistributedPolynomial([x,y,z],Dom::Integer);

        Dom::DistributedPolynomial([x, y, z], Dom::Integer, LexOrder)

>> p1 := DP(3*x-2);

                                  3 x - 2

>> p2 := DP(3*x^2-2*x+1);

                                 2
                              3 x  - 2 x + 1

>> p3 := DP(5*x^3*y^2*z-z^3+5*y^2+1+x);

                          3  2            2    3
                       5 x  y  z + x + 5 y  - z  + 1

>>  5*p3+2*p1^2*3*p2;   

          4       3  2          3        2               2      3
     162 x  + 25 x  y  z - 324 x  + 270 x  - 115 x + 25 y  - 5 z  + 29


++*/

alias(
      rep(x) = extop(args(x),1)
      ):

domain Dom::DistributedPolynomial(Vars=[],
                               R=Dom::ExpressionField(normal), 
                                  Order=LexOrder)
  local NumVars, IntDom, GcdDom, EucDom, Field, Rs, dummyVar, containsRat,
  normalRepOrder;
  inherits Dom::BaseDomain;
  category if nops(Vars) = 1 then
             Cat::UnivariatePolynomial(R)
           else
             Cat::Polynomial(R)
           end_if;
  axiom    (if R::hasProp(Ax::normalRep)
                //or (R::constructor=Dom::ExpressionField and
		//    R::hasProp(Ax::systemRep))
                then Ax::normalRep end_if),
    (if R::hasProp(Ax::canonicalRep) then Ax::canonicalRep end_if);

  // entries: 

    new:=
    if NumVars = 0 then
      proc(p)
        local pol,v;
      begin
        case args(0)
          of 1 do pol:=poly(expr(p), R);
            case pol
              of FAIL do
                pol:=poly(expr(p),[dummyVar],R);
                if pol=FAIL then error("Illegal argument(s)") end_if;
              otherwise new(dom, subsop(pol,2=sort(op(pol,2))))
            end_case; break;
          of 2 do
            v:=args(2);
            pol:=poly(expr(p),v,R);
            if pol=FAIL then error("Illegal argument(s)") end_if;
                // no further argument test!
                // sort degree vectors and variable list with respect to
                // sysorder
            pol:=normalRepOrder(p,v,R);
            if pol=FAIL then error("Illegal argument(s)")
            else new(dom, pol) end_if;
            break;
          otherwise
            error("Wrong number of arguments")
        end_case;
      end_proc
    else
      proc(p)
        local pol;
      begin
        if args(0) <> 1 then error("Wrong number of arguments") end_if;
        pol := poly(expr(p), Vars, R);
        if pol=FAIL
          then error("Illegal argument(s)")
        else new(dom, pol) end_if
      end_proc
    end_if;

    expr:= ()->expr(rep(1));

    Rep:= ()->rep(1);
    
    subs := p -> dom::new(subs(dom::Rep(p), args(2..args(0))));
    
    subsex := p -> dom::new(subsex(dom::Rep(p), args(2..args(0))));
    
    evalAt :=
    proc(p: dom, at)
      local pp;
    begin
      pp := dom::Rep(p);
      pp := pp | at;
      if domtype(pp) = DOM_POLY then
        dom::new(pp);
      else
        pp;
      end_if;
    end_proc;

    poly:= //dom::Rep;
    proc(a: dom)
      local pol;
    begin
      if args(0)=1 then
        rep(1)
      else
        pol:=poly(expr(a),args(2..args(0)));
        if pol=FAIL then
          FAIL
        else
          pol
        end_if;
      end_if;
    end_proc;
      
//  "print" = dom::expr, 

    convert:=

    proc(a)
      local dta,r,pl,p,RR;
    begin
      dta:=a::dom;

      // handle easy cases
      if dta=dom then
        return(a)
      elif contains({op(Rs),Dom::Integer,DOM_INT},dta) then
        return(dom::new(a))
      end_if;

      // handle special cases
      
      if // this condition may be too lazy. Maybe it would be better
         // to use simply: dta::hasProp(Dom::DistributedPolynomial)
        dta::hasProp(Dom::UnivariateSkewPolynomial)=TRUE or
        dta::hasProp(Dom::DistributedPolynomial)=TRUE and degree(a)<>0 then
        return(FAIL)
      end_if;
      r:=R::convert(a);
      if r<>FAIL then
        return(dom::new(r))
      end_if;
      RR:=R;
      if testtype(a, Type::Arithmetical) or dta = DOM_POLY then 
        if NumVars<>0 then
          pl:=poly2list(poly(a,Vars,hold(Expr)));
          if pl<>FAIL then
            p:=poly(map(pl,e->[RR::convert(op(e,1)),op(e,2)]),Vars,R);
            if p<>FAIL then
              return(new(dom,p));
            end_if;
          end_if;
        else
          p:=poly(a,hold(Expr));
          if p=FAIL then
            p:=poly(a,[dummyVar],hold(Expr));
          end_if;
          pl:=poly2list(p);
          if pl<>FAIL then
            p:=poly(map(pl,e->[RR::convert(op(e,1)),op(e,2)]),op(p,2),R);
            if p<>FAIL then
              return(new(dom,p));
            end_if;
          end_if
        end_if;
      end_if;
      // doing tests if a may be embeddable into dom are rather difficult
      // and are skipped here for the moment
      
      FAIL
    end_proc;
//*/
  
  // Modified by NT 2003/08/26
  indets:= if Vars =[] then ()->({op(op(rep(1), 2))} minus {dummyVar}) else ()->{op(Vars)} end_if;

  freeIndets:= if Vars =[] then ()->({op(op(rep(1), 2))} minus {dummyVar}) else ()->{op(Vars)} end_if;

  orderedVariableList:=
    if Vars =[] then ()->op(rep(1), 2) else ()->Vars end_if;

  mainvar:= if Vars =[] then ()->op(rep(1), 2)[1]
            else ()->Vars[1] end_if;

  ordering:=Order; 

  variables:=Vars;

  coeffRing:= R;
    

  func_call:=
  if NumVars<>0 then
    proc(a:dom)    // option: Expr
      local opt,vals,dt,r,DOM,dynamicMult,dynamicPower,dynamicPowerProduct,
            i,pl;
    begin
      vals:=context([args(2..args(0))]);
      DOM:=dom;
      if nops(vals)=0 then error("Wrong number of arguments") end_if;
      if vals[nops(vals)]=hold(Expr)
        then opt:=TRUE; delete vals[nops(vals)];
      else opt:=FALSE
      end_if;
      //if nops(vals)>NumVars or nops(vals)=0
      if nops(vals)<>NumVars 
        then error("Wrong number of arguments") end_if;
      if opt then
          r:=subs(expr(a),zip(Vars,vals,_equal),EvalChanges)
      else
        dt:=map({op(vals)},domtype);
        case dt
          of {dom} do // this is a first very simple implementation
            
            // local procedures to compute expensive power products more
            // efficient
            dynamicMult:=
            proc(p1,p2)
              option remember;
            begin
              DOM::mult(p1,p2)
            end_proc;
        
            dynamicPower:=
            proc(p,n)
              option remember;
            begin
              if iszero(n) then
                DOM::one
              elif n=1 then
                p
              else
                 dynamicMult(dynamicPower(p,n-1),p)
               end_if
             end_proc;
             
             dynamicPowerProduct:=
             proc(v,pis)
               local i;
             begin
               DOM::mult(dynamicPower(pis[i],v[i]) $ i=1..nops(v))
             end_proc;

            pl:=revert(poly2list(poly(a)));
            if NumVars=1 then
              r:=dom::plus(dom::ringmult(dynamicPower(op(vals),pl[i][2]),
                                         pl[i][1])
                           $ i=1..nops(pl));
            else
              r:=dom::plus(dom::ringmult(dynamicPowerProduct(pl[i][2],vals),
                                         pl[i][1])
                           $ i=1..nops(pl));
            end_if;
            break;
          //of {R} do // does not work because R could have Ax::systemRep
          otherwise
            if nops(dt)=1 and testtype(vals[1],R) then
              r:=evalp(dom::poly(a),op(zip(Vars,vals,_equal)));
              //if {domtype(r)}<>dt then r:=R::new(r) end_if;
            else
             error("Illegal arguments. Perhaps, you should use option 'Expr'.")
            end_if;
        end_case;
      end_if;
      r
    end_proc
  end_if;
      
 /*
  ------------------

   Ringoperationen

  ------------------
 */

  // Modified by NT 2003/08/26
  adaptIndets:= if NumVars = 0 then  
    proc() 
      local pols, varset;
      begin
        case args(0)
          of 1 do return(rep(1));
          of 0 do return();
        end_case;
        pols := map(args(), extop, 1);
        varset := { map(pols, e->op(e,2)) };
        if nops(varset) = 1 then
	    // All the polynomials already share the same indeterminates,
	    // in the same order; this is the a very probable case, so
            // bail out to save time
	    return(pols);
	end_if;
        varset := map(varset, op) minus {dummyVar};
        if nops(varset) = 1 then
            // We have a mix of constant polynomials (with dummy
            // variables) and univariate polynomials; we just have to
            // fix the variable in the formers
            return(map(pols,
		       proc(p)
		       begin
			   if op(p,2)=[dummyVar] then
			       assert(degree(p)=0);
			       poly([[coeff(p,0), 0]], [op(varset,1)],R);
			   else
			       p;
			   end_if;
		       end_proc));
        end_if;
        assert(nops(varset)>=2);
         // the following two lines are wrong for the paranoia input:
         // P([[1/x,[0,1]],[2,[1,2]]],[y,x])+P(x+2)
         // varset:=sort([op(varset)]);
         // map(pols,subsop,2=varset)
         map(pols,  // try to adapt via poly2list
             proc(p)
               local v,mv,pl,ns;
             begin
               // first fill up with missing variables
               mv:=[op(varset minus {op(op(p,2))})];
	       ns:=0$nops(mv);
	       if op(p,2)=[dummyVar] then
                 // constant polynomial
	         assert(degree(p)=0);
                 v := mv;
	         pl:=[[coeff(p,0),[ns]]];
               elif nops(mv)=0 then
	         // optimization when there are no new variables
                 // note that the order may be incorrect
                 v := op(p,2);
                 pl:=poly2list(p);
               else
	         v:=op(p,2).mv;
                 pl:=map(poly2list(p),e->[op(e,1),[op(op(e,2)),ns]]);
               end_if;
               normalRepOrder(pl,v,R)
             end_proc
             )
      end_proc 
     end_if;

  plus:= if NumVars <> 0 then  
      proc() local i; begin
        //if testargs() then
          if map({args()}, domtype) <> {dom} then  
             //error("cannot add arguments") end_if 
             return(FAIL)
        end_if;
        new(dom, _plus(extop(args(i), 1) $ i=1..args(0)))
      end_proc
    else
      proc() begin
        //if testargs() then
          if map({args()}, domtype) <> {dom} then  
            //error("cannot add arguments") end_if 
             return(FAIL)
        end_if;
        new(dom, _plus(dom::adaptIndets( args() ))) 
      end_proc
    end_if;

  _plus:= proc() 
      local sel, h, h1, s, r, DOM, t;
      begin
        //if testargs() then
        //  if map({args()},domtype) minus 
        //     {dom,op(Rs),Dom::Integer,DOM_INT} <> {}
        //    then  error("cannot add arguments") end_if
        //end_if;
        case args(0)
          of 0 do return( dom::zero );
          of 1 do return( args() );
        end_case;
        DOM:=dom;
        s:=split([args()],()->contains({DOM,op(Rs),Dom::Integer,DOM_INT},
                                       domtype(args(1))));
        //sel := split([args()], testtype, Dom::Integer);
        sel := split(s[1], testtype, Dom::Integer);
        h   := (Dom::Integer)::_plus(op(sel[1]));
        sel := split(sel[2], ()->contains(Rs, domtype(args(1))) ); 
        h1   := R::_plus(op(sel[1]), R::convert(h));
        if h1=FAIL then 
           h1:=R::_plus(op(map(sel[1],R::convert)),R::convert(h));
           if h1 = FAIL then
              return(FAIL);
           end_if;
        end_if;
        r:=dom::plus(op(sel[2]), dom::new(h1)); 
        if nops(s[2])=0 then r
        else
          h:=_plus(op(s[2]));
          if (t:=dom::coerce(h))<>FAIL then
            dom::plus(r,t)
          elif h::dom::hasProp(Dom::DistributedPolynomial)=TRUE then
            if (t:=h::dom::coerce(r))<>FAIL then
              h::dom::_plus(t,h)
            else
              FAIL
            end_if;
          else
            h::dom::_plus(r,h)
          end_if
        end_if
      end_proc;

  _negate:=
    proc(a=FAIL)
    begin
      if //testargs() and
        domtype(a)<>dom then 
        a:=dom::new(a);
        if a=FAIL then //error("cannot negate argument")
             return(FAIL)
        end_if;
      end_if;
      new(dom, -dom::Rep(a))
    end_proc;

  mult:= if NumVars <> 0 then 
      proc() local i; begin
        //if testargs() then
          if map({args()}, domtype) <> {dom} then 
             //error("cannot multiply arguments") end_if 
             return(FAIL)
        end_if;
        new(dom, _mult(rep(i) $ i=1..args(0)))
      end_proc
    else
      proc() begin
        //if testargs() then
          if map({args()}, domtype) <> {dom} then 
             //error("cannot multiply arguments") end_if 
             return(FAIL)
        end_if;
        new(dom, _mult(dom::adaptIndets( args() )))
      end_proc
    end_if;

  _mult:= proc() 
      local sel, h, s, r, DOM, t;
      begin
        //if testargs() then 
        //  if map({args()},domtype) minus 
        //     {dom,op(Rs),Dom::Integer,DOM_INT} <> {}
        //    then  error("cannot multiply arguments") end_if
        //end_if;
        case args(0)
          of 0 do return( dom::one );
          of 1 do return( args() );
        end_case;
        DOM:=dom;
        s:=split([args()],()->contains({DOM,op(Rs),Dom::Integer,DOM_INT},
                                       domtype(args(1))));
        sel := split(s[1], testtype, Dom::Integer);
        if iszero(nops(sel[1])) then
          h := (Dom::Integer)::one; 
        else
          h := (Dom::Integer)::_mult(op(map(sel[1], coerce, Dom::Integer)))
        end_if;
        sel := split(sel[2], ()->contains(Rs, domtype(args(1))) ); 
        if iszero(nops(sel[1])) then
          h := R::intmult(R::one, h)  
        else
          h := R::intmult(R::_mult(op(sel[1])), h)
        end_if;
        case nops(sel[2])
          of 0 do
            if NumVars=0 then
              r:=new(dom, poly(h,[dummyVar],R))
            else
              r:=new(dom, poly(h,Vars,R))
            end_if;
            break;
          of 1 do
            r:=dom::ringmult(op(sel[2]), h); break;
          otherwise
            r:=dom::ringmult(dom::mult(op(sel[2])), h)
        end_case;
        if nops(s[2])=0 then 
          r
        else
          h:=_mult(op(s[2]));
          if (t:=dom::coerce(h))<>FAIL then
            dom::mult(r,t)
          elif h::dom::hasProp(Dom::DistributedPolynomial)=TRUE then
            if (t:=h::dom::coerce(r))<>FAIL then
              h::dom::_mult(t,h)
            else
              FAIL
            end_if;
          else
            h::dom::_mult(r,h)
          end_if
        end_if
      end_proc;

  ringmult:= proc() begin
      //if testargs() then
        if coerce(args(2), R) = FAIL then 
           //error("not a ring element ") end_if 
             return(FAIL)
      end_if;
      new(dom, multcoeffs(rep(1), args(2)))
  end_proc;

  intmult:= proc() begin
      //if testargs() then
        if not contains({DOM_INT, Dom::Integer}, domtype(args(2))) 
           then //error("not an Integer") end_if
             return(FAIL)
      end_if;
      new(dom, multcoeffs(rep(1), args(2)))
  end_proc;

  _power:=
    proc(a=FAIL,n=FAIL)
    begin
      if testargs() then
        if domtype(a)<>dom then
          error("cannot compute power of arguments")
        end_if;
        if not contains({DOM_INT, Dom::Integer}, domtype(n)) 
               or (args(2) < 0)
           then error("expected a NonNegativeInteger as exponent") end_if  
      end_if;
      new(dom, _power(rep(1), args(2)))
  end_proc;

  zero:= dom::new(R::zero);
 
  one:= dom::new(R::one);

 /*
  ------------------------------------

   Operationen zur Konsistenzwahrung 

  ------------------------------------
 */

  _invert:=
  proc(aa=FAIL)
    local a;
  begin
    if testargs() then
      if domtype(aa)<>dom then error("cannot invert argument") end_if
    end_if;
    if dom::degree(aa) > 0 then return(FAIL) end_if;
    a:= R::_invert(dom::lcoeff(aa));
    if a = FAIL then FAIL else dom::convert(a) end_if
  end_proc;

  _divide:= 
     if IntDom then
       if NumVars <> 0 then
         proc(a,b)
         begin
           if domtype(a)<>dom then a:=dom::new(a) end_if;
           if domtype(b)<>dom then b:=dom::new(b) end_if;
           if a=FAIL or b=FAIL then return(FAIL) end_if;
           divide(dom::poly(a), dom::poly(b), hold(Exact));
           if % = FAIL then FAIL else new(dom, %) end_if
         end_proc
       else
         proc(a,b)
         begin
           if domtype(a)<>dom then a:=dom::new(a) end_if;
           if domtype(b)<>dom then b:=dom::new(b) end_if;
           if a=FAIL or b=FAIL then return(FAIL) end_if;
           divide(dom::adaptIndets(a,b), hold(Exact));
           if % = FAIL then FAIL else new(dom, %) end_if
         end_proc
       end_if
      end_if;

 // "divide" see section 'Standardarithmetik' 

//  norm:= ()->(if args(0) = 1 then norm(rep(1)) 
//              else norm(rep(1), args(2..args(0))) end_if);

//  diff:= ()->(if args(0)= 1 then args(1)
//              else new(dom, diff(rep(1),args(2..args(0)))) end_if);

  diff:=
    proc(a)
      local vars,index;
    begin
      if args(0)=1 then a
      else
        vars:=dom::orderedVariableList(a);
        // This works because contains returns zero, if an element do not
        // occur in the given list.
        index:=map([args(2..args(0))], e->contains(vars,e));
        if has(index,0) then dom::zero
        else dom::Dpoly(index,a)
        end_if
      end_if
    end_proc;

 // "intmult" see near "_mult" 

  random:= if NumVars <> 0 then
      ()->(SEED := random(); new(dom, polylib::randpoly(Vars, R )))
    else
     proc() local i, r;
       begin
        SEED := random(); 
        r := [];
        for i from 1 to random(1..4)() do
          r := append(r, genident() )
        end_for;
        new(dom, polylib::randpoly(r, R ))
     end_proc
    end_if; 
      
  solve:=
    proc(a)
      local ais,opt,set;
    begin
      if args(0)=1 then opt:=null()
      else opt:=args(2..args(0))
      end_if;
      set:=FALSE;
      case domtype(a)
        of dom do solve(dom::poly(a),opt); break;
        of DOM_SET do set:=TRUE;
        of DOM_LIST do
          ais:=op(a);
          if map({ais},domtype)<>{dom} then
            error("all elements should be of the same type")
          end_if;
          if NumVars=0 then solve(if set then {dom::adaptIndets(ais)}
                                  else [dom::adaptIndets(ais)]
                                  end_if,opt)
          else solve(map(if set then {ais} else [ais]
                         end_if,dom::poly),opt)
          end_if; break;
        otherwise
          error("an element or set or list of elements of this domain".
                " expected as first argument")
      end_case
    end_proc;


  solve_sys:=
    proc()
    begin
      dom::solve(args())
    end_proc;  
      
  numericSolve:=
    proc(a)
      local dom2expr,ais,opt,set;
    begin
      dom2expr:= // tries to convert a dom into Expr
        proc(p)
        begin
          p:=subsop(p,3=Expr);
          if domtype(p)<>DOM_POLY then
            error("not convertible in basic polynomial type")
          else p
          end_if
        end_proc;
      
      if args(0)=1 then opt:=null()
      else opt:=args(2..args(0))
      end_if;
      set:=FALSE;
      case domtype(a)
        of dom do numeric::solve(dom2expr(dom::poly(a)),opt); break;
        of DOM_SET do set:=TRUE;
        of DOM_LIST do
          ais:=op(a);
          if map({ais},domtype)<>{dom} then
            error("all elements should be of the same type")
          end_if;
          if NumVars=0 then numeric::solve(map(if set
                                                 then {dom::adaptIndets(ais)}
                                               else [dom::adaptIndets(ais)]
                                               end_if,dom2expr),
                                           opt)
          else numeric::solve(map(map(if set then {ais} else [ais]
                                      end_if,dom::poly),dom2expr),
                              opt)
          end_if; break;
        otherwise
          error("an element or set or list of elements of this domain".
                " expected as first argument")
      end_case
    end_proc;

  realSolve:= 
  if NumVars=1 then
    proc(a)
    begin
      a:=subsop(dom::poly(a),3=Expr); // tries to convert a domain into Expr
      if domtype(a)<>DOM_POLY then
        error("not convertible in basic polynomial type")
      end_if;
      polylib::realroots(a,args(2..args(0)))
    end_proc
  end_if;

//  int:= ()->(dom::new(int(rep(1),args(2..args(0)))));
  int:=
    proc()
      local r,cr;
    begin
      r:=int(rep(1),args(2..args(0)));
      if type(r)="int" then FAIL
      elif domtype(r)=DOM_POLY then
        cr:=op(r,3);
        if cr=R then
          new(dom,r)
        else
          dom::constructor(if strmatch(expr2text(dom::key),"\\[.*\\]") then
                             Vars
                           else op(Vars)
                           end_if,cr,Order)(r) 
        end_if
      else
        dom::convert(r)
      end_if
    end_proc;
        
  has:=()->has(rep(1),args(2..args(0)));

  pivotSize:=dom::degree;

 /*
  --------------------------------------

   Zugriffsfunktionen auf Koeffizienten

  --------------------------------------
 */
  
  degree:= ()->(if args(0) = 1 then degree(rep(1))
                else degree(rep(1), args(2..args(0))) end_if);

  euclideanDegree:= if NumVars=1 then dom::degree end_if;

  degreevec:= ()->(if args(0) = 1 then degreevec(rep(1), Order)
                   else degreevec(rep(1),args(2..args(0))) end_if);
     
  ldegree:= ()->(if args(0) = 1 then ldegree(rep(1))
                else ldegree(rep(1), args(2..args(0))) end_if);

  lcoeff:= ()->(if args(0) = 1 then
                  lcoeff(rep(1), Order)
                elif args(0)=2 and type(args(2))<>DOM_LIST then
                  lcoeff(rep(1), args(2))
                elif NumVars=1 and type(args(2))=DOM_LIST then
                  lcoeff(rep(1), args(2..args(0)))
                else // basic polynomial domain may return a poly(...)
                  dom::new(lcoeff(rep(1), args(2..args(0))))
                end_if);

  lmonomial:= ()->(if args(0) = 1 then
                     new(dom, lmonomial(rep(1), Order))
                   else
                     map(lmonomial(rep(1), args(2..args(0))), dom::new)
                   end_if);

  lterm:= ()->(if args(0) = 1 then new(dom, lterm(rep(1), Order))
               else dom::new(lterm(rep(1), args(2..args(0))))
               end_if);

//  reductum:= ()->(if args(0) = 1 then args(1)- dom::lmonomial(args(1))
//                  else args(1)-dom::lmonomial(args(1..args(0))) end_if);
  reductum:= ()->(if args(0) = 1 then
                    new(dom, lmonomial(rep(1), Order, Rem)[2])
                  else
                    dom::new(lmonomial(rep(1), args(2..args(0)), Rem)[2])
                  end_if);

  nterms:= ()->nterms(rep(1));

//  tcoeff:= ()->tcoeff(rep(1));
  tcoeff:= ()->if iszero(args(1)) then R::zero
               else nthcoeff(rep(1),nterms(rep(1)),args(2..args(0)))
               end_if;

//  nthcoeff:= ()->nthcoeff(rep(1), args(2..args(0)));
  nthcoeff:=
    proc(a,n,ord=Order)
      local lm;
    begin
      lm:=polylib::sortMonomials(rep(1),ord);
      if nops(lm)>=n then lcoeff(lm[n]) else FAIL end_if
    end_proc;
      
//  nthmonomial:= ()->new(dom, nthmonomial(rep(1), args(2..args(0))));
  nthmonomial:=
    proc(a,n,ord=Order)
      local lm;
    begin
      lm:=polylib::sortMonomials(rep(1),ord);
      if nops(lm)>=n then dom::new(lm[n]) else FAIL end_if
    end_proc;
      
//  nthterm:= ()->new(dom, nthterm(rep(1), args(2..args(0))));
  nthterm:=
    proc(a,n,ord=Order)
      local lm;
    begin
      lm:=polylib::sortMonomials(rep(1),ord);
      if nops(lm)>=n then dom::new(lterm(lm[n])) else FAIL end_if
    end_proc;
      
  coeff:= 
        proc(pp, x, n)
          local cl, p;
        begin
          p:=pp; // to avoid warnings
          if x = All then
            if dom::iszero(p) then return(null()); end_if;
            if Order<>LexOrder then
              // TODO
              // warning("coeff(..., All) for other orders than LexOrder not implemented yet")
            end_if;
            return(coeff(rep(1), args(2..args(0))));
          end_if;
          if dom::iszero(p) then return( R::zero ) end_if;
          cl := [];
          case args(0)
            of 1 do
              while not dom::iszero(p) do
                cl := append(cl, dom::lcoeff(p));
                p  := dom::reductum(p)
              end_while;
              return( op(cl) );
            otherwise
              if NumVars=1 then
                coeff(rep(1), args(2..args(0)))
              else // basic polynomial domain may return a poly(...)
              dom::new( coeff(rep(1), args(2..args(0))) )
              end_if;
          end_case
        end_proc;

  mapcoeffs:= ()->dom::new(mapcoeffs(rep(1), args(2..args(0))));

  ground:=()->ground(rep(1));

    
  normal:= if R::normal <> FAIL then
             f -> dom::mapcoeffs(f, R::normal)
           end_if;
    
  sortMonomials:=
  proc(a, ord)
  begin
    map(polylib::sortMonomials(rep(1), ord), dom::convert)
  end_proc;

  poly2list :=
  proc(a)
  begin
      if args(0)=1 then
	  poly2list(rep(1));
      else
	  map(dom::sortMonomials(args()), op@poly2list)
      end_if;
  end_proc;
 /*
  --------------------------------------

   Standardarithmetik auf den Elementen

  --------------------------------------
 */      

  gcd:= 
    if GcdDom then 
      if NumVars <> 0 then 
       proc() local i; begin
	   new(dom, gcd(rep(i) $ i=1..args(0)))
       end_proc
      else 
       ()->new(dom, gcd(dom::adaptIndets(args())))  
      end_if 
    end_if;

  gcdex:= 
    if GcdDom and NumVars = 1 then 
       ()->(case args(0)
              of 2 do gcdex(rep(1), rep(2)); break;
              of 3 do gcdex(rep(1), rep(2), args(3)); break;
              otherwise error("wrong number of arguments")
              end_case; 
              (new(dom, %[1]), new(dom, %[2]), new(dom, %[3])))  
    end_if;

  lcm:=
    if GcdDom then
      if NumVars <> 0 then  
	proc() local i; begin
	    new(dom, lcm(rep(i) $ i=1..args(0)))
	end_proc
      else 
        ()->new(dom, lcm(dom::adaptIndets(args())))  
      end_if 
    end_if;

  pdioe:=
    if Field and NumVars = 1 then  // Field is necessary to use pdioe 
      proc()                       // from solvelib :-/
        local u;
      begin
        u:=solvelib::pdioe(rep(1),rep(2),rep(3));
        if u=FAIL then FAIL
        else
          new(dom,op(u,1)),new(dom,op(u,2))
        end_if;
      end_proc;
    end_if;

  content:= 
     if GcdDom then ()->(content(rep(1)); R::new(%))  end_if;

  multcoeffs:= ()->dom::new(multcoeffs(rep(1), args(2)));

  divide:=
    if Field then
       if NumVars=1 or NumVars=0 then
         proc(a,b)
           local s, DOM;
         begin
           DOM:=dom;
           if domtype(a)<>dom then a:=dom::new(a) end_if;
           if domtype(b)<>dom then b:=dom::new(b) end_if;
           if a=FAIL or b=FAIL then return(FAIL) end_if;
           s:=divide(dom::poly(a), dom::poly(b), args(3..args(0)));
           if s = FAIL then FAIL else op(map([s], e->new(DOM, e))) end_if
         end_proc
       elif iszero(R::characteristic()) then
         proc(a,b)
           local s;
         begin
           if domtype(a)<>dom then a:=dom::new(a) end_if;
           if domtype(b)<>dom then b:=dom::new(b) end_if;
           if a=FAIL or b=FAIL then return(FAIL) end_if;
           if args(0)=2 then
             s:=divide(expr(a),expr(b), [dom::orderedVariableList(a)[1]])
           elif contains(indets(a),args(3)) then
             s:=divide(expr(a),expr(b),[args(3)],args(4..args(0)));
           elif contains({hold(Rem), hold(Quo)},args(3)) then
             s:=divide(expr(a),expr(b), [dom::orderedVariableList(a)[1]],
                       args(3))
           elif args(3) = hold(Exact) then
             s:=divide(expr(a),expr(b), dom::orderedVariableList(a),
                       args(3))
           else
             error("Illegal arguments")
           end_if;
           if s = FAIL then
             FAIL
           else
             s:=map([s], dom::new);
             if has(s,FAIL) then FAIL else op(s) end_if
           end_if
         end_proc
       end_if
    end_if;
         
  pdivide:= if NumVars = 1 then  // pdivide(p,q) -> b,s,r mit b*p = s*q+r 
    proc() 
     begin
       case args(0) 
         of 1 do error("Illegal arguments"); 
         of 2 do 
           pdivide(rep(1), rep(2));
           (%[1], new(dom, %[2]), new(dom, %[3])); break;
         otherwise
           pdivide(rep(1), extop(args(2), 1), args(3..args(0)));
           new(dom, %)
       end_case
     end_proc end_if;

  pquo:= if NumVars = 1 then ()->dom::pdivide(args(1..args(0)), Quo) end_if;

  prem:= if NumVars = 1 then ()->dom::pdivide(args(1..args(0)), Rem) end_if;

  //evalp:= ()->dom::new(evalp(rep(1), args(2..args(0))));
  evalp:=
     proc()
       local r;
       begin
         r:=evalp(rep(1), args(2..args(0)));
         if domtype(r)=DOM_POLY then
           dom::new(r)
         else
           r
         end_if
     end_proc;

  icontent:= if R = Dom::Integer then ()->icontent(expr(rep(1)), Vars) end_if;

  iszero:= ()->iszero(rep(1));

  isone:= ()->bool(args(1) = dom::one);

  Dpoly:= ()->(if args(0) = 1 then
                 if nops(dom::indets(args(1)))=1 then
                   new(dom, polylib::Dpoly(rep(1)))
                 else error("Two arguments expected")
                 end_if
               else new(dom, polylib::Dpoly(args(1), rep(2))) end_if);

  D:= dom::Dpoly;

  factor:= 
    if R = Dom::Integer or R = Dom::Rational or 
       //  (R::constructor = Dom::IntegerMod and Field) 
        Field then
       proc(xx) local f, i, x; begin
         x:= extop(xx,1);
	 f:= Factored::convert_to(factor(x),DOM_LIST);
	 f:= [ dom::new(f[1]),
	   (new(dom, f[2*i]), f[2*i+1]) $i=1..((nops(f)-1) div 2) ];
         Factored::create( f,"irreducible",dom )
       end_proc
      else ()->FAIL
     end_if;

  sqrfree:= 
    if R = Dom::Integer or R = Dom::Rational or 
       // (R::constructor = Dom::IntegerMod and Field) 
      Field then
       proc(xx)
         local f, i, x;
       begin
         x:= extop(xx,1);
         f:= Factored::convert_to(polylib::sqrfree(x),DOM_LIST);
         f:= [ R::new(f[1]),
              (new(dom, f[2*i]), f[2*i+1]) $i=1..((nops(f)-1) div 2) ];
         Factored::create( f,"squarefree",dom )
       end_proc
     end_if;

  decompose:= proc()
     begin
       case args(0) 
         of 1 do if nops(indets(args(1))) <> 1 then 
                    error("sorry, you must specify a variable") end_if;
                    polylib::decompose(rep(1)); break;
         of 2 do polylib::decompose(rep(1), args(2)); break;
       end_case;
       map(%, ()->new(dom, args(1)) )
     end_proc;

  resultant:= if R::_divide<>FAIL then
    if NumVars <> 0 then
      ()->(case args(0) 
              of 2 do dom::convert(polylib::resultant(rep(1), rep(2))); break;
	      of 3 do dom::convert(polylib::resultant(rep(1),rep(2),args(3)));
	              break;
              otherwise error("wrong no of arguments")
           end_case) 
    else
      ()->(case args(0) 
	     of 2 do dom::convert(polylib::resultant(
				  dom::adaptIndets(args()))); break;
	     of 3 do dom::convert(polylib::resultant(
	                          dom::adaptIndets(args(1),args(2)),args(3))); 
                     break;
              otherwise error("wrong no of arguments")
            end_case) 
    end_if
   end_if;

  monic:= 
    if Field then
       (a)->if iszero(a) then a
              else
                dom::mapcoeffs(a,_mult,_invert(lcoeff(a)))
            end_if
    end_if;

  makeIntegral:=
    if R::constructor=Dom::ExpressionField then
     //there is no reasonable lcm for this purpose in Dom::ExpressionField
      proc(a:dom):dom
      begin
        mapcoeffs(a,_mult, R(lcm(op(map([coeff(dom::Rep(a))],denom@expr)))))
      end_proc
    elif R::denom<>FAIL and GcdDom then
      proc(a:dom):dom
      begin
        mapcoeffs(a,_mult, lcm(op(map([coeff(dom::Rep(a))],denom))))
      end_proc
    end_if;

      
 /*
  ------------------------------

   Groebner Basis Operationen

  ------------------------------
 */

  groebner:= if Field and not(iszero(NumVars)) then
    proc(ais) // optional: order, reorder 
      local order, DOM,gb,vars;
      begin
        if testargs() then
          if not testtype([op(ais)], Type::ListOf(dom)) then
            error("all polynomials needs to have the same type") end_if
        end_if;
        DOM:=dom;
        if args(0)=1 then order:=Order else order:=args(2..args(0)) end_if;
        if contains({order},hold(Reorder)) then
          gb:=groebner::gbasis(map([op(ais)], dom::poly),order);
          if nops(gb)=0 then return(gb)
          else vars:=op(gb[1],2)
          end_if;
          DOM:=dom::constructor(vars,R,Order);
          map(gb,DOM::new)
        else
          map(groebner::gbasis(map([op(ais)], dom::poly),order),
              ()->new(DOM,args(1)) )
        end_if
      end_proc
    end_if;

  normalForm:= if Field and not(iszero(NumVars)) then
    proc(a, ais) // optional: order 
      local order;
      begin
        if testargs() then
          if not testtype([a, op(ais)], Type::ListOf(dom)) then
            error("all polynomials needs to have the same type") end_if
        end_if;
        if args(0)=2 then order:=Order else order:=args(3) end_if;
        new(dom,groebner::normalf(rep(1),(map([op(ais)],dom::poly),order))) 
      end_proc
    end_if;

  SPolynomial:= if Field and not(iszero(NumVars)) then
    proc(a, b) // optional: order 
      local order;
      begin
        if testargs() then
          if not testtype([a, b], Type::ListOf(dom)) then
            error("both polynomials needs to have the same type") end_if
        end_if;
        if args(0)=2 then order:=Order else order:=args(3) end_if;
        new(dom,groebner::spoly(rep(1),rep(2),order)) 
      end_proc
    end_if;

  dimension:= if Field and not(iszero(NumVars)) then
    proc(ais) // optional: order 
      local order;
      begin
        if testargs() then
          if not testtype([op(ais)], Type::ListOf(dom)) then
            error("all polynomials needs to have the same type") end_if
        end_if;
        if args(0)=1 then order:=Order else order:=args(2) end_if;
        groebner::dimension(map([op(ais)], dom::poly),order)
      end_proc
    end_if;

 /*
  ---------------------

   Ausgabeoperationen

  ---------------------
 */


  sign:= proc(p) 
     local ep;
     begin
       if dom::iszero(p) then return( 0 ) end_if;
       ep := dom::expr(p);
       case type(ep)
         of "_plus" do return( hold(sign)(p) );
         of "_mult" do if sign(op(ep, nops(ep))) <> -1 
                         then return( 1 )
                         else return( -1 ) end_if;
         of DOM_IDENT do return( 1 );
         otherwise
           if dom::isNeg(p) then return(-1) else return(1) end_if
       end_case
    end_proc;

  isNeg:=
    proc(a)
      local lc, res;
    begin
      if degree(a)=0 then
        res:=R::isNeg(a);
        if res=FAIL then FALSE else res end_if
      else
        lc:=lcoeff(a);
        res:=lc::dom::isNeg(lc);
        if res=FAIL then FALSE else res end_if
      end_if
    end_proc;
      
/*
  isNeg:=
    proc(p)
      local pp;
    begin
      pp:=dom::sign(p);
      if type(pp)="sign" then FALSE
      elif pp>=0 then FALSE
      else TRUE
      end_if
    end_proc;
*/

  print:= 
     proc(pp) 
       local monos, lm, vars, p,DOM;
       begin
         p := extop(pp,1);
         if iszero(p) then return( R::zero ) else monos:=[] end_if;
         vars:=op(p,2);
         DOM:=dom;
         lm:=polylib::sortMonomials(p,Order);
         monos:=map(lm,
                 e->DOM::printMonomial(lcoeff(e,Order),degreevec(e),vars));
         if nops(monos) = 1 then
           monos[1]
         else
           hold(_plus)( op(monos) )
         end_if
     end_proc;

  expr2text := pp -> expr2text(dom::key)."(".expr2text(expr(pp)).")";

  printMonomial:= 
     proc(c,dvec,vars)
       local term, ec;
       begin
         //term:=dom::printTerm(dvec,vars);
         term:=op(zip(vars,dvec,
                  (v,d)->if d=0 then null() elif d=1 then v else v^d end_if));
         if iszero(nops(term)) 
           then return(R::print(c))
           else   // prevent some brackets and coefficients like 1, -1 
             ec := R::expr(c);
             case type(ec)
               of "_plus" do return(hold(_mult)(R::print(c),term));
               of "_mult" do if sign(op(ec, nops(ec))) <> -1
                         then return(hold(_mult)(R::print(c),term))
                         else return(hold(_mult)(R::print(-c),term,-1)) end_if;
             otherwise
               if strmatch(strprint(R::one), "^(\r|\n|\b)*1(\r|\n|\b)*$")
                 then case nops([term]) //prevent output error with hold(_mult)
                    of 1 do if c = R::one then return(term) 
                             elif c = -R::one then return(-term)
                               elif sign(c) <> -1  
                                 then return(hold(_mult)(R::print(c),term)) 
                                 else 
                                   return(hold(_mult)(R::print(-c),term,-1)) 
                             end_if;
                    otherwise
                      if c = R::one then return(hold(_mult)(term)) 
                      elif c = -R::one then return(hold(_mult)(term,-1))
                      //else return(hold(_mult)(R::print(c),term))
                      elif sign(c) <> -1
                        then return(hold(_mult)(R::print(c),term))
                      else return(hold(_mult)(R::print(-c),term,-1))
                      end_if;
                    end_case
               else return(hold(_mult)(R::print(c),term)) end_if
             end_case;
           end_if
     end_proc;

  printTerm:=
    proc(dvec,vars=Vars)
    begin
      op(zip(vars,dvec,
             (v,d)->if d=0 then null() elif d=1 then v else v^d end_if))
    end_proc;

  //TeXindet:= ()->( "{".expr2text(args(1))."}" );
  TeXindet:= ()->( "{".generate::TeX(args(1))."}" );

  TeXCoeff:= proc(x)
     local str, ex;
     begin
       str := R::TeX(x);
       ex  := R::expr(x);
       case type(ex)
         of "_plus" do str := " + {\\left( ".str." \\right)}"; break;
         of "_mult" do if sign(op(ex, nops(ex))) <> -1 then 
                         str := " + {".str."}" end_if; break;
         otherwise
           if contains({DOM_INT, Dom::Integer, DOM_RAT, Dom::Rational},
                       domtype(x)) or 
              R::constructor = Dom::ExpressionField 
             then case x
                    of  R::one do str := " + "; break;
                    of -R::one do str := " - "; break;
                    otherwise
                      if sign(op(ex, nops(ex))) <> -1 then 
                         str := " + {".str."}"
                        else str := " - {".R::TeX(-x)."}" end_if
                  end_case
             else str := " + {\\left( ".str." \\right)}" end_if
       end_case;
       str
     end_proc;

  TeXTerm:= proc(x)
     local vars, dvec, str, i;
     begin
        dvec := dom::degreevec(x);
        vars := map(dom::orderedVariableList(x), dom::TeXindet);
        str := ""; 
        for i from 1 to nops(vars) do
          if dvec[i] = 1 then str := str.vars[i]
           elif dvec[i] > 1 then str := str.vars[i]."^{".expr2text(dvec[i])."}"
          end_if
        end_for;
        str
      end_proc;

   TeX:=
   proc(x)
     local str, ex,lx,i, prTerm;
   begin
     prTerm := proc(x)
                 local lTerm, lCoeff;
               begin
                 lCoeff := dom::TeXCoeff(dom::lcoeff(x));
                 lTerm := dom::TeXTerm(dom::lterm(x));
                 if lTerm <> "" and length(lCoeff) > 3 then
                   lCoeff."\\,".lTerm
                 else
                    lCoeff.lTerm
                 end_if;
               end_proc;
     if iszero(dom::degree(x)) then
       str:="{".R::TeX(dom::lcoeff(x))."}"
     else
       str := prTerm(x);
       if length(str) >= 3
         and str[1..3] = " + " then str := str[4..-1]
       end_if;
       
       lx:= polylib::sortMonomials(x, Order);
       if nops(lx) = 1 then
         return(str)
       end_if;
       str:=str._concat(prTerm(lx[i]) $ i=2..nops(lx)-1);
       x:=lx[nops(lx)];
       if dom::degree(x)>0 then
         str := str.prTerm(x)
       else
         case type( (ex := dom::expr(x)) )
           of "_mult" do if sign(op(ex, nops(ex))) <> -1 then
                           str := str." + {".R::TeX(dom::lcoeff(x))."}"
                         else
                           str := str." - {".R::TeX(-dom::lcoeff(x))."}"
                         end_if; break;
           otherwise
             ex := R::TeX(dom::lcoeff(x));
             if ex[1] = "-" then
               str := str." - {".ex[2..-1]."}"
             else
               str := str." + {".ex."}" end_if
         end_case
       end_if;
     end_if;
     str
   end_proc;

/* body of the domain */

begin
  if args(0) > 3 then error("Wrong no of args") end_if;
  if domtype(Vars) <> DOM_LIST then error("Illegal indeterminates") end_if;
  if Vars <> [] then
    if traperror(poly(1,Vars)) <> 0 then
      error("Illegal indeterminates") end_if
  else
    if R::hasProp(Cat::Polynomial)=TRUE then
      error("A polynomial domain in arbitrary many indeterminates over the ".
            "coefficient ring ".expr2text(R)." is not legal.")
    end_if
  end_if;
  if R::dom=DOM_DOMAIN then
    if R::hasProp(Dom::BaseDomain) = FAIL then
      R := Dom::ExpressionField(normal)
    elif not(R::hasProp(Cat::CommutativeRing)) then
      error("Illegal coefficient ring")
    end_if;
  else
    error("Illegal coefficient ring");
  end_if;
  //The following if-statement would nearly always solve the termination 
  //problem ("unique zero") by polynomial division and yield a correct degree.
  //if R::constructor=Dom::ExpressionField and R::hasProp(Ax::systemRep) then
  //  R:=Dom::ExpressionField(id, iszero@normal)
  //end_if;
  if not contains({LexOrder, DegreeOrder, DegInvLexOrder}, Order)
    and type(Order)<>Dom::MonomOrdering then
    error("Unknown monomial ordering");
  end_if;
  containsRat:=FALSE;
  if iszero(R::characteristic)
    then traperror((containsRat:=testtype(1/3,R)))
  //else traperror((containsRat:=testtype(1/(R::characteristic+1),R)))
  end_if;
  if containsRat=TRUE   
    then Rs := {R, DOM_RAT}
  else Rs := {R}
  end_if;
  dummyVar:= matrix::internalPolyVar; 
  NumVars := nops(Vars);
  IntDom  := bool(R::hasProp(Cat::IntegralDomain));
  GcdDom  := bool(R::hasProp(Cat::GcdDomain));
  EucDom  := bool(R::hasProp(Cat::EuclideanDomain));
  Field   := bool(R::hasProp(Cat::Field));
  if NumVars=0 then
    normalRepOrder:=
    proc(p,v,r)
      local d,i,j;
    begin
      d:=sort([[v[j],op(p[i],[2,j]) $ i=1..nops(p)]
               $ j=1..nops(v)], (a,b)->sysorder(a[1],b[1]));
      d:=[ [op(d[j],i) $ j=1..nops(v)] $ i=1..nops(p)+1];
      poly([[op(p,[i,1]),d[i+1]] $ i=1..nops(p)],d[1],r);
    end_proc
  end_if;


     
end_domain:

unalias( rep ):
