//   


//   Interval - domain of intervals

//   Interval(a, b) : the open interval ]a,b[.
//   Interval([a] , b) : the semi-open interval [a,b[
//   Interval(a, [b]): the semi-open interval ]a,b]

//   An interval consists of two operands:
//   both can be a list of one element representing a real number, 
//   or an arithmetical expression representing a real number,
//   or +/- infinity

//   The available methods are:
//   _plus, sign, _mult, _negate, _invert, _power, iszero, convert,
//   random, exp, _union, _intersect, and some special functions

 




domain Dom::Interval

  local mapB;
  inherits  Dom::BaseDomain;
  category  Cat::Set, Cat::AbelianMonoid;
  // in this order!! because otherwise there would be no search
  // beyond "toBeDefined", and the overloading mechanism of Cat::Set
  // would not work

// no axioms

// methods

  borders:= x -> [dom::left(x), dom::right(x)];

  // op = extop 
  
  nops:= 2;
  
  subsop:= proc(iv, EQ)
             local ind;
           begin
             if type(EQ) <> "_equal" then
               error("wrong type of second argument")
             end_if;
             ind:= op(EQ, 1);
             case ind
               of 0 do
                 return(op(EQ, 2)(dom::op(iv)))
               of 1 do
                 return(dom::new(op(EQ, 2), dom::rightB(iv)))
               of 2 do
                 return(dom::new(dom::leftB(iv), op(EQ, 2)))
               otherwise
                 error("wrong substitution index")
             end_case
           end_proc;

  // Grenze links immer offen
  left:=
  proc(x: dom)
  begin
    if type(op(x, 1)) = DOM_LIST then
      op(x, [1, 1])
    else
      op(x, 1)
    end_if;  
  end_proc;

  // Grenze links, offen oder [geschlossen]
  leftB:= x -> extop(x, 1);

  // Grenze rechts immer offen
  right:=
  proc(x: dom)
  begin
     if type(op(x, 2)) = DOM_LIST then
      op(x, [2, 1])
    else
      op(x, 2)
    end_if;  
  end_proc;

  // Grenze rechts, offen oder [geschlossen]
  rightB:= x -> extop(x, 2);

  interior:= x -> dom::new(dom::left(x), dom::right(x));

  // TRUE/FALSE offen/geschlossen
  isleftopen:= x -> bool(type(op(x, 1)) <> DOM_LIST);
  isrightopen:= x ->  bool(type(op(x, 2)) <> DOM_LIST);

  isopen:= x -> _lazy_and(dom::isleftopen(x), dom::isrightopen(x));
  isclosed:= x ->  _lazy_and(not dom::isleftopen(x), not dom::isrightopen(x)); 
    
  // beide Grenzen "floatable"
  isfloat:=
  proc(x: dom)
    local res;
  begin
    _lazy_and(traperror((res:= float({op(x)}))) = 0,
    map(res, type) subset {DOM_FLOAT, DOM_COMPLEX})
  end_proc;  
    

  // isPoint(iv)
  // returns a condition equivalent to iv = {x} for some x  
  isPoint:=
  proc(iv)
  begin
    dom::isclosed(iv) and dom::left(iv) = dom::right(iv)
  end_proc;

  // nur intern
  _is:=
    proc(EXPR, FL = FALSE)
    begin
      if FL then
        map(EXPR, float)
      else
        is(EXPR, Goal = TRUE)
      end_if
    end_proc;

  subs:=
    proc(x:dom)
    begin
      dom::new(subs(dom::leftB(x), args(2..args(0))),
               subs(dom::rightB(x), args(2..args(0))))
    end_proc;

  
  subsleft:=
  proc(x:dom, l)
  begin
    if not dom::isleftopen(x) then
      l:= [l]
    end_if;
    dom::new(l, dom::rightB(x))
  end_proc;

  subsright:=
  proc(x:dom, r) 
  begin
    if not dom::isrightopen(x) then
      r:= [r]
    end_if;
    dom::new(dom::leftB(x), r)
  end_proc;
  

  // substitute only the borders
  subsvals:=
    proc(x:dom, l, r)
    begin
      if not dom::isleftopen(x) then
        l:= [l]
      end_if;
      if not dom::isrightopen(x) then
        r:= [r]
      end_if;
      dom::new(l, r)
    end_proc;


  // expr - converts into a range
  // if two arguments are given, the second must be an identifier
  // in that case, expr returns an expression whose solution is
  // the given interval (this is necessary for the property mechanism)
  expr:=
    proc(iv:dom, x)
    begin
      case args(0)
        of 1 do
          if dom::isPoint(iv)=TRUE then
            return({dom::left(iv)})
          else
            return(hold(Dom::Interval)(dom::leftB(iv), dom::rightB(iv)))
          end_if
        of 2 do
// needed for 'is': +/-infinity is not in R_
          if domtype(x) = stdlib::Infinity then
            return(FALSE)
          end_if;

          if dom::isPoint(iv)=TRUE then
            return(x = dom::left(iv))
          else

            if dom::left(iv) = -infinity then
              return(_if(dom::isrightopen(iv), hold(_less), hold(_leequal))(x, dom::right(iv)))
            elif dom::right(iv) = infinity then
              return(_if(dom::isleftopen(iv), hold(_less), hold(_leequal))(dom::left(iv), x))
            else
              return(_if(dom::isrightopen(iv), hold(_less), hold(_leequal))(x, dom::right(iv)) and
                     _if(dom::isleftopen(iv), hold(_less), hold(_leequal))(dom::left(iv), x))
            end_if
          end_if
        otherwise
          error("wrong no of arguments")
      end_case
    end_proc;

  // overloading needed for _in

  set2expr:=
    proc(x:dom, u)
    begin
      dom::expr(x, u)
    end_proc;

    
    
  print:=
  proc(iv: dom)
    local str1, str2, base, height, mkBracket, splitString;
    save TEXTWIDTH;
  begin
    if Pref::mackichan() = TRUE then
      return(hold(Interval)(dom::leftB(iv), dom::rightB(iv)))
    end_if;   
    
    if PRETTYPRINT then
      splitString :=
      proc(str)
        local i, j, strings, aboveBase, belowBase;
      begin
        if sysname() <> "MSDOS" then
          // strip last newline
          str := str[1..-2];
          str := stringlib::split(str, "\n\n")
        else
          // strip last newline
          str := str[1..-3];
          str := stringlib::split(str, "\r\n\r\n")
        end_if;

        for i from 2 to nops(str) do
          strings := stringlib::split(str[i], "\b");
          if nops(strings) = 2 then
            [aboveBase, belowBase] := strings;
          else
            [aboveBase, belowBase] := [strings[1], "   "];
          end_if;
          aboveBase := stringlib::split(aboveBase, "\n");
          belowBase := stringlib::split(belowBase, "\n");
          if map({op(aboveBase)}, _index, 1..3) union
            map({op(belowBase)}, _index, 1..3) = {"   "} then
            // strip leading 3 blanks
            aboveBase := map(aboveBase, _index, 4..-1);
            belowBase := map(belowBase, _index, 4..-1);
            str[i] := _concat((aboveBase[j], "\n") $ j = 1..nops(aboveBase)-1,
                              aboveBase[-1], "\b",
                              (belowBase[j], "\n") $ j = 1..nops(belowBase)-1,
                              belowBase[-1]);
          end_if;
        end_for;

        op(map(str, stdlib::Exposed))
      end_proc;
      
      mkBracket :=
      proc(symb, heigth, base)
        local str, i;
      begin
        if heigth <= 2 then
          return(stdlib::Exposed(symb));
        end_if;

        // heigth is >=3
        if symb = "(" then
          str := "/ \n";
        elif symb = "[" then
          str := "-- \n";
        elif symb = ")" then
          str := " \\\n";
        elif symb = "]" then
          str := " --\n";
        end;

        for i from 2 to height - 1 do
          if symb = "(" then
            str := str."| ";
          elif symb = "[" then
            str := str."|  ";
          elif symb = ")" then
            str := str." |";
          elif symb = "]" then
            str := str."  |";
          end;
          if i = base then
            str := str."\b";
          else
            str := str."\n"
          end_if;
        end_for;

        if symb = "(" then
          str := str."\\ \n";
        elif symb = "[" then
          str := str."-- \n";
        elif symb = ")" then
          str := str." /\n";
        elif symb = "]" then
          str := str." --\n";
        end;

        stdlib::Exposed(str);
      end_proc;

      TEXTWIDTH := TEXTWIDTH - 2;
      str1 := strprint(All, dom::left(iv));
      TEXTWIDTH := TEXTWIDTH - 3;
      str2 := strprint(All, dom::right(iv));

      if str1[1][1] = "\n" then
        str1[1] := str1[1][2..-1];
        str1[6] := str1[6]-1;
      elif str1[1][1..2] = "\r\n" then
        str1[1] := str1[1][3..-1];
        str1[6] := str1[6]-1;
      end_if;
      if str2[1][1] = "\n" then
        str2[1] := str2[1][2..-1];
        str2[6] := str2[6]-1;
      elif str2[1][1..2] = "\r\n" then
        str2[1] := str2[1][3..-1];
        str2[6] := str2[6]-1;
      end_if;

      // common base line
      base := max(str1[6], str2[6]);
      height := max(str1[2]+base-str1[6], str2[2]+base-str2[6]);

      if str1[2] = str1[4] and height = str1[2] or
        str2[2] = str2[4] and height = str2[2] then
        height := height - 1
      end_if;

      _outputSequenceINFINITE(mkBracket(_if(dom::isleftopen(iv), "(", "["), height, base),
                      splitString(str1[1]),
                      stdlib::Exposed(", "),
                      splitString(str2[1]),
                      mkBracket(_if(dom::isrightopen(iv), ")", "]"), height, base)
                      );
    else
      // PRETTYPRINT = FALSE
      _if(dom::isleftopen(iv), "(", "[").	
        expr2text(dom::left(iv), dom::right(iv)).
        _if(dom::isrightopen(iv), ")", "]")
    end_if;
  end_proc;
  
    
  

  expr2text:=
    proc(i:dom)
    begin
      "Dom::Interval(".
      expr2text(dom::leftB(i)).
      ", ".
      expr2text(dom::rightB(i)).
      ")"
    end_proc;

  Content :=
    proc(Out, i : dom)
      local Closure;
    begin
      if i::dom::isleftopen(i) then
        if i::dom::isrightopen(i) then
          Closure := "open"
        else
          Closure := "open-closed"
        end_if
      else
        if i::dom::isrightopen(i) then
          Closure := "closed-open"
        else
          Closure := "closed"
        end_if
      end_if;
      Out::Cinterval(["closure"=Closure],
                     Out(i::dom::left(i)),
                     Out(i::dom::right(i)))
    end_proc;

  TeX :=
    proc(i : dom)
    begin
      if i::dom::isleftopen(i) then
        "\\left(" else "\\left[" end_if.
        generate::tex(i::dom::left(i), output::Priority::Noop).", ".
        generate::tex(i::dom::right(i), output::Priority::Noop).
        if i::dom::isrightopen(i) then
          "\\right)" else "\\right]" end_if
    end_proc;

  equal:=
    proc(x:dom, y)
    begin
      if type(y) <> dom then
        FALSE
      else
        bool(dom::borders(x) = dom::borders(y))
      end_if
    end_proc;


  evaluate:=
    proc(x: dom)
    begin
      dom::new(eval(op(x, 1)), eval(op(x, 2)))
    end_proc;

    
  convert:=
  proc(x)
  begin
    case type(x) 
    of dom do
      return(x)
    of "Interval" do
      // x = Type::Interval(a, b, nrange)
      return(dom::new(op(x, [3, 1]), op(x, [3, 2])) intersect property::prop2set(op(x, [3, 3])))
    of "_range" do
      return(dom::new(op(x, 1), op(x, 2)))
    of DOM_LIST do 
      if nops(x) <> 2 then
        return(FAIL)
      else  
        return(dom::new([op(x, 1)], [op(x, 2)]))
      end_if
    otherwise
      return(FAIL)
    end_case;
  end_proc;  
    
  new:=
    proc(l, r): Type::Set
      local iv, check, checkNumber;
    begin
      check:=
      proc(a): DOM_BOOL 
      begin
        if type(a) = DOM_LIST then
          if nops(a) <> 1 then
            error("Illegal argument to Dom::Interval::new")
          else  
            checkNumber(op(a, 1))
          end_if
         else 
          checkNumber(a)
         end_if    
       end_proc;
       
       checkNumber:=
       proc(a): DOM_BOOL
       begin
         if type(a) = DOM_COMPLEX then
           FALSE
         elif not contains(        
           {stdlib::Infinity, DOM_INT, DOM_RAT, DOM_FLOAT, DOM_IDENT, DOM_EXPR}, domtype(a)
           ) then
           error("Illegal argument")
         else
           TRUE       
         end_if       
       end_proc;
          
      case args(0)
      	 of 1 do
               iv:= dom::convert(l);
               if iv = FAIL then
                 error("Illegal argument")
               end_if;
               return(iv)
             of 2 do
               if type(l) = piecewise then
                 return(piecewise::extmap(l, Dom::Interval::new, r))
               elif type(l) = DOM_LIST and type(op(l, 1)) = piecewise then
                 return(piecewise::extmap(op(l, 1),  X -> Dom::Interval::new([X], r)))
               elif type(r) = piecewise then
                 return(piecewise::extmap(r, X -> Dom::Interval::new(l, X)))  
               elif type(r) = DOM_LIST and type(op(r, 1)) = piecewise then
                 return(piecewise::extmap(op(r, 1), X -> Dom::Interval::new(l, [X])))  
               end_if;
               if not check(l) or not check(r) then 
                 return({})
               end_if;                 
               case l 
                 of [-infinity] do 
                 l:= -infinity;
                 break
               of infinity do
               of [infinity] do 
                 return({})
               end_case;
               case r
                 of [infinity] do 
                  r:= infinity;
                  break
                of -infinity do
                of [-infinity] do 
                 return({})
               end_case;
              
               if l=-infinity and r=infinity then
                 return(R_)
               end_if;  
               iv:= new(dom, l, r);    
               break
             otherwise
               error("Wrong number of args")
           end_case;
      if dom::isPoint(iv) = TRUE then
        iv := {dom::left(iv)}
      else
        iv := dom::emptycheck(iv)
      end_if;
      if indets( [args()] ) minus Type::ConstantIdents = {} then sysassign( Dom::Interval::new( args() ), iv ); end_if;
      iv 
    end_proc;
	
    hull := x -> hull(extop(x));

  // emptycheck - returns the input interval if it is nonempty
  //              or the empty set otherwise
    emptycheck:=
    proc(x:dom)
      local l,r;
    begin
      l:= dom::left(x); r:= dom::right(x);
      if l = r then
        if dom::isleftopen(x) or dom::isrightopen(x) then
          return({})
        else
          return({l})
        end_if
      end_if;  
      if is(_if(dom::isleftopen(x) or dom::isrightopen(x),
                  _leequal, _less)(r, l)) = TRUE then
        return({})
      end_if;
      return(x)
    end_proc;

    simplify:= x -> dom::emptycheck(x);

    normal:= 
    proc(x, options)
    begin
      if args(0) >=2 and (type(options) = DOM_TABLE and options[List] = TRUE) or contains({args()}, List) then 
        error("Option List not allowed for intervals")
      else  
     	  x 
      end_if
    end_proc;


    // overload property::normalGroebner
    normalGroebner:=
    proc(iv)
      local l, r, lnew, rnew;
    begin
      l:= dom::leftB(iv);
      r:= dom::rightB(iv);
      lnew:= property::normalGroebner(l, args(2..args(0)));
      rnew:= property::normalGroebner(r, args(2..args(0)));
      if lnew <> l or rnew <> r then
        dom::new(lnew, rnew)
      else
        iv
      end_if
    end_proc;
    
    // overload Simplify::complexity
    complexity:=
    proc(iv)
    begin
      100 +
      2.5*(Simplify::complexity(dom::left(iv))+
           Simplify::complexity(dom::right(iv)))
    end_proc;

  bin_plus:=
    proc(r:dom, s:dom) : Type::Union(Dom::Interval, solvelib::BasicSet, DOM_SET)
    begin
      dom::new(
               if not dom::isleftopen(r) and not dom::isleftopen(s) then
                 [dom::left(r) + dom::left(s)]
               else
                 dom::left(r) + dom::left(s)
               end_if,
               if not dom::isrightopen(r) and not dom::isrightopen(s) then
                 [dom::right(r) + dom::right(s)]
               else
                 dom::right(r) + dom::right(s)
               end_if
               )
    end_proc;

  mapplus:= (iv, x) -> dom::mapBorders(iv, _plus, x);

  inhomog_plus:=
  table(DOM_SET     = proc(iv:Dom::Interval, S:DOM_SET)
                      begin
                        _union(op(map(S, _plus, iv)))
                      end_proc,

        DOM_INT     = dom::mapplus,
        DOM_RAT     = dom::mapplus,
        DOM_FLOAT   = dom::mapplus,

        DOM_COMPLEX = proc(iv:Dom::Interval, c:DOM_COMPLEX)
                        local g;
                      begin
                        g:= genident();
                        Dom::ImageSet(c + g, g, iv)
                      end_proc,

        DOM_EXPR    = proc(iv:Dom::Interval, xpr:DOM_EXPR)
                        local g;
                      begin
                        case type(xpr)
                          of "_union" do
                            return(map(xpr, _plus, iv))
                          of "_intersect" do
                          of "_minus" do
                            return(FAIL)
                        end_case;
                        if is(xpr in R_, Goal = TRUE) then
                          Dom::Interval::mapplus(iv, xpr)
                        else
                          g:= genident();
                          Dom::ImageSet(xpr + g, g, iv)
                        end_if
                      end_proc,

        DOM_IDENT   = proc(iv:Dom::Interval, ident:DOM_IDENT)
                        local g:DOM_IDENT;
                      begin
                        if is(ident, Type::Real)=TRUE then
                          Dom::Interval::mapplus(iv, ident)
                        else
                          g:=genident();
                          Dom::ImageSet(ident+g, g, iv)
                        end_if
                      end_proc,

        stdlib::Infinity = ((iv, inf) -> {inf})
        );


  // sign - returns the set of possible signs
  sign:=
    proc(x:dom)
      local L1, L2, L3, L4, L5, L6, L6n;
    begin
      /* L1 means: interval is negative, does not contain 0 */
      /* L2 means: interval is non positive, does contain 0 */
      /* L3 means: interval is positive, does not contain 0 */
      /* L4 means: interval is non negative, does contain 0 */
      if dom::isrightopen(x) then
        L1 := dom::right(x)<=0;
        L2 := FALSE;
      else
        L1 := dom::right(x)<0;
        L2 := dom::right(x)=0 and dom::left(x)<dom::right(x);
      end_if;
      if dom::isleftopen(x) then
        L3 := dom::left(x)>=0;
        L4 := FALSE;
      else
        L3 := dom::left(x)>0;
        L4 := dom::left(x)=0 and dom::left(x)<dom::right(x);
      end_if;
      /* L5 means: interval contains any sign */
      L5 := dom::left(x)<0 and dom::right(x)>0;
      /* L6 means: interval is empty */
      /* L6n means: interval is not empty */
      if dom::isrightopen(x) or dom::isleftopen(x) then
        L6 := dom::left(x)>=dom::right(x);
        L6n := dom::left(x)<dom::right(x);
      else
        L6 := dom::left(x)>dom::right(x);
        L6n := dom::left(x)<=dom::right(x);
      end_if;
      piecewise([L1 and L6n, {-1}], [L2, {-1, 0}], [L5, {-1, 0, 1}], [L3 and L6n, {1}], [L4 and L6n, {0, 1}], [L6, {}]);
    end_proc;

  signIm:=proc(x:dom)
    begin
      -dom::sign(x);
    end_proc;

  dirac:=
    proc(x:dom)
      local L1, L1n, L2, L3, L4, L4n;
    begin
      /* cases:
       * 0 in x => dirac(0)
       * x\{0}<>{} => 0
       * x = {} => {}
       */
      /* L1 means: interval contains 0 (and is therefore not empty) */
      /* L1n means: interval does not contain 0 */
      if dom::isleftopen(x) then
        L1 := dom::left(x)<0;
        L1n := dom::left(x)>=0;
      else
        L1 := dom::left(x)<=0;
        L1n := dom::left(x)>0;
      end_if;
      if dom::isrightopen(x) then
        L1 := L1 and dom::right(x)>0;
        L1n := L1n or dom::right(x)<=0;
      else
        L1 := L1 and dom::right(x)>=0;
        L1n := L1n or dom::right(x)<0;
      end_if;
      /* L2 means: interval is not empty and contains at least one value <> 0 */
      /* L3 means: interval equals {0} = [0, 0] */
      /* L4 means: interval is empty */
      /* L4n means: interval is not empty */
      if dom::isrightopen(x) or dom::isleftopen(x) then
        L2 := dom::left(x)<dom::right(x);
        L3 := FALSE;
        L4 := dom::left(x)>=dom::right(x);
        L4n := dom::left(x)<dom::right(x);
      else
        L2 := dom::left(x)<=dom::right(x) and dom::left(x)<>0 or dom::right(x)<>0;
        L3 := dom::left(x)=0 and dom::left(x)=0;
        L4 := dom::left(x)>dom::right(x);
        L4n := dom::left(x)<=dom::right(x);
      end_if;
      piecewise([L1 and L2, {0, dirac(0)}], [L3, {dirac(0)}], [L1n and L4n, {0}], [L4, {}]);
    end_proc;

  heaviside:=
    proc(x:dom)
      local L1, L2, L3, L4, L5, L6, L6n;
    begin
      /* L1 means: interval is negative, does not contain 0 */
      /* L2 means: interval is non positive, does contain 0 */
      /* L3 means: interval is positive, does not contain 0 */
      /* L4 means: interval is non negative, does contain 0 */
      if dom::isrightopen(x) then
        L1 := dom::right(x)<=0;
        L2 := FALSE;
      else
        L1 := dom::right(x)<0;
        L2 := dom::right(x)=0 and dom::left(x)<dom::right(x);
      end_if;
      if dom::isleftopen(x) then
        L3 := dom::left(x)>=0;
        L4 := FALSE;
      else
        L3 := dom::left(x)>0;
        L4 := dom::left(x)=0 and dom::left(x)<dom::right(x);
      end_if;
      /* L5 means: interval contains any sign */
      L5 := dom::left(x)<0 and dom::right(x)>0;
      /* L6 means: interval is empty */
      /* L6n means: interval is not empty */
      if dom::isrightopen(x) or dom::isleftopen(x) then
        L6 := dom::left(x)>=dom::right(x);
        L6n := dom::left(x)<dom::right(x);
      else
        L6 := dom::left(x)>dom::right(x);
        L6n := dom::left(x)<=dom::right(x);
      end_if;
      piecewise([L1 and L6n, {0}],
        [L2, {0, heaviside(0)}],
        [L5, {0, heaviside(0), 1}],
        [L3 and L6n, {1}],
        [L4 and L6n, {heaviside(0), 1}],
        [L6, {}]);
    end_proc;

    bin_mult:=
    proc(r:dom, s:dom) : Type::Union(Type::Set, DOM_FAIL)
      local posmult, splitiv, multlists, uni;
    begin
      // reduce everything to nonnegative numbers, then do a case analysis 
      posmult:= 
      proc(J1, J2) 
        local l, r;
      begin
        if J1={} or J2={} then 
          return({})
        end_if;
        if J1::dom::leftB(J1) = [0] or J2::dom::leftB(J2) = [0] then
          l:= [0]
        elif not (J1::dom::isleftopen(J1) or J2::dom::isleftopen(J2)) then
          l:= [J1::dom::left(J1) * J2::dom::left(J2)]
        else
          l:= J1::dom::left(J1) * J2::dom::left(J2)
        end_if;  
        if not (J1::dom::isrightopen(J1) or J2::dom::isrightopen(J2)) then
          r:= [J1::dom::right(J1) * J2::dom::right(J2)]
        else
          r:= J1::dom::right(J1) * J2::dom::right(J2)
        end_if;
        Dom::Interval(l, r) 
      end_proc;
      
      splitiv:= 
      proc(J)
        local l, r;
      begin
        [l, r]:= J::dom::borders(J);
        piecewise([r <= 0 and l<=0, [J, {}]],
        [l >= 0 and r>=0, [{}, J]],
        [l < 0 and r > 0, [Dom::Interval(J::dom::leftB(J), [0]), Dom::Interval([0], J::dom::rightB(J))]]
        )
      end_proc;
      
      uni:= 
      proc()
        local argv, l1, l2, dummy;
      begin
        argv:= select([args()], _unequal, {});
        [l1, argv , dummy]:= split(argv, J -> (Dom::Interval::leftB(J) = [0]));
        [l2, argv, dummy]:= split(argv, J -> (Dom::Interval::rightB(J) = [0]));
        // now l1 = those intervals with left border zero 
        //     ll2 = those with right border zero
        while nops(l1) > 0 and nops(l2) > 0 do 
          argv:= argv.[Dom::Interval(Dom::Interval::leftB(l2[1]), Dom::Interval::rightB(l1[1]))];
          delete l1[1];
          delete l2[1]
        end_while;  
        _union(op(argv), op(l1), op(l2))
      end_proc;  
          
      multlists:= 
      proc(l1, l2)
      begin
        uni(posmult(l1[2], l2[2]), -posmult(-l1[1], l2[2]), -posmult(-l2[1], l1[2]), posmult(-l1[1], -l2[1]))
      end_proc;  
      
      piecewise::insert(piecewise::zip(splitiv(r), splitiv(s), multlists), [solvelib::isEmpty(r) or solvelib::isEmpty(s), {}])
    end_proc;

  mapmult:=
    proc(iv, x)
    begin
      if x > 0 then
        dom::mapBorders(iv, _mult, x);
      elif x=0 then
        {0}
      else
        dom::new(mapB(dom::rightB(iv), _mult, x),
                 mapB(dom::leftB(iv), _mult, x))
      end_if
    end_proc;

  mapmultparam:=
    proc(iv: Dom::Interval, x: Type::Arithmetical)
      local gen, multx1, multx2;
    begin
      multx1:= a -> if type(a)=stdlib::Infinity then a else a*x end;
      multx2:= a -> if type(a)=stdlib::Infinity then -a else a*x end;
      if is(x, Type::Real) = TRUE then
        piecewise([x > 0, dom::mapBorders(iv, multx1)],
                  [x < 0, dom::new(mapB(dom::rightB(iv), multx2),
                 mapB(dom::leftB(iv), multx2))],
                [x=0 , {0}])
      else
        gen:= genident();
        Dom::ImageSet(x*gen, gen, iv)
      end_if
    end_proc;

  inhomog_mult:=
  table(DOM_SET      = proc(iv, S)
                       begin
                         _union(op(map(S, _mult, iv)))
                       end_proc,

        DOM_INT      = dom::mapmult,
        DOM_RAT      = dom::mapmult,
        DOM_FLOAT    = dom::mapmult,

        DOM_COMPLEX  = proc(iv: Dom::Interval, c: DOM_COMPLEX):
                         Type::Union(Type::Set, DOM_FAIL)
                         local gen;
                       begin
                         gen:= genident();
                         Dom::ImageSet(c*gen, gen, iv)
                       end_proc,

        DOM_EXPR     = proc(iv: Dom::Interval, xpr):
                         Type::Union(Type::Set, DOM_FAIL)
                         local gen1, gen2;
                       begin
                         case type(xpr)
                           of "_union" do
                             return(map(xpr, _mult, iv))
                           of "_intersect" do
                           of "_minus" do
                             gen1:= genident();
                             gen2:= genident();
                             return(Dom::ImageSet(gen1*gen2, [gen1, gen2], [iv, xpr]))
                         end_case;
                         if testtype(xpr, Type::Arithmetical) then
                           Dom::Interval::mapmultparam(args())
                         else
                           FAIL  
                         end_if
                       end_proc,

        DOM_IDENT    = dom::mapmultparam,
        solvelib::BasicSet = proc( iv: Dom::Interval, bs : solvelib::BasicSet )
                      begin
                        case bs
                          of C_ do return( C_ );
                          of R_ do
                          of Q_ do return( R_ );
                        end_case;
                        return( FAIL );
                      end_proc,

        stdlib::Infinity = proc(iv, inf)
                             local l, r;
                           begin
                             l:= iv::dom::left(iv);
                             r:= iv::dom::right(iv);
                             piecewise([r<=0 and l<=r, {-inf} ],
                                       [l<0 and r>0, {inf, -inf}],
                                       [l>r, {}],
                                       [l>=0 and l<=r, {inf}]
                                       )
                           end_proc
        );

  _negate:=
    proc(r:dom): Type::Set
    begin
      dom::interchangeMapBorders(r, _negate)
    end_proc;

  _subtract:=
    proc(r, s)
    begin
      r+_negate(s)
    end_proc;

  _invert:=
    proc(iv: Dom::Interval) : Type::Set
      local l, r, lb, rb;
    begin
      if iv = dom::zero then
        return({})
      end_if;

      [lb, rb]:= [op(iv)];
      [l, r]:= dom::borders(iv);

      return(piecewise([l>0 and r>0 or
                        l<0 and r<0, Dom::Interval(mapB(rb, _invert),
                                                   mapB(lb, _invert)
                                                   )],
                       [l>r, {}],
                       [l=0, dom::new(mapB(rb, _invert), infinity)],
                       [r=0, dom::new(-infinity, mapB(lb, _invert))],
                       [l < 0 and r > 0,
                        dom::new(-infinity, mapB(lb, _invert))
                        union
                        dom::new(mapB(rb, _invert), infinity)
                        ]
                       ))
    end_proc;

  // _divide: necessary to handle case x/x correctly
  _divide:= (x, y) -> x*_invert(y);


  bin_power:=
  proc(r:dom, n:dom) : Type::Union(Type::Set, DOM_FAIL)
  begin
    exp(n*dom::ln(r))
  end_proc;

  leftpownum:=
  proc(r: dom, n) : Type::Union(Type::Set, DOM_FAIL)
    local left, right, negpow:DOM_PROC;
  begin
    // local method negpow(iv): compute the set of all
    // a^n for a in iv, where a consists of negative
    // numbers
    negpow:=
    proc(iv)
      local X;
    begin
      X:= genident();
      Dom::ImageSet(X*exp(PI*I*n), X,
                    Dom::Interval::mapBorders(-iv, _power, n) )
    end_proc;

    if n = 0 then
      dom::one
    elif n = 1 then
      r
    elif n = -1 then
      dom::_invert(r);
    elif n < 0 then
      r:= dom::_invert(r);
      if type(r) = "_union" then
        map(r, dom::leftpownum, -n)
      elif type(r) = piecewise then
        piecewise::extmap( r, _power, -n)
      else
        dom::leftpownum(r, -n)
      end_if
    elif specfunc::frac(n) <> 0 or n mod 2 = 0 then
      // split r=[a, b] into [a, 0) and [0, b]
      [left, right]:= dom::borders(r);
      piecewise([left < 0 and right <=0, negpow(r)],
                [left < 0 and right > 0,
                 negpow(dom::new(dom::leftB(r), [0]), n)
                 union
                 dom::mapBorders(dom::new([0], dom::rightB(r)), _power, n)
                 ],
                [left >=0,
                 dom::mapBorders(r, _power, n)
                 ]
                )
    else
      // positive odd integer
      assert(type(n) = DOM_INT and n > 1 and n mod 2 = 1);
      
      // odd power; the function x -> x^n is increasing
      dom::mapBorders(r, _power, n)   
      
    end_if
  end_proc;

  leftpowuneval:=
  proc(r:dom, n): Type::Union(Type::Set, DOM_FAIL)
  begin
    genident();
    Dom::ImageSet(%^n, %, r)
  end_proc;

  inhomogleft_power:=
  table(
        DOM_INT= dom::leftpownum,
        DOM_RAT= dom::leftpownum,
        DOM_FLOAT= dom::leftpownum,

        DOM_EXPR = dom::leftpowuneval,
        DOM_IDENT = dom::leftpowuneval,

        DOM_SET =
        proc(r:Dom::Interval, S:DOM_SET) : Type::Union(Type::Set, DOM_FAIL)
        begin
          _union(op(map(S, u-> r^u)))
        end_proc

        );


    rightpowbyln:=
    proc(r, n:dom)
    begin
      exp(dom::_mult(n, ln(r)))
    end_proc;

    inhomogright_power:=
    table(
          DOM_INT= dom::rightpowbyln,
          DOM_RAT= dom::rightpowbyln,
          DOM_COMPLEX = dom::rightpowbyln,
          DOM_FLOAT= dom::rightpowbyln,
          DOM_EXPR=dom::rightpowbyln,
          DOM_IDENT=dom::rightpowbyln,

          DOM_SET=
          proc(S:DOM_SET, n:Dom::Interval)
          begin
            _union(op(map(S, _power, n)))
          end_proc

          );



  iszero:=
    proc(x:dom)
    begin
      iszero(dom::left(x)) and iszero(dom::right(x))
    end_proc;

  random:=
    proc()
      local a, b, c, d;
    begin
      a:= tan(float(PI)*(random()/(10.0^12) - 0.5));
      // -infinity < a < infinity
      if random() mod 2 = 0 then
        a:= [a]
      end_if;
      b:= tan(float(PI/2)*(random()/(10.0^12)));
      // 0 <= b < infinity
      if random() mod 2 = 0 then
        d:= [a + b]
      else
        d:= a + b
      end_if;
      dom::new(c, d)
    end_proc;

  one:= dom::new([1], [1]);

  zero:= dom::new([0], [0]);

  _subset := proc( A, B )
    local v;
  begin
    if not type(A)=Dom::Interval then
      return( hold(_subset)(A,B) );
    end_if;
    if not type(B)=Dom::Interval then
      return( hold(_subset)(A,B) );
    end_if;

    /* check left side */
    if dom::left( A )=infinity then
      if dom::left( B )<>infinity then
        return( FALSE );
      end_if;
    else
      if not dom::isleftopen( A ) and dom::isleftopen( B ) then
        v := is( dom::left( A )>dom::left( B ) );
      else
        v := is( dom::left( A )>=dom::left( B ) );
      end_if;
      if v=FALSE then return( FALSE ); end_if;
      if v=UNKNOWN then return( hold(_subset)(A, B) ); end_if;
    end_if;

    /* check right side */
    if dom::right( A )=infinity then
      if dom::right( B )<>infinity then
        return( FALSE );
      end_if;
    else
      if not dom::isrightopen( A ) and dom::isrightopen( B ) then
        v := is( dom::right( A )<dom::right( B ) );
      else
        v := is( dom::right( A )<=dom::right( B ) );
      end_if;
      if v=FALSE then return( FALSE ); end_if;
      if v=UNKNOWN then return( hold(_subset)(A, B) ); end_if;
    end_if;

    TRUE;
  end_proc;

  exp:=
    proc(x:dom): Type::Set
      local l,r;
    begin
      if dom::left(x)=-infinity then
        l:=0
      else
        l:=exp(dom::left(x))
      end_if;
      if dom::right(x)=infinity then
        r:=infinity
      else
        r:=exp(dom::right(x))
      end_if;
      dom::subsvals(x, l, r)
    end_proc;

  bin_union:=
    proc(a:dom, b:dom) : Type::Union(Type::Set, DOM_FAIL)
      local left, right, bordermin, bordermax, overlaps, mymin;
    begin
      bordermin:= 
      proc(x, y)
      begin 
        if type(x) = DOM_LIST then
          if type(y) = DOM_LIST then
            [mymin(op(x, 1), op(y, 1))]
          else 
            case is(op(x, 1) <= y)
            of TRUE do 
              return(x)
            of FALSE do
              return(y)
            otherwise
              return(FAIL)
            end_case
          end_if
        elif type(y) = DOM_LIST then
          bordermin(y, x)
        else
          mymin(x, y)
        end_if;  
      end_proc;
      
      mymin:= 
      proc(x, y)
      local result;
      begin
      result:= min(x, y);
      if type(result) = "min" then
        min::simplify(result)
      else
        result
      end_if
      end_proc;

      bordermax:= (x, y) -> -bordermin(-x, -y);
      
      overlaps:= 
      proc(x, y) 
      begin
        if type(x) = DOM_LIST then
          if type(y) = DOM_LIST then
            is(op(x, 1) <= op(y, 1),  Goal = TRUE)
          else
            is(op(x, 1) <= y, Goal = TRUE)
          end_if 
        else  
          if type(y) = DOM_LIST then 
            is(x<= op(y, 1), Goal = TRUE) 
          else 
            is(x<y, Goal =TRUE) 
          end_if
        end_if;
      end_proc;
        
      
      // special case: borders are syntactically equal
      if dom::right(a) = dom::left(b) then
        // [a1, a2] union [a2, a3] = [a1, a3]; but not (a1, a2) union (a2, a3) = (a1, a3)
        // this holds only if we know that a2 really lies in between a1 and a3
        if dom::isrightopen(a) and dom::isleftopen(b) or not is(dom::left(a) <= dom::right(a) or dom::left(b) <= dom::right(b), Goal = TRUE) then
          return(FAIL)
        else
          return(dom::new(dom::leftB(a), dom::rightB(b)))
        end_if
      elif dom::right(b) = dom::left(a) then
        if dom::isrightopen(b) and dom::isleftopen(a) or not is(dom::left(a) <= dom::right(a) or dom::left(b) <= dom::right(b), Goal = TRUE) then
          return(FAIL)
        else
          return(dom::new(dom::leftB(b), dom::rightB(a)))
        end_if
      end_if;
      
      if not ((overlaps(dom::leftB(b), dom::rightB(a)) and overlaps(dom::leftB(a), dom::rightB(b)))
         or (overlaps(dom::leftB(a), dom::rightB(b)) and overlaps(dom::leftB(b), dom::rightB(a)))) then
        return(FAIL)
      end_if;  
        
      if (left:= bordermin(dom::leftB(a), dom::leftB(b)) ) = FAIL or
         (right:= bordermax(dom::rightB(a), dom::rightB(b))) = FAIL then
         return(FAIL)
      end_if;   
      
      Dom::Interval(left, right)
    end_proc;

  inhomog_union:=
  table(DOM_SET   =
        proc(iv:Dom::Interval, S:DOM_SET): Type::Union(Type::Set, DOM_FAIL)
          local splitset, outerpts, l, r;
        begin
          splitset:= split(S, x-> is(contains(iv, x)));
          if splitset[2] = {} and splitset[3] = {} then
            iv
          else
            // test whether finite set contains border point of interval,
            // e. g. iv = (-1, 1) and S = {1}
            outerpts:= splitset[2] union splitset[3];
            l:= Dom::Interval::leftB(iv);
            r:= Dom::Interval::rightB(iv);
            if contains(S, l) then
              assert(type(l) <> DOM_LIST);
              outerpts:= outerpts minus {l};
              l:= [l]
            end_if;
            if contains(S, r) then
              outerpts:= outerpts minus {r};
              r:= [r]
            end_if;
            if outerpts = {} then
              Dom::Interval(l, r)
            else
              hold(_union)(Dom::Interval(l, r),
                           outerpts)
            end_if
          end_if;
        end_proc,

        piecewise  = piecewise::_union,

        DOM_EXPR   = proc(a: Dom::Interval, b: DOM_EXPR)
                     begin
                       case type(b)
                         of "_intersect" do
                           return(map(b, _union, a))
                         of "_union" do
                           return(map(b, _union, a))
                           // better chance for simplification
                         of "_minus" do
                           // iv union (A minus B) = iv union A iff B subset iv
                           if op(b, 2) subset a = TRUE then
                             a union op(b,1)
                           else
                             FAIL
                           end_if;
                           break
                         otherwise
                           FAIL
                       end_case;
        end_proc
          );

  bin_intersect:=
    proc(a:dom, b:dom) : Type::Union(Type::Set, DOM_FAIL)
      local left, leftBa, leftBb, lefta, leftb,
      right, rightBa, rightBb, righta, rightb ;
    begin
      [leftBa, rightBa]:= [op(a)];
      [leftBb, rightBb]:= [op(b)];
      [lefta, righta]:= dom::borders(a);
      [leftb, rightb]:= dom::borders(b);

      if is(rightb < lefta) = TRUE or
        is(righta < leftb) = TRUE then
        return({})
      end_if;

      // set the left border to max of left borders
      if leftBb=-infinity then
        left := leftBa;
      elif leftBa=-infinity then
        left := leftBb;
      else
//         assumeAlso(lefta in R_);
//         assumeAlso(leftb in R_);
        case [dom::isleftopen(a), dom::isleftopen(b)]
        of [TRUE, TRUE] do
         // left:= max(lefta, leftb);
         // break
        of [FALSE, FALSE] do
          if is(lefta-leftb<=0,Goal=TRUE) then left := leftBb;
          elif is(lefta-leftb>=0,Goal=TRUE) then left := leftBa;
          else left := {leftBb,leftBa}; end_if;
          break;
          left:= piecewise([lefta <= leftb, leftBb],
                           [leftb <= lefta, leftBa]
                           );

        //  left:= [max(lefta, leftb)];
          break
        of [TRUE, FALSE] do
          if is(lefta-leftb<0,Goal=TRUE) then left := leftBb;
          elif is(lefta-leftb>=0,Goal=TRUE) then left := leftBa;
          else left := {leftBb,leftBa}; end_if;
          break;
          left:= piecewise([lefta < leftb, leftBb],
                           [lefta >= leftb, leftBa]
                           );
          break
        of [FALSE, TRUE] do
          if is(lefta-leftb<=0,Goal=TRUE) then left := leftBb;
          elif is(lefta-leftb>0,Goal=TRUE) then left := leftBa;
          else left := {leftBb,leftBa}; end_if;
          break;
          left:= piecewise([lefta <= leftb, leftBb],
                           [lefta > leftb, leftBa]
                           );
          break
      end_case; end_if;

      // set right border to minimum of borders
      if rightBb=infinity then
        right := rightBa;
      elif rightBa=infinity then
        right := rightBb;
      else
//         assumeAlso(righta in R_);
//         assumeAlso(rightb in R_);
        case [dom::isrightopen(a), dom::isrightopen(b)]
        of [TRUE, TRUE] do
          //right:= min(righta, rightb);
          //break
        of [FALSE, FALSE] do
          if is(righta-rightb>=0,Goal=TRUE) then right := rightBb;
          elif is(righta-rightb<=0,Goal=TRUE) then right := rightBa;
          else right := {rightBb,rightBa}; end_if;
          break;
          right:= piecewise([righta >= rightb, rightBb],
                            [rightb >= righta, rightBa]
                            );

        //  right:= [min(righta, rightb)];
          break
        of [TRUE, FALSE] do
          if is(righta-rightb>0,Goal=TRUE) then right := rightBb;
          elif is(righta-rightb<=0,Goal=TRUE) then right := rightBa;
          else right := {rightBb,rightBa}; end_if;
          break;
          right:= piecewise([righta > rightb, rightBb],
                           [righta <= rightb, rightBa]
                           );
          break
        of [FALSE, TRUE] do
          if is(righta-rightb>=0,Goal=TRUE) then right := rightBb;
          elif is(righta-rightb<0,Goal=TRUE) then right := rightBa;
          else right := {rightBb,rightBa}; end_if;
          break;
          right:= piecewise([righta >= rightb, rightBb],
                            [righta < rightb, rightBa]
                            );
          break
        end_case;
      end_if;

      if type(left)=DOM_SET and type(right)=DOM_SET then return( FAIL ); end_if; // hold(_intersect)(a,b) ); end_if;
      if type(left)=DOM_SET then
        return( hold(_intersect)( Dom::Interval( op(left,1), right ), Dom::Interval( op(left,2), right ) ) );
      end_if;
      if type(right)=DOM_SET then
        return( hold(_intersect)( Dom::Interval( left, op(right,1) ), Dom::Interval( left, op(right,2) ) ) );
      end_if;
      return( Dom::Interval( left, right ) );
//       piecewise::zip(left, right, dom::new)

    end_proc;

  inhomog_intersect:=
    table(DOM_SET   =
          proc(iv:Dom::Interval, S: DOM_SET) : Type::Union(Type::Set, DOM_FAIL)
            local splitset, expandedset;
          begin
            splitset:= split(S, x -> is(contains(iv, x)));
            if op(splitset, 3) = {} then
              splitset[1]
            else
              if MAXEFFORT > 100*2^nops(splitset[3]) then
              // transform any object s which may or may not be
              // in iv into a set that may have one or zero
              // elements depending on the condition s in iv
                expandedset:=map(splitset[3],
                                 proc(s)
                                   local cond;
                                 begin
                                   cond:= s in iv;
                                   piecewise([cond, {s}],
                                             [not cond, {}])
                                 end_proc
                                 );
                  splitset[1] union _union(op(expandedset))
              else
                hold(_intersect)(splitset[1] union splitset[3], iv)
              end_if
            end_if
          end_proc,

          
          Dom::Multiset = 
          proc(iv:Dom::Interval, S: Dom::Multiset): Type::Union(Type::Set, DOM_FAIL)
              local splitset;
          begin
            splitset:= split(S, x -> is(contains(iv, x)));
            if op(splitset, 3) = {} then
              splitset[1]
            else
              hold(_intersect)(splitset[1] union splitset[3], iv)
            end_if
          end_proc,
          
          piecewise = piecewise::_intersect,


          RootOf =
          proc(iv, rof)
          begin
            if freeIndets(rof) = {} then
              if numeric::hasroot(op(rof, 1), op(rof, 2),
                                  iv::dom::left(iv), iv::dom::right(iv))
                = FALSE then
                return({})
              end_if
            end_if;
            FAIL
          end_proc,
            

          DOM_EXPR  = proc(a : Dom::Interval, b: DOM_EXPR): Type::Union(Type::Set, DOM_FAIL)
                        local intersections, c, C, d, J;
                      begin
                        case type(b)
                          of "_intersect" do
                            // to have maximal chance
                            // for simplification
                            return(map(b,_intersect, a))
                          of "_union" do
                            intersections:=map([op(b)], _intersect, a);
                            if contains(map(intersections, type),
                                        "_intersect")>0 then
                              return(FAIL)
                            else
                              return(_union(op(intersections)))
                            end_if
                          of "_minus" do
                            [c, d]:= [op(b)];
                            // apply rule
                            // a intersect (c minus d) =
                            // (a intersect c) minus d =
                            // (a intersect c) minus (a intersect d)
                            // the latter may be simpler if the
                            // intersection of a and d can really be computed
                            intersections:= a intersect c;
                            a intersect d;
                            if type(%)<>"_intersect" then
                              return(intersections minus %)
                            else
                              return(intersections minus d)
                            end_if;
                          of "Union" do
                            // we can only handle one special case
                            if op(b, 3) = Z_ and
                              freeIndets(a)  = {} and
                              type(op(b, 1)) = Dom::Interval and
                              freeIndets(b) = {} then
                              // have to intersect a constant interval
                              // with a union of constant intervals
                              J:= op(b, 1);
                              c:= solve(a::dom::left(a) < J::dom::right(J)
                                        and J::dom::left(J) < a::dom::right(a),
                                        op(b, 2))
                                  intersect Z_;
                              if type(c) = DOM_SET then
                                return(_union((a intersect (J | op(b, 2) = C))
                                              $C in c)
                                       )
                              end_if;
                             end_if;
                             break
                        end_case;
                        FAIL
                      end_proc);

  bin_minus:=
    proc(A:dom, B:dom): Type::Union(Type::Set, DOM_FAIL)
      local switch;
    begin

      // local method switch
      // [x] ->  x
      //  x  -> [x]

      switch:=
      proc(x)
      begin
        if type(x)=DOM_LIST then
          op(x, 1)
        else
          [x]
        end_if
      end_proc;


      // intersect with complement
      // note that taking away a closed interval means intersecting
      // with an open interval and vice versa
      
      (dom::new(-infinity, switch(dom::leftB(B))) intersect A)
      union
      (dom::new(switch(dom::rightB(B)), infinity) intersect A)
    end_proc;

  // inhomogright_minus : table of methods for any_set minus interval
  inhomogright_minus:=
    table(DOM_SET = proc(A, B:Dom::Interval): Type::Union(Type::Set, DOM_FAIL)
                      local d;
                    begin
                      d:= split(A, y -> is(Dom::Interval::contains(B, y)));
                      if op(d, 3) = {} then
                        return(op(d, 2))
                      elif op(d, 2) = {} then
                        return(hold(_minus)(op(d, 3), B))
                      else
                        return(hold(_union)(op(d, 2), hold(_minus)(op(d, 3), B)))
                      end_if;
                    end_proc);

  inhomogleft_minus:=
    table(DOM_SET =
          proc(A:Dom::Interval, B): Type::Union(Type::Set, DOM_FAIL)
            local intervals, y;
          begin
            intervals:= [A];
            for y in B do
              intervals:= map(intervals,
                              proc(J: Dom::Interval)
                                local cut;
                              begin
                                if contains(J, y) = FALSE then
                                  J
                                else
                                  // cut out the point y from J
                                  cut:=
                                  [
                                   Dom::Interval(Dom::Interval::leftB(J), y),
                                   Dom::Interval(y, Dom::Interval::rightB(J))
                                   ];
                                  op(select(cut, _unequal, {}))
                                end_if
                              end_proc)
          end_for;
          return(_union(op(intervals)))
          end_proc,

          DOM_EXPR = proc( A: Dom::Interval, B )
            local operands, i, j, result;
          begin
            if testtype( B, "_intersect" ) then
              operands := [op(B)];
              result :=[];
              for i from 1 to nops(operands) do
                j := operands[i] intersect A;
                if j={} then return( A ); end_if;
                if j=A then j:=null(); end_if;
                if testtype( j, "_intersect" ) then
                  j := operands[i];
                end_if;
                result := result.[j];
              end_for;
              B := _intersect( op(result) );
            end_if;
            
            if B={} then 
              return( A ) 
            end_if;
            
            if type(B) = "_union" then
              B:= [op(B)];
              for i from 1 to nops(B) do
                result:= solvelib::solve_minus(A, op(B, i));
                if type(result) <> "_minus" then
                  B[i]:= FAIL;
                  A:= result
                else
                  A:= op(result, 1);
                  B[i]:= op(result, 2)
                end_if;  
              end_for;
              B:= select(B, _unequal, FAIL);
              if nops(B) = 0 then
                return(A)
              elif nops(B) = 1 then
                return(A minus B[1])
              elif type(A) <> Dom::Interval then
                return(A minus hold(_union)(op(B)))
              else
                return(hold(_minus)(A, hold(_union)(op(B))))
              end_if              
            end_if;  
            
            // give up
            hold(_minus)(A, B) 
          end_proc,

          piecewise = ((J, pw) -> piecewise::extmap(pw, S -> J minus S))



          );

  // is x an element of the interval X?
  contains:=
    proc(X: dom, x): DOM_BOOL
    begin
      property::_is(x in X)
    end_proc;

  // is c syntactically contained in iv?
  has:= (iv, c) -> bool(iv=c) or
        has(dom::left(iv), c) or has(dom::right(iv), c);


  // overload solvelib::Union
  // compute the union of all iv(x), where x runs through S

  Union:=
    proc(iv: dom, x, S:Type::Set): Type::Set
    begin
      if not dom::has(iv, x) then
        iv
      else
        // no further simplifications implemented at the moment
        hold(solvelib::Union)(iv, x, S)
      end_if
    end_proc;

  getElement:=
  proc(iv: dom)
    local rand, p, q;
  begin
    if args(0) >= 2 then
      if args(0) > 2 or args(2) <> Random then
        error("Illegal option")
      else
        rand:= TRUE
      end_if
    else
      rand:= FALSE
    end_if;
    
    if dom::isEmpty(iv) = FALSE then
      if dom::left(iv) = -infinity then
        if dom::right(iv) = infinity then
          if rand then
            Dom::Real::random()
          else
            0
          end_if
        else
          if rand then
            dom::right(iv) - random() - 1
          else
            dom::right(iv) - 1
          end_if;
        end_if
      else
        if dom::right(iv) = infinity then
          if rand then
            dom::left(iv) + random() + 1
          else
            dom::left(iv) + 1
          end_if
        else
          if rand then
            q:= random() + 2; // do not divide by zero, do not allow denom 1
            p:= 1 + (random() mod (q-1)); // now 0 < p < q
            dom::left(iv) +
            p/q*(dom::right(iv) - dom::left(iv))
          else
            (dom::left(iv)+dom::right(iv))/2
          end_if
        end_if
      end_if
    else
      FAIL
    end_if
  end_proc;

  isEmpty:=
  proc(iv:dom):Type::Boolean
    local v;
  begin
    if dom::isleftopen(iv) or dom::isrightopen(iv) then
      v := is( not dom::right(iv) > dom::left(iv) );
      if v=UNKNOWN then return( not dom::right(iv) > dom::left(iv) ); end_if;
    else
      v := is( not dom::right(iv) >= dom::left(iv) );
      if v=UNKNOWN then return( not dom::right(iv) >= dom::left(iv) ); end_if;
    end_if;
    v;
  end_proc;


  isFinite:=
  proc(iv:dom):DOM_BOOL
  begin
    not is(dom::right(iv)> dom::left(iv))
  end_proc;

  // mapBorders: simply map the function to the borders

  // map: return the image of the interval under the mapping; inherited
  // from Cat::Set

  mapBorders:=
    proc(x)
    begin
      dom::new(mapB(dom::leftB(x), args(2..args(0))),
               mapB(dom::rightB(x), args(2..args(0)))
               )
    end_proc;

  interchangeMapBorders:=
    proc(x)
    begin
      dom::new(mapB(dom::rightB(x), args(2..args(0))),
               mapB(dom::leftB(x), args(2..args(0)))
               )
    end_proc;

  zip:=
    proc(x, y)
      local lval, rval;
    begin
      [lval, rval]:= zip([dom::left(x), dom::right(x)],
                         [dom::left(y), dom::right(y)], args(3..args(0)));
      dom::new(_if(dom::isleftopen(x), lval, [lval]),
               _if(dom::isrightopen(x), rval, [rval]))
    end_proc;

  min:=
    proc()
      local l, r, DOM;
    begin
      l:= map([args()], dom::convert);
      if has(l, FAIL) then
        error("Could not convert arguments to type interval")
      end_if;
      DOM:= dom;
      r:= map(l, X -> [DOM::right(X), _if(DOM::isrightopen(X), 0, 1)]);
      l:= map(l, X -> [DOM::left(X), _if(DOM::isleftopen(X), 0, 1)]);
      r:= op(sort(r, (X, Y) -> op(X, 1) <= op(Y, 1) and op(X, 2) <= op(Y, 2)), 1);
      l:= op(sort(l, (X, Y) -> op(X, 1) <= op(Y, 1) and op(X, 2) >= op(Y, 2)), 1);
      dom::new(_if(op(l, 2) = 1, DOM_LIST, id)(op(l, 1)),
                          _if(op(r, 2) = 1, DOM_LIST, id)(op(r, 1)))
    end_proc;

  max:=
    proc()
      local l, r, DOM;
    begin
      l:= map([args()], dom::convert);
      if has(l, FAIL) then
        error("Could not convert arguments to type interval")
      end_if;
      DOM:= dom;
      r:= map(l, X -> [DOM::right(X), _if(DOM::isrightopen(X), 0, 1)]);
      l:= map(l, X -> [DOM::left(X), _if(DOM::isleftopen(X), 0, 1)]);
      r:= op(sort(r, (X, Y) -> op(X, 1) >= op(Y, 1) and op(X, 2) >= op(Y, 2)), 1);
      l:= op(sort(l, (X, Y) -> op(X, 1) >= op(Y, 1) and op(X, 2) <= op(Y, 2)), 1);
      dom::new(_if(op(l, 2) = 1, DOM_LIST, id)(op(l, 1)),
                          _if(op(r, 2) = 1, DOM_LIST, id)(op(r, 1)))
    end_proc;

  float:=
    proc(x)
    begin
      dom::subsvals(x, float(dom::left(x)), float(dom::right(x)))
    end_proc;

  ln:=
    proc(x)
      local l,r, imag, realp;
    begin
      l:= if not iszero(dom::left(x)) then
            ln(dom::left(x))
          else
            -infinity
          end_if;
      r:= if dom::right(x)=infinity then
            infinity
          elif iszero(dom::right(x)) then
            FAIL // does not matter
          else
            ln(dom::right(x))
          end_if;

      imag:= if is(dom::left(x)>=0) = TRUE then
               {}
             elif is(dom::left(x) < 0) = TRUE then
               PI*I + ln(-dom(dom::leftB(x), [0]))
             else
               piecewise
               ([dom::left(x)<0,
                 PI*I + ln(-dom(dom::leftB(x), [0]))],
                [dom::left(x)>=0, {}])
             end_if;
      realp:=piecewise
              ([dom::right(x)<=0, {}],
               [dom::right(x)>0 and dom::left(x)<=0,
                dom::subsvals(x, -infinity, r)],
               [dom::left(x)>0, dom::subsvals(x, l, r)]);
      imag union realp
    end_proc;

  abs:=
    proc(x)
    begin
      if dom::isrightopen(x) then
        return(piecewise([0<=dom::left(x), x],
          [dom::left(x)<0 and dom::right(x)<=0, dom::_negate(x)],
          [dom::left(x)<0 and dom::right(x)>=0 and -dom::left(x)>=dom::right(x), dom::_negate(Dom::Interval(dom::leftB(x), [0]))],
          [dom::left(x)<0 and dom::right(x)>=0 and -dom::left(x)<dom::right(x), Dom::Interval([0], dom::rightB(x))]));
      else
        return(piecewise([0<=dom::left(x), x],
          [dom::left(x)<0 and dom::right(x)<=0, dom::_negate(x)],
          [dom::left(x)<0 and dom::right(x)>=0 and -dom::left(x)>dom::right(x), dom::_negate(Dom::Interval(dom::leftB(x), [0]))],
          [dom::left(x)<0 and dom::right(x)>=0 and -dom::left(x)<=dom::right(x), Dom::Interval([0], dom::rightB(x))]));
      end_if;
    end_proc;

    Re:= id;  // intervals only contain reals

    Im:={0};

  arccos:=
    proc(x)
      local z;
    begin
      if is(dom::left(x) >= -1 and dom::right(x) <= 1, Goal = TRUE) then 
        dom::interchangeMapBorders(x, arccos)
      else
        z:= genident("zz");
        Dom::ImageSet(arccos(z), z, x)
      end_if  
    end_proc;

  arccosh:=
    proc(x)
      local z;
    begin
      if is(dom::left(x) >= 1, Goal = TRUE) then 
        dom::mapBorders(x, arccosh)
      else
        z:= genident("zz");
        Dom::ImageSet(arccosh(z), z, x)
      end_if   
    end_proc;

  arccot:=
    proc(x)
      local A;
    begin
      if dom::_is(dom::left(x) >= 0, dom::isfloat(x)) then
        dom::interchangeMapBorders(x, arccot)
      elif dom::_is(dom::right(x) <= 0, dom::isfloat(x)) then
        if not dom::isrightopen(x) then
          piecewise([dom::right(x) = 0, Dom::Interval(-PI/2, arccot(dom::leftB(x))) union {PI/2}],
            [dom::right(x) < 0, dom::interchangeMapBorders(x, arccot)])
        else
          piecewise([dom::right(x) = 0, Dom::Interval(-PI/2, arccot(dom::leftB(x)))],
            [dom::right(x) < 0, dom::interchangeMapBorders(x, arccot)])
        end_if;
      elif dom::_is(dom::left(x) < 0, dom::isfloat(x)) and dom::_is(dom::right(x) > 0, dom::isfloat(x)) then
        if dom::isleftopen(x) then
          A := Dom::Interval(-PI/2, arccot(dom::left(x)));
        else
          A := Dom::Interval(-PI/2, [arccot(dom::left(x))]);
        end_if;
        if dom::isrightopen(x) then
          A union Dom::Interval(arccot(dom::right(x)), [PI/2]);
        else
          A union Dom::Interval([arccot(dom::right(x))], [PI/2]);
        end_if;
      else
        Dom::ImageSet(arccot(#x), #x, x);
      end_if
    end_proc;

  arccoth:=
    proc(x)
    begin
      /* right side <= -1? */
      if is(dom::right(x) <= -1, Goal=TRUE) then
        if bool(float(dom::right(x)=-1)) then
          if dom::isleftopen(x) then
            return(Dom::Interval(-infinity, arccoth(dom::left(x))));
          else
            return(Dom::Interval(-infinity, [arccoth(dom::left(x))]));
          end_if;
        else
          return(dom::interchangeMapBorders(x, arccoth));
        end_if;
      end_if;

      /* left side >= 1? */
      if is(dom::left(x) >= 1, Goal=TRUE) then
        if bool(float(dom::left(x)=1)) then
          if dom::isrightopen(x) then
            return(Dom::Interval(arccoth(dom::right(x)), infinity));
          else
            return(Dom::Interval([arccoth(dom::right(x))], infinity));
          end_if;
        else
          return(dom::interchangeMapBorders(x, arccoth));
        end_if;
      end_if;

      return(Dom::ImageSet(arccoth(#x), #x, x));
    end_proc;

  arcsin:=
    proc(iv: Dom::Interval)
      local z;
    begin
      if is(dom::left(iv) >= -1, Goal = TRUE) and 
        is(1 >= dom::right(iv), Goal = TRUE) then
        dom::mapBorders(iv, arcsin)
      else 
        z:= genident("zz");
        Dom::ImageSet(arcsin(z), z, iv)
      end_if  
    end_proc;

  arcsinh:=
    proc(x)
    begin
      dom::mapBorders(x, arcsinh)
    end_proc;

  arctan:=
    proc(x)
    begin
      dom::mapBorders(x, arctan)
    end_proc;

  arctanh:=
    proc(x)
      local newvar;
    begin
      if dom::_is(dom::left(x) < -1, dom::isfloat(x))
         or dom::_is(1 < dom::right(x), dom::isfloat(x)) then
        newvar:=genident();
        return(Dom::ImageSet(arctanh(newvar), [newvar], [x]));
      end_if;
      dom::mapBorders(x, X->_if(abs(X)=1, X*infinity, arctanh(X)));
    end_proc;

  cos:=
    proc(x)
      local lo, hi, l, r, FL;
    begin
      FL:= dom::isfloat(x);
      l:= dom::left(x);
      r:= dom::right(x);
      // full period covered ?
      if l=-infinity or r=infinity or dom::_is(r - l > 2*PI, FL) then
        return(dom::new([-1], [1]))
      end_if;
      hi:= 2*PI*ceil(l/2/PI); // next maxima following the left bound
      lo:= 2*PI*ceil((l - PI)/2/PI) + PI; // next minima to the right
      if dom::_is(hi - r <= 0, FL) then
        hi:= [1]
      elif dom::_is(cos(l) >= cos(r), FL) then
        if dom::isleftopen(x) then
          hi := cos(l);
        else
          hi := [cos(l)];
        end_if;
      elif dom::_is(cos(r) >= cos(l), FL) then
        if dom::isrightopen(x) then
          hi := cos(r);
        else
          hi := [cos(r)];
        end_if;
      else
        return(Dom::ImageSet(cos(#z), #z, x))
      end_if;
      if dom::_is(lo - r <= 0, FL) then
        lo:= [-1]
      elif dom::_is(cos(l) <= cos(r), FL) then
        if dom::isleftopen(x) then
          lo := cos(l);
        else
          lo := [cos(l)];
        end_if;
      elif dom::_is(cos(r) <= cos(l), FL) then
        if dom::isrightopen(x) then
          lo := cos(r);
        else
          lo := [cos(r)];
        end_if;
      else
        return(Dom::ImageSet(cos(#z), #z, x))
      end_if;
      dom::new(lo, hi)
    end_proc;

  cosh:=
    proc(x)
    begin
      if not dom::isleftopen(x) then
        piecewise([dom::left(x)<=dom::right(x) and dom::left(x)>=0, dom::mapBorders(x, cosh)],
          [dom::left(x)<=dom::right(x) and dom::right(x)<=0, dom::interchangeMapBorders(x, cosh)],
          [dom::left(x)<=dom::right(x) and dom::left(x)<0 and dom::right(x)>0 and -dom::left(x)>=dom::right(x), Dom::Interval([1], [cosh(dom::left(x))])],
          [dom::left(x)<=dom::right(x) and dom::left(x)<0 and dom::right(x)>0 and -dom::left(x)<dom::right(x), dom::mapBorders(Dom::Interval([0], dom::rightB(x)), cosh)],
          [dom::left(x)>dom::right(x), {}]);
      else
        piecewise([dom::left(x)<=dom::right(x) and dom::left(x)>=0, dom::mapBorders(x, cosh)],
          [dom::left(x)<=dom::right(x) and dom::right(x)<=0, dom::interchangeMapBorders(x, cosh)],
          [dom::left(x)<=dom::right(x) and dom::left(x)<0 and dom::right(x)>0 and -dom::left(x)>dom::right(x), Dom::Interval([1], cosh(dom::left(x)))],
          [dom::left(x)<=dom::right(x) and dom::left(x)<0 and dom::right(x)>0 and -dom::left(x)<=dom::right(x), dom::mapBorders(Dom::Interval([0], dom::rightB(x)), cosh)],
          [dom::left(x)>dom::right(x), {}]);
      end_if;
    end_proc;

    cot:=
    proc(x)
      local a, b, k, cota, cotb;
    begin
      a:= dom::left(x);
      b:= dom::right(x);
      if a=-infinity or b=infinity or is(b-a > PI, Goal = TRUE) then
        return(R_)
      end_if;
      if testtype(a, Type::Constant) and testtype(b, Type::Constant) then
        // tan(x + k*PI) = tan(x)
        k:= floor(a/PI);
        a:= a - k*PI;
        b:= b - k*PI;
        if is(a = 0, Goal = TRUE) then 
          cota:= infinity
        elif dom::isleftopen(x) then
          cota:= cot(a)
        else
          cota:= [cot(a)]
        end_if;
        if is(b=0, Goal = TRUE) then 
          cotb:= -infinity
        elif dom::isrightopen(x) then
          cotb:= cot(b)
        else
          cotb:= [cot(b)]
        end_if;
        return(piecewise([b < PI, Dom::Interval(cotb, cota)],
        [b >= PI, Dom::Interval(-infinity, cota) union Dom::Interval(cotb, infinity)]
        ))
      end_if;
      // symbolic borders
      Dom::ImageSet(cot(`#x`), `#x`, x);
    end_proc;
 

  coth:=
    proc(x)
    begin
      if has(sign(x), 0) then
        Dom::ImageSet(coth(`#x`), `#x`, x);
      else
        dom::interchangeMapBorders(x, coth)
      end_if
    end_proc;

  sin:=
    proc(x)
      local lo, hi, l, r, FL;
    begin
      FL:= dom::isfloat(x);
      l:= dom::left(x);
      r:= dom::right(x);
      // full period covered ?
      if l=-infinity or r=infinity or dom::_is(r - l > 2*PI, FL) then
        return(dom::new([-1], [1]))
      end_if;
      hi:= 2*PI*ceil((l - PI/2)/2/PI) + PI/2;
      // next maxima following the left bound
      lo:= 2*PI*ceil((l + PI/2)/2/PI) - PI/2;
      // next minima to the right
      if dom::_is(hi - r <= 0, FL) then
        hi:= [1]
      elif dom::_is(sin(l) >= sin(r), FL) then
        if dom::isleftopen(x) then
          hi := sin(l);
        else
          hi := [sin(l)];
        end_if;
      elif dom::_is(sin(r) >= sin(l), FL) then
        if dom::isrightopen(x) then
          hi := sin(r);
        else
          hi := [sin(r)];
        end_if;
      else
        return(Dom::ImageSet(hold(sin)(#z), #z, x))
      end_if;
      if dom::_is(lo - r <= 0, FL) then
        lo:= [-1]
      elif dom::_is(sin(l) <= sin(r), FL) then
        if dom::isleftopen(x) then
          lo := sin(l);
        else
          lo := [sin(l)];
        end_if;
      elif dom::_is(sin(r) <= sin(l), FL) then
        if dom::isrightopen(x) then
          lo := sin(r);
        else
          lo := [sin(r)];
        end_if;
      else
        return(Dom::ImageSet(hold(sin)(#z), #z, x))
      end_if;
      dom::new(lo, hi)
    end_proc;

  sinh:=
    proc(x)
    begin
      dom::mapBorders(x, sinh)
    end_proc;

  tan:=
    proc(x)
      local a, b, k, tana, tanb;
    begin
      a:= dom::left(x);
      b:= dom::right(x);
      if a=-infinity or b=infinity then
        return(R_)
      end_if;
      // tan(x + k*PI) = tan(x)
      k:= round(a/PI);
      a:= a - k*PI;
      b:= b - k*PI;
      if a = -PI/2 then // is?
        tana:= -infinity
      else
        tana:= tan(a)
      end_if;
      if b = PI/2 then // is?
        tanb:= infinity
      else
        tanb:= tan(b)
      end_if;
      if dom::_is(b > PI/2, dom::isfloat(x)) then
        if dom::_is(b - a > PI, dom::isfloat(x)) then
          return(R_)
        else
          return(dom::_union(dom::subsvals(x, -infinity, tanb),
                             dom::subsvals(x, tana, infinity)))
        end_if
      else
        dom::subsvals(x, tana, tanb)
      end_if
    end_proc;

  tanh:=
    proc(x:dom)
    begin
      dom::mapBorders(x, tanh)
    end_proc;


  gamma:=
    proc(x: dom)
      local a, b;
    begin
      a:= dom::left(x);
      b:= dom::right(x);
      if is(a>= 3/2) = TRUE and is(b>= 3/2) = TRUE then
        return(dom::mapBorders(x, gamma))
      end_if;
      genident();
      Dom::ImageSet(gamma(%), %, x)
    end_proc;

    /*  preImage(a, x, iv)

    computes the set of all x such that a is in iv
    iv must not depend on x

    */
    preImage:=
    proc(a, x, iv: dom)
      local opt: DOM_TABLE;
    begin
      assert(not contains(freeIndets(iv), x));
      opt:= solvelib::getOptions(args(4..args(0)));
      if opt[Real] then
        return(solvelib::preImageIntervalReal(a, x, iv, opt))
      else
        return(solvelib::preImageInterval(a, x, iv, opt))
      end_if;
    end_proc;

    diff:=
    proc(iv: Dom::Interval)
    begin
      if args(0) = 1 then
        iv
      else
        // do nothing - consistent with diff of DOM_SETs
        hold(diff)(args())
      end_if
    end_proc;

  begin

    // mapB - a useful utility function
    mapB:= proc(b, f)
           begin
             if type(b) = DOM_LIST then
               [f(op(b, 1), args(3..args(0)))]
             else
               f(b, args(3..args(0)))
             end_if
           end_proc;

end_domain: