/*++
        Dom::MatrixGroup  --  the abelian group of m x n matrices

        MatrixGroup( m,n [,R] )

        m, n: positive integers
        R   : (optional) a Cat::CommutativeRing

        This contructor creates a domain representing the set of 
        m x n matrices over a commutative ring R. If R is not given then
        the domain Dom::ExpressionField() will be used.

        This domain constructor is simply build up by the domain
        constructor 'Dom::Matrix'.
++*/

domain Dom::MatrixGroup( m:Type::PosInt,n:Type::PosInt,R )
    local MatrixR;
    inherits Dom::Matrix( R );
    category if R::hasProp(Cat::Field) then
               Cat::VectorSpace(R)
             else
               Cat::Module(R)
             end_if,
             Cat::Matrix( R ), Cat::AbelianGroup;
    axiom    if R::hasProp( Ax::canonicalRep ) then Ax::canonicalRep end_if;

/*-- Entries --*/
    zero:= extsubsop(MatrixR::new( m,n ),0=dom);
    one:= if Rone <> FAIL and m = n then extsubsop(MatrixR::identity(n),0=dom) end_if;
    randomDimen:= [m,n];
    Name:= if dom::constructor = Dom::MatrixGroup and
	      R = Dom::ExpressionField() then
                hold(Dom::MatrixGroup)(m, n)
           end;

/*-- Methods --*/
    new:= proc(r,c)
        local tmp;
    begin
        case args(0)
        of 0 do
            return( dom::zero )
        of 1 do
            if contains( {DOM_EXEC, DOM_PROC}, domtype(r) ) then
                tmp:= testargs(TRUE);
                r:= extsubsop( MatrixR::new(m,n,r),0=dom );
                testargs( tmp );
                return( r )
            else
                r:= dom::coerce(r);
                if r = FAIL then
                    error("invalid argument")
                else
                    return( r )
                end_if
            end_if
        otherwise
            if testtype( r,Type::PosInt ) and testtype( c,Type::PosInt ) then
                if [r,c] <> [m,n] then
                    error("wrong no of rows and/or columns")
                else
                    tmp:= testargs( TRUE );
                    if traperror( (r:= MatrixR::new(args())) ) <> 0 then
                        testargs( tmp );
                        lasterror()
                    else
                        testargs( tmp );
                        return( extsubsop(r,0=dom) )
                    end_if
                end_if
            else
                tmp:= testargs( TRUE );
                if traperror( (r:= MatrixR::new(m,n,args())) ) <> 0 then
                    testargs( tmp );
                    lasterror()
                else
                    testargs( tmp );
                    if r::dom::matdim(r) <> [m,n] then
                        error("wrong no of rows and/or columns")
                    else
                        return( extsubsop(r,0=dom) )
                    end_if
                end_if
            end_if
        end_case
    end_proc;

    convert:= proc(A)
    begin
        if args(0) <> 1 then 
            return( FAIL )
        elif domtype(A) = dom then 
            return( A )
        elif domtype(A) = DOM_ARRAY or 
             A::dom::hasProp( Cat::Matrix ) = TRUE then
               A:= MatrixR::convert( A );
               if A = FAIL then 
                return( FAIL )
               elif A::dom::matdim(A) <> [m,n] then 
                return( FAIL )
               else 
                return( extsubsop(A,0=dom) )
               end_if
        elif traperror( (A:= MatrixR::new(m,n,A)) ) <> 0 then
            return( FAIL )
        else
            return( extsubsop(A,0=dom) )
        end_if
    end_proc;


    random:= () -> MatrixR::random(m, n, args());
/* ------------------------------------------------------------------------------
    random:= if R::random <> FAIL then
        ()-> dom::create( m,n,
            [[R::random() $ j=1..n] $ i=1..m]
        )
    end_if;
--------------------------------------------------------------------------------*/


   _index:= (x, i, j) -> MatrixR::_index(extsubsop(x, 0 = MatrixR), args(2..args(0)));
/* ------------------------------------------------------------------------------
    _index:= proc(x,i,j)
        local a, r1, r2, b1, b2, e1, e2;
    begin
        if args(0) = 3 then
            if domtype(i) = DOM_INT and domtype(j) = DOM_INT then
                return( context(_index(extop(x,3),i,j)) )
            elif type(i) = "_range" and type(j) = "_range" then
                // return submatrix of x of type Dom::Matrix(R):
                x:= extop(x,3);
                b1:= op(i,1); e1:= op(i,2);
                b2:= op(j,1); e2:= op(j,2);
                a:= array(1..e1-b1+1, 1..e2-b2+1,
                    ( (r1,r2)=x[b1+r1-1, b2+r2-1] $ r1=1..e1-b1+1 ) $ r2=1..e2-b2+1
                );
                return(new( MatrixR, e1-b1+1, e2-b2+1, a ))
            else
                return( hold(_index)(args()) )
            end_if
        elif domtype(i) = DOM_INT then
            if extop(x,1) = 1 then
                return( context(_index(extop(x,3),1,i)) )
            else
                return( context(_index(extop(x,3),i,1)) )
            end_if
        else
            return( hold(_index)(args()) )
        end_if
    end_proc;
-------------------------------------------------------------------------------*/

    matdim:= x->[m,n];

    delRow:= proc() 
    begin
        return( MatrixR::delRow(args()) )
    end_proc;

    delCol:= proc()
    begin
        return( MatrixR::delCol(args()) )
    end_proc;

    stackMatrix:= proc()
    begin
        if args(0) = 1 then 
            return( args(1) )
        else
            return( MatrixR::stackMatrix(args()) )
        end_if
    end_proc;

    concatMatrix:= proc()
    begin
        if args(0) = 1 then 
            return( args(1) )
        else
            return( MatrixR::concatMatrix(args()) )
        end_if
    end_proc;

    identity:= proc(d)
    begin
        if args(0) <> 1 or not testtype(d,Type::PosInt) then
            error("expecting a positive integer")
        elif m = n and m = d then
            extsubsop(MatrixR::identity(d),0=dom)    
        else
            MatrixR::identity(d)
        end_if
    end_proc;

    row:= proc()
    begin
        return( MatrixR::row(args()) )
    end_proc;

    col:= proc()
    begin
        return( MatrixR::col(args()) )
    end_proc;

/*--
    evalp -- overload 'evalp' for matrices over polynomial coefficient domains
--*/
             
/*
    evalp:= if R::hasProp(Cat::Polynomial) then
    proc(A)
        local x, y;
    begin
        x:= map(extop(A,3),eval@evalp,args(2..args(0)));
        // Check whether the matrix now consists only of components 
        // of the coefficient ring of the polynomial domain:
        y:= map({op(x)},testtype,R::coeffRing);
        if contains(y,FALSE) then
            // No, hence define the matrix over R:
            return(new( dom,extop(A,1..2),x ))
        else
            // Yes, hence define the matrix over R::coeffRing:
            return(new( Dom::MatrixGroup(m,n,R::coeffRing),extop(A,1..2),x ))
        end_if
    end_proc
    end_if;
*/

//---------------------------------
// expr2text
//---------------------------------
expr2text:= proc(A)
local L;
begin
  L:= dom::convert_to(A, DOM_LIST):
  expr2text(dom::key)."(".expr2text(L).")";
end_proc;


//---------------------------------
// the body of the domain:
//---------------------------------
begin
    if args(0) <> 2 and args(0) <> 3 then
        error("wrong number of arguments")
    end_if;
    if args(0) = 2 then
        R:= Dom::ExpressionField()
    elif R::dom <> DOM_DOMAIN or R::hasProp( Cat::CommutativeRing ) <> TRUE then
        error("expecting a coefficient domain of category 'Cat::CommutativeRing'")
    end_if;

    // initialization of local variables:
    MatrixR:= Dom::/*Dense*/Matrix( R )
end_domain:

