//    

/*++

Dom::MonomOrdering - the domain of monomial orderings

a monomial ordering of length n assigns to
                              each pair [a1,...,an], [b1,..,bn]
                              one of the values
                              0 (equal)
                              1 ([a1,..,an] > [b1,...,bn])
                              -1 ([a1,..,an] < [b1,..,bn])


internal representation:
                           extop(..,0): Dom::MonomOrdering
                           extop(..,1): ordertype
                           extop(..,2): parameters
                           extop(..,3): ordermatrix
                           
                              ++*/

domain Dom::MonomOrdering
local Matrices;
inherits Dom::BaseDomain;

category Cat::BaseCategory;  

// no axiom 


  convert:=
  proc()
    local o;
  begin
    o:=dom::preconvert(args());
    if o=FAIL then
      FAIL
    elif extnops(o)=3 then
      o
    else
      new(extop(o,0..2), dom::ordermatrix(%))
    end_if
  end_proc;

  
  preconvert:=
  proc(x)
    local result;
  begin
    if args(0)>=2 then
      error("Wrong number of arguments")
    end_if;

    if type(x)=dom then
      return(x)
    end_if;
    
    if type(x)=DOM_LIST then
      map(x, dom::coerce);
      if has(%, FAIL) then
        return(FAIL)
      else  
        return(new(dom, "Block",%))
      end_if
    elif domtype(x)<>DOM_EXPR then
      return(FAIL)
    end_if;

    case op(x,0)
      of hold(Lex) do
      of hold(DegLex) do
      of hold(DegRevLex) do
      of hold(DegInvLex) do  
      of hold(RevLex) do
        if nops(x)<>1 or not testtype(op(x,1), Type::PosInt) then
          return(FAIL)
        end_if; // fall through
        return(new(dom, expr2text(op(x,0)), [op(x)]))
      of hold(WeightedLex) do
      of hold(WeightedRevLex) do
      of hold(WeightedDegLex) do  
      of hold(WeightedDegRevLex) do
        if not testtype([op(x)], Type::ListOf(Type::Constant)) then
          return(FAIL)
        else  
          return(new(dom, expr2text(op(x,0)), [op(x)]))
        end_if
      of hold(Block) do
        map([op(x)], dom::convert);
        if has(%, FAIL) then
          return(FAIL)
        else  
          return(new(dom, "Block", map([op(x)], dom::convert)))
        end_if
      of hold(Matrix) do
        result:=Dom::/*Dense*/Matrix()(op(x,1));
        if testtype([op(result)], Type::ListOf(Type::Constant))<>TRUE then
          return(FAIL)
        else  
          return(new(dom, "Matrix", [result]))
        end_if
      otherwise
        FAIL
    end_case
  end_proc;

  ordertype:= x -> extop(x,1);

  params:= x-> extop(x,2);
  
  expr:= x -> (text2expr(dom::ordertype(x)))(op(dom::params(x)));
  
  nops:= x -> if dom::ordertype(x)<>"Block" then
                1
              else
                nops(dom::params(x))
              end_if;
  
  block:=
  proc(x:dom,i:Type::PosInt)
  begin
    if dom::ordertype(x)<>"Block" then
      if i<>1 then
        FAIL
      else
        x
      end_if
    elif i>dom::nops(x) then
      FAIL
    else
      dom::params(x)[i]
    end_if
  end_proc;
               
  blocktype:= (x,i) -> dom::ordertype(dom::block(x,i));
    
  orderlength:=
  proc(x:dom):DOM_INT
    local i;
  begin
    case dom::ordertype(x)
      of "Block" do
        return(_plus(dom::orderlength(dom::block(x,i)) $i=1..nops(x)))
      of "Lex" do
      of "DegLex" do
      of "RevLex" do
      of "DegRevLex" do
      of "DegInvLex" do  
        return(op(dom::params(x),1))
      of "WeightedLex" do
      of "WeightedDegLex" do
      of "WeightedRevLex" do
      of "WeightedDegRevLex" do
        return(nops(dom::params(x)))
      of "Matrix" do
        dom::params(x)[1];
        return(Matrices::matdim(%)[2])
    end_case;
    error("Unknown order");
  end_proc;

  blocklength:= (x,i) -> dom::orderlength(dom::block(x,i));

  ordermatrix:=
  proc(x:dom)
    local l,n,i, matrices,d;
  begin
    if extnops(x)>=3 then
      return(extop(x,3))
    end_if;
    n:=dom::orderlength(x);
    case dom::ordertype(x)
      of "Block" do
        l:=map(dom::params(x), dom::orderlength);
        d:=dom;
        matrices:=map([$1..nops(l)],
                      proc(j)
                      begin
                        _concat
                        ((
                          n:= d::orderlength(d::block(x, j));
                          if j>1 then
                            Matrices(n, _plus(l[i] $i=1..j-1), 0)
                          else
                            null()
                          end_if,
                          d::blockmatrix(x,j),
                          if j<nops(l) then
                            Matrices(n, _plus(l[i] $i=j+1..nops(l)), 0)
                          else
                            null()
                          end_if))
                      end_proc
                      );
        return(Matrices::stackMatrix(op(matrices)))
      of "Lex" do
        return(Matrices(n,n, [1 $ n], Diagonal))
      of "DegLex" do
        [ [1 $ n], [0 $i-1 , 1, 0 $n-i] $i=1..n-1]; break
      of "RevLex" do
        [ [0 $ n-i, 1, 0 $i-1 ] $i=1..n]; break
      of "DegRevLex" do
        [ [1 $ n], [0 $n-i, 1, 0 $i-1] $i=1..n-1]; break
      of "DegInvLex" do
        [ [1 $ n], [0 $n-i, -1, 0 $i-1] $i=1..n-1]; break
      of "WeightedLex" do  
        [ dom::params(x), [0 $i-1, 1, 0 $n-i] $i=1..n-1]; break
      of "WeightedDegLex" do
        [ dom::params(x), [1 $ n],[0 $i-1, 1, 0 $n-i] $i=1..n-2]; break
      of "WeightedRevLex" do
        [ dom::params(x), [0 $ n-i, 1, 0 $i-1] $i=1..n-1]; break
      of "WeightedDegRevLex" do
        [ dom::params(x), [1 $ n], [0 $n-i, 1, 0 $i-1] $i=1..n-2]; break
      of "Matrix" do
        return(op(dom::params(x)))
      otherwise
        error("Order has unknown type")
    end_case;
    //Matrix(n,n, %)
    Matrices::create(%)
  end_proc;
  

  blockmatrix:= (x,i) -> dom::ordermatrix(dom::block(x,i));


  orderweights:=
  proc(x:dom)
  begin
    case dom::ordertype(x)
      of "WeightedLex" do
      of "WeightedRevLex" do
      of "WeightedDegLex" do
      of "WeightedDegRevLex" do
        return(dom::params(x))
      otherwise
        return(Matrices::row(dom::ordermatrix(x),1))
    end_case;
  end_proc;

  blockweights:= (x,i) -> dom::orderweights(dom::block(x,i));


  cmpLex:=
  proc(l1, l2)
    local v1;
  begin
    if l1=l2 then
      return(0)
    end_if;
    v1:=map(zip(l1, l2, _subtract), sign);
    if contains(v1,-1)=0 then
      return(1)
    elif contains(v1,1)=0 then
      return(-1)
    else
      return(sign(contains(v1,-1)-contains(v1,1)))
    end_if
  end_proc;

  cmpRev:=
  proc(l1, l2)
    local v1;
  begin
    if l1=l2 then
      return(0)
    end_if;
    v1:=map(zip(l1, l2, _subtract), sign);
    if contains(v1,-1)=0 then
      return(1)
    elif contains(v1,1)=0 then
      return(-1)
    else
      return(-sign(contains(v1,-1)-contains(v1,1)))
    end_if
  end_proc;
    
  cmpDeg:=(l1, l2) -> sign(_plus(op(l1))-_plus(op(l2)));

  cmpDegLex:=
  proc(l1, l2)
  begin
    dom::cmpDeg(l1, l2);
    if not iszero(%) then
      %
    else
      dom::cmpLex(l1, l2)
    end_if;
  end_proc;

  cmpDegRevLex:=
  proc(l1, l2)
  begin
    dom::cmpDeg(l1, l2);
    if not iszero(%) then
      %
    else
      dom::cmpRev(l1, l2)
    end_if;
  end_proc;

  cmpDegInvLex:=
  proc(l1, l2)
    local s,i;
  begin
    dom::cmpDeg(l1, l2);
    if not iszero(%) then
      return(%)
    end_if;
    i:=nops(l1);
    while (s:=l2[i]-l1[i])=0 do
      i:=i-1;
      if i=0 then
        return(0)
      end_if
    end_while;  
    sign(s)
  end_proc;
    
  
  cmpWeighted:=
  proc(l1, l2, weightvector)

  begin
    sign(
    _plus(op(zip(l1, weightvector,_mult)))-
    _plus(op(zip(l2, weightvector,_mult)))
    )
  end_proc;
  
  func_call:=
  proc(x:dom, lone, ltwo):DOM_INT
    /* -1 means l1 < l2
       0 means l1 = l2
       1 means l1 > l2 */
    
  local n, e1, e2, v1, v2, A, i, l1, l2;
  begin
    l1:=context(lone);
    l2:=context(ltwo);
    if type(l1)<>DOM_LIST or type(l2)<>DOM_LIST then
	error("Wrong type of argument")
    end_if;
    userinfo(10, "Comparing ".expr2text(l1)." and ".expr2text(l2));
    n:=dom::orderlength(x);
    if nops(l1)>n or nops(l2)>n then
      error("Length of list does not match order length")
    end_if;
    // expand lists to correct length 
    l1:=l1.[0 $ n - nops(l1)];
    l2:=l2.[0 $ n - nops(l2)];
    case dom::ordertype(x)
      of "Lex" do
        dom::cmpLex(l1, l2);
        break
      of "DegLex" do
        dom::cmpDegLex(l1, l2);
        break
      of "RevLex" do
        dom::cmpRev(l1, l2);
        break
      of "DegRevLex" do
        dom::cmpDegRevLex(l1, l2);
        break
      of "DegInvLex" do
        dom::cmpDegInvLex(l1, l2);
        break
      of "WeightedLex" do
        dom::cmpWeighted(l1, l2, dom::params(x));
        if not iszero(%) then
          %
        else
          dom::cmpLex(l1, l2)
        end_if;
        break
      of "WeightedDegLex" do
        dom::cmpWeighted(l1, l2, dom::params(x));
        if not iszero(%) then
          %
        else
          dom::cmpDegLex(l1, l2)
        end_if;
        break
      of "WeightedRevLex" do
        dom::cmpWeighted(l1, l2, dom::params(x));
        if not iszero(%) then
          %
        else
          dom::cmpRev(l1, l2)
        end_if;
        break
      of "WeightedDegRevLex" do
        dom::cmpWeighted(l1, l2, dom::params(x));
        if not iszero(%) then
          %
        else
          dom::cmpDegRevLex(l1, l2)
        end_if;
        break
      otherwise        
        e1:=Matrices(n,1,l1);
        e2:=Matrices(n,1,l2);
        A:=dom::ordermatrix(x);
        v1:=A*e1; v2:=A*e2;
        for i from 1 to n do
          if v1[i]>v2[i] then
            return(1)
          elif v1[i]<v2[i] then
            return(-1)
          end_if;
        end_for;
        return(0)
    end_case;
    
  end_proc;
      
  begin
    Matrices:=Dom::/*Dense*/Matrix();
    
end_domain:


