/*   
*/
/*++
Dom::Numerical -- the domain of numbers

A number is represented by an expression of type DOM_INT, DOM_RAT,
DOM_FLOAT or DOM_COMPLEX.

The domain has category 'Cat::Field', which is very optimistic (indeed
false, because for example bool(1.0 = float(3) / float(3)) returns
FALSE). The category is assumed only because of pragmatism.

Methods:-
testtype(x,D)  - returns TRUE if x is of a numerical type
norm(x)        - returns the norm of x, ie., abs(x)
D(l,x)         - returns the derivation of x, ie., 0
convert(x)     - returns the value of x converted to Dom::Numerical
++*/

domain Dom::Numerical
    inherits Dom::ArithmeticalExpression;
    category Cat::Field, Cat::DifferentialRing;
    axiom 
        Ax::canonicalRep, Ax::systemRep,
        Ax::efficientOperation("_divide"), Ax::efficientOperation("_mult"),
        Ax::efficientOperation("_invert");

/* entries */

      
      
      
    characteristic:= 0;
    
    testtype:= proc(x,T)
    begin
        if T <> dom then 
            FAIL
        elif contains({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX}, domtype(x)) then
            TRUE 
        elif contains({DOM_FLOAT, DOM_COMPLEX}, domtype(float(x))) then
            TRUE
        else
            FAIL 
        end_if
    end_proc;

      _plus:= _plus;
      _subtract:= _subtract;
      _mult:= _mult;
      _divide:= _divide;
      _power:= _power;
      
    norm:= abs;

    D:= D;

    diff:= diff;

    convert:=
    proc(x)
    begin
      if contains({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX}, domtype(x)) then
        x
      else
        x:= float(x);
        if contains({DOM_FLOAT, DOM_COMPLEX}, domtype(x)) then
          x
        else
          FAIL
        end_if
      end_if
    end_proc;

    convert_to:= proc(x,T) local Tx; begin
        Tx:= domtype(x);
        if not contains({DOM_INT, DOM_RAT, DOM_FLOAT, DOM_COMPLEX}, Tx)
        then
            FAIL
        else
            case T
            of DOM_INT do
            of DOM_RAT do
            of DOM_COMPLEX do
              if Tx = T then x else FAIL end_if;
              break;
            of DOM_FLOAT do
            of Dom::Float do
                x:= float(x);
                if domtype(x) = DOM_FLOAT then x else FAIL end_if;
                break;
            of Dom::Numerical do
                x;
                break;
            of Dom::Integer do
                if Tx = DOM_INT then x else FAIL end_if;
                break;
            of Dom::Rational do
                if contains({DOM_INT, DOM_RAT}, Tx) then x else FAIL end_if;
                break;
            otherwise FAIL;
            end_case
        end_if
    end_proc;
    
    random:= () ->
        (tan(float(PI) * (random()/(10.0^12) - 0.5)) + tan(float(PI) * (random()/(10.0^12) - 0.5)) * I);
end_domain:

