//    

/*++ ---------------- Polynom.mu ---------------------

Description:
This domain represents polynomials in arbitrary many indeterminates
over arbitrary commutative rings. 
Most of the functions for DOM_POLY are available.
Note: It is highly recommend to use only coefficient rings with unique zero
      representation.

Call:

 Dom::Polynomial(Ring, Order) 
 where
   Ring    => arbitrary commutative ring of the Domains-package;
              * Default: Dom::ExpressionField(normal)
   Order   => set a term order. Currently is possible: 
              LexOrder, DegreeOrder, DegInvLexOrder;
              or any object of type Dom::MonomOrdering          
              * Default: LexOrder

All Entries:
D, Dpoly, Factor, Rep, TeX, TeXCoeff, TeXTerm, TeXindet, _divide, _invert,\
 _mult, _negate, _plus, _power, _subtract, adaptIndets, allAxioms, allCate\
gories, allEntries, allSuperDomains, associates, characteristic, coeff, co\
effRing, coerce, content, convert, convert_to, create_dom, decompose, degr\
ee, degreevec, diff, divide, divides, equal, equiv, evalp, expr, factor, g\
cd, getAxioms, getCategories, getSuperDomain, ground, has, hasProp, indets\
, info, int, intmult, irreducible, isNeg, isUnit, isone, iszero, key, lcm,\
 lcoeff, ldegree, lmonomial, lterm, mainvar, makeIntegral, mapcoeffs, moni\
c, mult, multcoeffs, new, nterms, nthcoeff, nthmonomial, nthterm, numericS\
olve, one, orderedVariableList, ordering, pivotSize, plus, poly, primpart,\
 print, printMethods, printMonomial, printTerm, random, reductum, resultan\
t, ringmult, sign, solve, sqrfree, subs, subsex, tcoeff, testtype, undefin\
edEntries, unitNormal, unitNormalRep, whichEntry, zero
                        
Example:

>> P := Dom::Polynomial(Dom::Rational)
>> p1 := P(3*x-2)
>> p2 := P(5*x^3*y^2*z-z^3+5*y^2+1+x)
>> p1^2-3*p2+5
                        
++*/

domain Dom::Polynomial(R=Dom::ExpressionField(normal),Order=LexOrder)
    inherits Dom::DistributedPolynomial([],R,Order);
    category Cat::Polynomial(R);
    axiom    (if R::hasProp(Ax::normalRep)
                //or (R::constructor=Dom::ExpressionField and
		// R::hasProp(Ax::systemRep))
                then Ax::normalRep end_if),
             (if R::hasProp(Ax::canonicalRep) then Ax::canonicalRep end_if),
                Ax::indetElements;

// removing inherited entries, which are useless with respect to this domain
  variables:=()->FAIL;
      
begin
    if args(0) > 2 then error("Wrong no of args") end_if;
    if R::dom=DOM_DOMAIN then
      if R::hasProp(Dom::BaseDomain) = FAIL then
        R := Dom::ExpressionField(normal)
      elif not(R::hasProp(Cat::CommutativeRing)) then
        error("Illegal coefficient ring")
      end_if;
    else
      error("Illegal coefficient ring");
    end_if;
  //The following if-statement would nearly always solve the termination 
  //problem ("unique zero") by polynomial division and yield a correct degree.
    //if R::constructor=Dom::ExpressionField and R::hasProp(Ax::systemRep) then
    //  R:=Dom::ExpressionField(id, iszero@normal)
    //end_if;
    if not contains({LexOrder, DegreeOrder, DegInvLexOrder}, Order)
       and type(Order)<>Dom::MonomOrdering
      then error("Unknown monomial ordering");
    end_if;
end_domain:
