
//       

// stefanw, 20.03.1997 

/*++

Dom::Quaternion - 
the skew field of quaternions

An element is represented as a domain element with operands:

0 - domain Dom::Quaternion
1 - a list [a,b,c,d] of four real numbers, representing a+bI+cJ+dK 

[a,b,c,d] may also be regarded as a 2x2 - matrix 

	(  a+bI   -c-dI )
	(	        )
	(  c-dI    a-bI )

over the field of complex numbers.      

++*/

domain Dom::Quaternion
  
  inherits Dom::BaseDomain;
  category Cat::SkewField;
    axiom Ax::canonicalRep;
      
      size:= infinity;

      zero:= new(dom,[0,0,0,0]);
      
      one:= new(dom, [1,0,0,0]);

      characteristic:= 0;

      convert:=
      proc()
      begin
        case domtype(args(1))
          of dom do
            return(args(1))
          of DOM_INT do
          of DOM_FLOAT do
          of DOM_RAT do
            return(new(dom,[args(1),0,0,0]))
          of DOM_COMPLEX do
            return(new(dom,[Re(args(1)),Im(args(1)),0,0]))
          of DOM_LIST do
            if nops(args(1)) <> 4 then
              error("List of length four expected");
            elif {op(map(args(1), is, Type::Real)) } <> {TRUE} then
              error("List must consist of real numbers");
            else
              return(new(dom, args(1)));
            end_if
          of DOM_IDENT do
            if args(1)=PI then
              return(new(dom,[PI,0,0,0]))
            elif args(1)=hold(i) then
              return(new(dom,[0,1,0,0]))
            elif args(1)=hold(J) or args(1)=hold(j) then
              return(new(dom,[0,0,1,0]))
            elif args(1)=hold(K) or args(1)=hold(k) then
              return(new(dom,[0,0,0,1]))
            else
              return(FAIL)
            end_if
          of DOM_EXPR do
            case type(args(1))
              of "_plus" do
                return(dom::_plus(map(op(args(1)),dom::convert)))
              of "_mult" do
                return(dom::_mult(map(op(args(1)),dom::convert)))
              of "_power" do
                // test whether operands are elements of C 
                if {type(float(op(args(1),1))),
                  type(float(op(args(1),2)))} minus
                  {DOM_FLOAT, DOM_COMPLEX} = {} then
                  return(new(dom, [Re(args(1)), Im(args(1)),0,0]))
                end_if;                  
                return(dom::_power(dom::convert(op(args(1),1)),
                                   op(args(1),2)))
            end_case;
            if is(args(1),Type::Real)=TRUE then
              return(new(dom,[args(1),0,0,0]))
            end_if;
            return(FAIL)
          of Dom::/*Dense*/Matrix(Dom::Complex) do
            if normal(conjugate(args(1)[1,1])<>args(1)[2,2]) or
              normal(-conjugate(args(1)[1,2])<>args(1)[2,1]) then
              return(FAIL)
            else
              return(new(dom,map([Re((args(1)[1,1])), Im((args(1)[1,1])),
                                  Re((args(1)[2,1])), -Im((args(1)[2,1]))],
                                 expr)))
            end_if
        end_case;
        FAIL
      end_proc;

      convert_to:=
      proc()
      begin
          case args(2)
            of DOM_LIST do
              return(extop(args(1),1));
            of dom do return(args(1))
            of DOM_COMPLEX do
              if op(extop(args(1),1),3..4)<>(0,0) then
                return(FAIL)
              else
                return(op(extop(args(1),1),1)+I*op(extop(args(1),1),2))
              end_if
            of DOM_FLOAT do
              if op(extop(args(1),1),2..4)<>(0,0,0) then
                return(FAIL)
              else
                return(float(op(extop(args(1),1),1)))
              end_if
            of Dom::/*Dense*/Matrix(Dom::Complex) do
              return(dom::matrixform(args(1)))
          end_case;
        FAIL
      end_proc;

    
	

      expr:=
      proc(x)
      begin        
        x := extop(x,1);
        x := select([x[1], x[2]*I,x[3]*hold(J),
                     x[4]*hold(K)], not iszero);
        case nops(x)
          of 0 do return(0)
          of 1 do return(op(x))
        end_case;
        hold(_plus)(op(x))
      end_proc;
					 

      print:= x -> dom::expr(x);

      Content:=
      proc(Out, x)
      begin
        x := extop(x,1);
        x := select([x[1], x[2]*I,x[3]*hold(j),
                     x[4]*hold(k)], not iszero);
        case nops(x)
          of 0 do return(Out(0))
          of 1 do return(Out(op(x)))
        end_case;
        Out(hold(_plus)(op(x)))
      end_proc;
      
      _plus:=
      proc()
        local i,j;
        
      begin
        map([args()],dom::coerce);
        if contains(%,FAIL)=0 then
          new(dom, [_plus(op(op((map(map(%, extop, 1),op,i))
                                $i=1..4 ,j) )) $j=1..4])
        else
          FAIL
        end_if
      end_proc;

      _negate:=
      proc(x)
        local i;
      begin
        new(dom,[-op(extop(x,1),i) $i=1..4])
      end_proc;

      _subtract:=
      proc(x,y)
        local i;
      begin
        new(dom,[op(extop(dom::coerce(x),1),i)-op(extop(dom::coerce(y),1),i)
                 $i=1..4])
      end_proc;

      _mult:=
      proc()
        begin
          if args(0)=1 then
            args(1)
          elif args(0)=2 then
            if domtype(args(2)) <> dom then
              if is(args(2), Type::Real)=TRUE then
                dom::scalarmult(args(2),args(1))
              else
                dom::convert(args(2));
                if %<>FAIL then
                  dom::_mult(args(1),%)
                else
                  (domtype(args(2)))::_mult(args())
                end_if;
                
              end_if
            elif domtype(args(1)) <> dom then
              if is(args(1), Type::Real)=TRUE then
                dom::scalarmult(args())
              else
                dom::convert(args(1));
                if %=FAIL then
                  FAIL
                else
                  dom::_mult(%, args(2))
                end_if
              end_if
            else
              extop(args(1),1);
              extop(args(2),1);
              new(dom,[
                       %2[1]*%[1]-%2[2]*%[2]-%2[3]*%[3]-%2[4]*%[4],
                       %2[1]*%[2]+%2[2]*%[1]+%2[3]*%[4]-%2[4]*%[3],
                       %2[1]*%[3]-%2[2]*%[4]+%2[3]*%[1]+%2[4]*%[2],
                       %2[1]*%[4]+%2[2]*%[3]-%2[3]*%[2]+%2[4]*%[1]
                       ])
            end_if
          else
            _mult(args(1..(args(0) div 2)));
            _mult(args(((args(0) div 2) + 1)..args(0)));
            if (domtype(%2))::_mult <> FAIL then
              (domtype(%2))::_mult(%2, %1)
            elif (domtype(%1))::_mult <> FAIL then
              (domtype(%1))::_mult(%2, %1)
            else
              _mult(%2, %1)
            end_if
          end_if
      end_proc;

      scalarmult:=
      proc(lambda, x)
        local i;
      begin
        new(dom,[args(1)*op(extop(args(2),1),i) $i=1..4])
      end_proc;

      scalarprod:=
      proc(x:dom,y:dom)
        local i;
      begin
        _plus(extop(x,1)[i]*extop(y,1)[i]
              $i=1..4)
      end_proc;


      conjugate:=
      proc(x)
        local i;
      begin
        new(dom,[extop(x,1)[1],-extop(x,1)[i]
                 $i=2..4])
      end_proc;



      intpower:=domains::repeatedSquaring(dom, "_mult", "one", "_invert");

      nthroot:=
      proc(x:dom, n:DOM_INT)
        local i, impart, phix;
      begin
        if iszero(n) then
          error("nth root is undefined for n=0")
        end_if;
        if n<0 then
          return(dom::_invert(dom::nthroot(x,-n)))
        end_if;
        impart:=Im(x);
        if iszero(impart) then
          return(dom::new(Re(x)^(1/n)))
        end_if;
        i:=impart/abs(impart);
        /* the subfield generated by 1+i is isomorphic to the complex
      numbers, and x = Re(x) + abs(impart) * i */
        // let phi be the isomorphism i -> I 

        phix:=Re(x)+ I * abs(impart);
        rectform(phix^(1/n));
        expr(Re(%))+ i*expr(Im(%))
      end_proc;
        
      _power:=
      proc(x:dom, n)

      begin
        if type(n)=DOM_INT then
          dom::intpower(x, n)
        elif type(n)=DOM_RAT then
          dom::nthroot(x, denom(n))^numer(n)
        else
          error("Exponent must be rational number")
        end_if
      end_proc;
          
      
      matrixform:=
      proc()
      begin
        Dom::/*Dense*/Matrix(Dom::Complex)
        (
         [[extop(args(1),1)[1]+extop(args(1),1)[2]*I,
           -extop(args(1),1)[3]-extop(args(1),1)[4]*I],
          [extop(args(1),1)[3]-extop(args(1),1)[4]*I,
           extop(args(1),1)[1]-extop(args(1),1)[2]*I]])
      end_proc;

      _invert:= x -> dom::convert(dom::matrixform(x)^(-1));

      Re:= x -> extop(x,1)[1];
      
      Im:=
      proc(x)
        local j;
      begin
        new(dom, [0, extop(x,1)[j] $j=2..4]);
      end_proc;

//    "_divide" : defined in Cat::Group  

      norm:=
      proc(x)
        local i;
      begin
        _plus(extop(x,1)[i]^2 $i=1..4);
      end_proc;

      abs:= x -> sqrt(norm(x));

      sign:= x -> dom::scalarmult( 1/abs(x), x);


      map:= x -> new(dom, map(extop(x,1), args(2..args(0))));

      simplify:= x -> map(x, simplify);


      TeX:= x-> expr2text(expr(x));

      
      random:=
      proc()
      begin               
        new(dom,[random(), random(), random(), random()])
      end_proc;
			
begin
	userinfo(4, "Creating domain Dom::Quaternion");
end_domain:		
// end of file 
