//    
/*++
Dom::Rational -- the domain of rational numbers

A rational number is represented by an expression of type DOM_INT
or DOM_RAT.

Methods:-
convert(x)         - returns the value of x converted to Dom::Rational
numer(x)	   - returns the numerator of x
denom(x)	   - returns the denominator of x
retract(x)	   - returns x if it is an integer and FAIL otherwise
testtype(x,T)      - returns TRUE if x is of type DOM_INT or DOM_RAT
min(x,...)	   - returns the minimal argument
max(x,...)	   - returns the maximal argument
++*/

domain Dom::Rational
  inherits Dom::Numerical;
  category Cat::QuotientField(Dom::Integer) , Cat::DifferentialRing, Cat::OrderedSet;
  axiom Ax::canonicalRep, Ax::systemRep, Ax::canonicalOrder,
        Ax::efficientOperation("_divide"), Ax::efficientOperation("_mult"),
        Ax::efficientOperation("_invert");

    testtype:= (x,T) -> (
	if T <> Dom::Rational then return(FAIL) end_if ;
	if T = dom and contains({DOM_INT, DOM_RAT}, domtype(x)) then
	    TRUE
	else
	    FAIL
	end_if
    );

    numer:= (()->((
	if domtype(args(1)) = DOM_RAT then op(args(1),1) else args(1) end_if
    )));

    denom:= (()->((
	if domtype(args(1)) = DOM_RAT then op(args(1),2) else 1 end_if
    )));

    retract:= (()->((
	if domtype(args(1)) = DOM_INT then args(1) else FAIL end_if
    )));

    convert:= (()->((
       if contains({DOM_INT, DOM_RAT}, domtype(args(1))) then
          args(1)
       else
          FAIL
       end_if
    )));

    convert_to:= (()->((
	if not contains({DOM_INT, DOM_RAT}, domtype(args(1))) then FAIL else
	    case args(2)
	    of Dom::Rational do
	    of Dom::Numerical do
		args(1);
		break;
	    of DOM_RAT do
		if domtype(args(1)) = DOM_RAT then args(1) else FAIL end_if;
		break;
	    of Dom::Integer do
	    of DOM_INT do
		if domtype(args(1)) = DOM_INT then args(1) else FAIL end_if;
		break;
	    of DOM_FLOAT do
	    of Dom::Float do
		float(args(1));
		break;
	    otherwise FAIL;
	    end_case
	end_if
    )));

    diff:= z -> (if args(0) = 1 then z else 0 end_if); 

    random:= (()->((
        (Dom::Integer)::random();
        if % = 0 then 0 else (Dom::Integer)::random() / % end_if
    )));

    TeXrep := x -> "\\mathbb{Q}";

begin
  NIL
end_domain:

