/* SparseMatrixF2 - the domain of sparse matrices over Dom::IntegerMod(2)
  A sparse matrix is represented as a list of rows; each row is a set
  of indices representing the nonzero entries.  */


domain Dom::SparseMatrixF2
local F2;
inherits Dom::BaseDomain;
category Cat::Matrix(Dom::IntegerMod(2));
axiom Ax::canonicalRep;


coeffRing:=F2;

isSparse:=TRUE;
  
new:=
proc(m:DOM_INT, n:DOM_INT, body)
  local seqn, testargi, i;
begin

  // Test if the indicies inside 
  testargi:=
  proc(number)
    name testarg;
  begin
    if domtype(number) <> DOM_INT then
      return(FALSE);
    end_if;
    if (number < 1) or (number>n) then
      return(FALSE);
    end_if;
    return(TRUE);
  end_proc;
  
  case type(body)
    of DOM_LIST do
      if nops(body)<>m then
        error("Wrong number of rows")
      end_if;
      case map({op(body)}, domtype)
        of {DOM_SET} do
          if testargs() then
            if contains(map({op(op(body,i)) $i=1..m}, testargi), FALSE) then
              error("Wrong index inside the rows");
            end_if;
          end_if;
          return(new(dom, m, n, body))
        of {DOM_LIST} do
          if testargs() then
            if contains(map({op(op(body,i)) $i=1..m}, testargi), FALSE) then
              error("Wrong index inside the rows");
            end_if;
          end_if;
          return(new(dom, m, n, map(body, x-> {op(x)})))
        otherwise
          error("Illegal type of operands")
      end_case
      
    otherwise // regard third argument as proc 
      seqn:={$1..n};
      return(new(dom, m, n, [select(seqn, u->                               
                                    F2(body(i,u))= F2::one)  $i=1..m]))  
  end_case;
end_proc;

// just for compatiblity, as this method was removed from
// Cat::Matrix since MuPAD 2.0! (In Cat::Matrix the default implementation
// was set to "new".)
create:= dom::new;

convert:=
proc(A)
begin
  if type(A)=dom then
    A
  else
    FAIL
  end_if
end_proc;


convert_to:=
proc(A:dom, T:DOM_DOMAIN)
local r, c, t, j, i;
begin
  case T
  of dom do
    return(A)
  of Dom::Matrix(Dom::IntegerMod(2)) do
    r:= dom::nrows(A):
    c:= dom::ncols(A):
    t:= table():
    for i from 1 to r do
       (t[i, j]:= 1) $ j in extop(A, 3)[i];
    end_for:
    return(T(r, c, t))
  of Dom::DenseMatrix(Dom::IntegerMod(2)) do
    return(T(dom::nrows(A), dom::ncols(A), (i,j)-> A[i,j]))
  otherwise
    FAIL
    end_case
end_proc;
  
nrows:= A -> extop(A,1);


ncols:= A -> extop(A,2);

body:= A -> extop(A,3);

// necessary for old versions of MatrixCat:
// dimen:= A -> [extop(A,1), extop(A,2)];

// now:
matdim:= A -> [extop(A,1), extop(A,2)];

row:= (A,n) -> new(dom, 1, extop(A,2),[(extop(A,3))[n]]);

col:=
proc(A: dom, n: DOM_INT)
  local i: DOM_INT;
begin
  new(dom, extop(A,1), 1,
      [ if has((dom::body(A))[i], n) then
          {1}
        else
          {}
        end_if
       $i=1..dom::nrows(A)])
end_proc;

iszero:= A -> bool(_union(op(dom::body(A)))={});

_index:=
proc(A:dom,i:DOM_INT,j)
begin
  if args(0)<2 then
    error("Wrong number of arguments")
  end_if;
  if args(0)=2 then
    if dom::nrows(A)=1 then
      return(A[1,i])
    elif dom::ncols(A)=1 then
      return(A[i,1])
    else
      return(dom::row(A,i))
    end_if
  end_if;
  
    
  if has(dom::body(A)[i], j) then
    F2::one
  else
    F2::zero
  end_if
end_proc;

set_index:=
proc(A:dom, i:DOM_INT, j:DOM_INT, a)
begin
  if i<1 or i>dom::nrows(A) or j<1 or j>dom::ncols(A) then
    error("Illegal index")
  end_if;
  case F2::convert(a)
  of FAIL do
    error("Argument could not be converted to element of coefficient ring")
  of F2::one do
    return(extsubsop(A, 3=subsop(dom::body(A), i=op(dom::body(A),i) union {j})))
  of F2::zero do
    return(extsubsop(A, 3=subsop(dom::body(A), i=op(dom::body(A),i) minus {j})))
  otherwise
    error("Cannot handle right hand side") // should not happen 
  end_case
end_proc;
       
  
zeroMatrix:= (m,n) -> new(dom, m, n, [ ({} $m)]);

randmatrix :=
proc(m:DOM_INT, n:DOM_INT, s=6:DOM_INT)
  local rndgen,i,j;
begin
  rndgen:=random(n);
  new(dom, m, n, [{ rndgen()+1 $j=1..s } $i=1..m])
end_proc;
  
concatMatrix:=
proc(A,B)

begin
if A::dom::nrows(A)<>B::dom::nrows(B) then
  error("Numbers of rows differ")
end_if;
  new(dom, dom::nrows(A), dom::ncols(A)+dom::ncols(B),
      zip(dom::body(A), map(dom::body(B), map, _plus, dom::ncols(A)), _union))
end_proc;  

_concat:=
proc()
begin
  if args(0)=1 then args(1)
  else
    dom::concatMatrix(_concat(args(1..args(0)-1)), args(args(0)))
  end_if
end_proc;
  

stackMatrix:=
proc(A,B)

begin
  if dom::ncols(A) <> dom::ncols(B) then
    error("Numbers of columns differs")
  end_if;
  
  new(dom, dom::nrows(A)+dom::nrows(B), dom::ncols(A),dom::body(A).dom::body(B))
end_proc;

_plus:=
proc(A,B)

begin
  if args(0)=1 then
    args(1)
  elif args(0)>2 then
    dom::_plus(dom::_plus(args(1..args(0) div 2)),
               dom::_plus(args((args(0) div 2)+1..args(0))))
  else
    if dom::nrows(A)<> dom::nrows(B) or dom::ncols(A)<> dom::ncols(B) then
      error("Dimensions do not match")
    end_if;
    
    new(dom, dom::nrows(A), dom::ncols(A),
        zip(dom::body(A), dom::body(B),  (x,y)-> (x union y) minus (x intersect y)))
  end_if
end_proc;

_negate:= id;
  
_mult:=
proc(A,B)
begin
  case type(A)
  of dom do break;
  of Dom::IntegerMod(2) do
    if iszero(A) then
      return(dom::zeroMatrix(dom::nrows(B), dom::ncols(B)))
    else
      return(B)
    end_if
  otherwise
    return(FAIL)
  end_case;

  case type(B)
  of dom do break;
  of Dom::IntegerMod(2) do
    if iszero(B) then
       return(dom::zeroMatrix(dom::nrows(A), dom::ncols(A)))
    else
      return(A)
    end_if
  otherwise
    return(FAIL)
  end_case;
  
  if dom::ncols(A)<>dom::nrows(B) then
    error("Dimensions do not match")
  end_if;

  if dom::ncols(B)=1 then
    dom::matrixvectorproduct(A,B)
  else
    error("Not implemented")
  end_if
end_proc;



matrixvectorproduct:=
proc(A,v)
  local bd, Abd, i: DOM_INT;
begin
  bd:= dom::body(v);
  Abd:= dom::body(A);
  new(dom, dom::nrows(A), 1,
      [  (if _plus(op(map([op(Abd[i])], x -> op(bd[x])))) mod 2 = 1 then
            {1}
          else
            {}
          end_if)
       $i=1..dom::nrows(A) ])
end_proc;



expr:= A -> dom::body(A);


map:=proc()
     begin
       userinfo(5, "map called with ".expr2text(args()));
       error("Not yet implemented");
     end_proc;
    
Content:=(Out, Mat) -> Out(dom::print(Mat));
  
begin
F2:=Dom::IntegerMod(2);                          
                          
end_domain:

