//    

/*++ ---------------- UniPoly.mu ---------------------

Description:
This domain represents univariate polynomials in some identifier over 
commutative coefficient rings.
Most of the functions for DOM_POLY are available.
Note: It is highly recommend to use only coefficient rings with unique zero
      representation.

Call:

 Dom::UnivariatePolynomial(Var, Ring, Order) 
 where
   Var   => indeterminate of type DOM_IDENT; 
            * Default: x
   Ring  => arbitrary commutative ring of the Domains-package;
            * Default: Dom::ExpressionField(normal)
   Order => set a term order. Currently is possible: 
            LexOrder, DegreeOrder, DegInvLexOrder;
            or any object of type Dom::MonomOrdering          
            * Default: LexOrder

Methods: 

 - used Parameter:
    ++ a : this Domain
    ++ n : DOM_INT

 - vectorize(a, < n >)
    ++ returns a in it's vectorized form, i.e. *all* coefficients of a in
    ++ increasing order. When n is given (and long enough) a list of n entries
    ++ maybe filled up with zeros is returned.  

All Entries:
D, Dpoly, Factor, Rep, SPolynomial, TeX, TeXCoeff, TeXTerm, TeXindet, _div\
ide, _invert, _mult, _negate, _plus, _power, _subtract, allAxioms, allCate\
gories, allEntries, allSuperDomains, associates, borderedHessianDet, borde\
redHessianMat, characteristic, coeff, coeffRing, coerce, content, convert,\
 convert_to, create_dom, decompose, degLex, degRevLex, degree, degreevec, \
diff, dimension, divide, divides, equal, equiv, euclideanDegree, evalp, ex\
pr, factor, func_call, gcd, gcdex, getAxioms, getCategories, getSuperDomai\
n, groebner, ground, has, hasProp, hessianDet, hessianMat, homogeneousComp\
onents, idealGenerator, indets, info, int, intmult, irreducible, isHomogen\
eous, isNeg, isUnit, isone, iszero, jacobianDet, jacobianMat, key, lcm, lc\
oeff, ldegree, lmonomial, lterm, mainvar, makeIntegral, mapcoeffs, monic, \
mult, multcoeffs, new, normalForm, nterms, nthcoeff, nthmonomial, nthterm,\
 numericSolve, one, order, orderedVariableList, ordering, pdioe, pdivide, \
pivotSize, plus, poly, pquo, prem, primpart, print, printMethods, printMon\
omial, printTerm, quo, random, realSolve, reductum, rem, resultant, rewrit\
eHomPoly, rewritePoly, ringmult, sign, solve, sortList, sqrfree, stableSor\
t, subs, subsex, tcoeff, testtype, undefinedEntries, unitNormal, unitNorma\
lRep, variables, vectorize, whichEntry, zero


Example:
>> UP := Dom::UnivariatePolynomial(x, Dom::Integer);
>> up1:= UP(3*x-2);

++*/

/* Dependencies:

  DistPoly.mu  */

alias( rep(x) = extop(args(x),1) ):

domain Dom::UnivariatePolynomial(Var=x:DOM_IDENT,
                                 R=Dom::ExpressionField(normal), 
                                 Order=LexOrder)
    //inherits Dom::DistributedPolynomial([Var],R,Order);
    inherits Dom::MultivariatePolynomial([Var],R,Order);
    category Cat::UnivariatePolynomial(R);
    axiom    (if R::hasProp(Ax::normalRep)
               // or (R::constructor=Dom::ExpressionField and
	       //     R::hasProp(Ax::systemRep))
                then Ax::normalRep end_if),
             (if R::hasProp(Ax::canonicalRep) then Ax::canonicalRep end_if);
 
/* the entries */

    coeff:= proc(p, x, n)
          local cl;
          begin
            if x = All then
              return(coeff(rep(p), args(2..args(0))));
            end_if;
            if dom::iszero(p) then return( R::zero ) end_if;
            cl := [];
            case args(0)
              of 1 do while not dom::iszero(p) do
                        cl := append(cl, dom::lcoeff(p));
                        p  := dom::reductum(p)
                      end_while;
                      return( op(cl) );
              of 3 do
                if x<>Var then error("Only ".expr2text(Var).
                                     " is valid as variable")
                end_if;
              of 2 do
                R::new( coeff(rep(1), args(2..args(0))) ); break;
              otherwise
                error("Wrong number of arguments");
            end_case
	  end_proc;

    vectorize:= proc(p, n)
     local i;
     begin
       if args(0) = 1 then n := dom::degree(p) + 1
         elif dom::degree(p) > n-1 then
           error("Too short vector to represent this polynomial") end_if;
       [dom::coeff(p, i) $ i=0..n-1]
     end_proc;

/* procedure body of the domain */

begin
  if args(0) > 3 then error("Wrong no of args") end_if;
  if domtype(Var) <> DOM_IDENT then
    error("Illegal indeterminate")
  end_if;
  if R::dom=DOM_DOMAIN then
    if R::hasProp(Dom::BaseDomain) = FAIL then
      R := Dom::ExpressionField(normal)
    elif not(R::hasProp(Cat::CommutativeRing)) then
      error("Illegal coefficient ring")
    end_if;
  else
    error("Illegal coefficient ring");
  end_if;
  //The following if-statement would nearly always solve the termination 
  //problem ("unique zero") by polynomial division and yield a correct degree.
  //if R::constructor=Dom::ExpressionField and R::hasProp(Ax::systemRep) then
  //  R:=Dom::ExpressionField(id, iszero@normal)
  //end_if;
  if not contains({LexOrder, DegreeOrder, DegInvLexOrder}, Order)
    and type(Order)<>Dom::MonomOrdering
    then error("Unknown monomial ordering");
  end_if;
end_domain:

unalias( rep ):























