// kg, 26/06/96 

/*++
fp::unapply -- create a procedure from an expression

fp::unapply(e, [x1,...,xn])

e         - expression, regarded as function of x1,...,xn
x1,...,xn - (optional) indeterminates (DOM_IDENT or indexed)

fp::unapply views the expression e as a function of the indeterminates
x1,...,xn and returns a procedure computing that function.
If no indeterminates are given, any indeterminates of e found by indets
are used.

Examples:

fp::unapply(sin(x), x)		-> proc(x) begin sin(x) end_proc
fp::unapply(x+y, y, x)		-> proc(y,x) begin x+y end_proc
fp::unapply(2*x^2+1)		-> proc(x) begin 2 * x^2 + 1 end_proc
++*/

fp::unapply:=
proc(e)
  local Args, unused_idents, i;
begin
  if testargs() then
    if args(0) < 1 then
      error("Wrong number of arguments")
    end_if;
    if args(0) > 1 then
      Args:= { args(2..args(0)) };
      // if (nops(Args) <> args(0) - 1) or (Args <> indets(Args)) then
      if map(Args, testtype, Type::Indeterminate) <> {TRUE} then
        error("Wrong indeterminates")
      end_if
    end_if
  end_if;

  if e::dom::unapply <> FAIL then
    return(e::dom::unapply(args()))
  end_if;

  if domtype(e) = DOM_POLY then
    return(fp::unapply(expr(e), args(2..args(0))))
  end_if;
  
  // get indeterminates 
  if args(0) = 1 then
    Args := [op(freeIndets(e) minus Type::ConstantIdents)]
  else
    Args := [args(2..args(0))]
  end_if;
  
  if Args = [] then
    funcenv(subsop(proc() option arrow; begin end, 4=e, Unsimplified))
  else
    // get names of protected identifiers not used in e
    unused_idents := map(Args,
			 proc(id)
			   local i, v;
			 begin
			   i := 1;
			   while has(e, [(v := `#`.id.i)]) do
			     i := i+1;
			   end_while;
			   v;
			 end_proc);
    funcenv(subsop(proc() option arrow; begin eval(subs(hold(0), 1)) end,
		   1=op(Args),
		   [4,1,1,1]=subs(e, zip(Args, unused_idents, `=`)),
		   [4,1,2]=[unused_idents[i]=DOM_VAR(0,1+i) $ i=1..nops(Args)],
		   Unsimplified),
            // used for funcenv as 0-th operand in expressions
            subsop(() -> subsop(hold((proc() option arrow; begin end)(`#xx`)), 1=op(args()), Unsimplified),
                         [4, 1, 1, 0, 1]=op(Args), [4, 1, 1, 0, 4]=e, Unsimplified),
	    table(// print method is used for output of funcenv itself
             "print" = subsop(() -> (proc() option arrow; begin end),[4, 1]=op(Args), [4, 4]=e, Unsimplified),
             "D" = subs(proc(idx, f)
                         local i;
                        begin
                         if args(0) = 1 then
                           idx := [1];
                         end_if;
                         f := `#e`;
                         for i in idx do
                           f := diff(f, `#Args`[i]);
                         end_for;
                         f := rewrite(f, D);
                         fp::unapply(f, op(`#Args`));
                        end_proc,
                        [`#e`=e, `#Args`=Args])));
  end_if
end_proc:

// end of file 
