
alias(MC = output::MMLContent):
alias(MP = output::MMLPresentation):
alias(XML = adt::XML):

/*

Call(s):

  generate::MathML(e <, options>)
  
Options:

  Content      = b  -  do or do not generate MathML content;
                       b must be TRUE or FALSE. The default value is TRUE.
  Presentation = b  -  do or do not generate MathML presentation;
                       b must be TRUE or FALSE. The default value is TRUE.
  Annotation   = b  -  do or do not generate MathML annotations;
                       b must be TRUE or FALSE. The default value is TRUE.


Either Content or Presentation must be set to TRUE;
generate::MathML(e, Content = FALSE, Presentation = FALSE) yields an error.

Examples:

Example 2:

Just generate MathML content. Do not generate MathML presentation and
do not insert annotations like  
<annotation-xml encoding='MathML-Content'/>
and
<annotation encoding='MuPAD'> ... </annotation>


>> generate::MathML(
      int( f(x)^2, x = -PI .. infinity ),
      Presentation = FALSE, Annotation = FALSE
   )

              <math xmlns='http://www.w3.org/1998/Math/MathML'>
                <apply id='No9'>
                  <int/>
                  <bvar>
                    <ci id='No1'>x</ci>
                  </bvar>
                  <lowlimit>
                    <apply id='No2'>
                      <minus/>
                      <pi/>
                    </apply>
                  </lowlimit>
                  <uplimit>
                    <cn id='No3' type='constant'><infinity/></cn>
                  </uplimit>
                  <apply id='No8'>
                    <power/>
                    <apply id='No6'>
                      <ci id='No4'>f</ci>
                      <ci id='No5'>x</ci>
                    </apply>
                    <cn id='No7' type='integer'>2</cn>
                  </apply>
                </apply>
              </math>

*/

generate::MathML :=
proc()
  local argType, MMLContent, 
        _Content, _Presentation, _Annotation, a, l;
begin

  l := [args()];
  _Content      := TRUE;
  _Presentation := TRUE;
  _Annotation   := TRUE;
  if has(l, Content = FALSE) then
    _Content := FALSE;
  end_if;
  if has(l, Presentation = FALSE) then
    _Presentation := FALSE;
  end_if:
  if has(l, Annotation = FALSE) then
    _Annotation := FALSE;
  end_if;

  if _Presentation = FALSE and _Content = FALSE then
     error("Either Presentation or Content must be set to TRUE.")
  end;

  l := op(select(l, _not@has, {Content, Presentation, Annotation}));

  argType := domtype(l);

  // load domain to prevent strange loadproc effects
  MC;
  // reset counter for IDs
  sysassign(MC::refCount, 0);
  if argType <> DOM_PROC then
    sysassign(MC::currentObject, l);
  else
    sysassign(MC::currentObject, expr2text(l));
  end_if;
  
  a := [];
  MMLContent := MC(l);
  if _Presentation and
     traperror((a := [MP(MMLContent)])) <> 0 then
    _Presentation := FALSE;
    if _Content then
   //   warning("presentation not available");
    else
      error("presentation not available");
    end_if;
  end_if;
  
  if _Presentation then
    if _Content then
      a := a.[XML::Element("annotation-xml", ["encoding"="MathML-Content"],
                           MMLContent)]
    end_if;
  elif _Content then
    a := [MMLContent]
  end;

  if _Annotation then
    a := a.[XML::Element("annotation", ["encoding"="MuPAD"],
                         XML::str2cdata(expr2text(l)))]
  end;

  if nops(a) = 1 then
    XML::Element(
       "math", ["xmlns"="http://www.w3.org/1998/Math/MathML"], op(a)
    )
  else
    XML::Element(
       "math", ["xmlns"="http://www.w3.org/1998/Math/MathML"], 
       XML::Element("semantics",
                    //MP::maction(["actiontype"="restyle#zoom"]),
                    op(a))
    )
  end_if;
end_proc:
        