/*--
mma.mu - Mathematica-formatted output of expressions
--*/

/*++
generate::mathematica -- return Mathematica-formatted string for expression

generate::mathematica(e)

e - expression, equation or list of equations
++*/

generate::mathematica:=proc(e)
begin
   if e::dom::mathematica<>FAIL then return(e::dom::mathematica(args())) end_if;
   case type(e)
   of "_plus" do return("(".generate::mma_exprseq([op(e)],"+","0").")")
   of "_mult" do return("(".generate::mma_exprseq([op(e)],"*","1").")")
   of "_power" do return(generate::mathematica(op(e,1))."^".
			 generate::mathematica(op(e,2)))
   of "int" do return("Integrate[".generate::mathematica(op(e,1)).",".
	(if domtype(op(e,2))=DOM_IDENT then expr2text(op(e,2))
	 else "{".generate::mma_exprseq([op(e,[2,1]),op(op(e,[2,2]))],",","").
	"}" end_if)."]")
   of stdlib::Infinity do return((if e=infinity then "" else "-" end_if)
	."Infinity")
   end_case;
   table("arccos"="ArcCos","arccosh"="ArcCosh","arccot"="ArcCot","arccoth"="ArcCoth",
	"arcsin"="ArcSin","arcsinh"="ArcSinh","arctan"="ArcTan","arctanh"="ArcTanh",
	"besselJ"="BesselJ","cos"="Cos","cosh"="Cosh","cot"="Cot",
	"coth"="Coth","diff"="D","erf"="Erf","exp"="Exp","ln"="Log","sin"="Sin",
	"sinh"="Sinh","tan"="Tan","tanh"="Tanh",
	"function"=expr2text)[type(e)];
   if type(%)<>"_index" then
      %(op(e,0))."[".generate::mma_exprseq([op(e)],",","")."]"
   elif type(e)="hypergeom" then
     "Hypergeometric".nops(op(e, 1))."F".nops(op(e, 2))."[".
       generate::mma_exprseq([op(op(e,1)), op(op(e,2)), op(e,3)],",","")."]"
   else "(".expr2text(e).")"
   end_if
end_proc:
generate::mathematica(PI):="Pi":
generate::mathematica(EULER):="EulerGamma":
generate::mathematica(CATALAN):="Catalan":

// [x1,...,xn] --> mma(x1).op.mma(x2).op ... op.mma(xn) 
generate::mma_exprseq:=proc(l,Op,def)
begin
   fp::fold((()->((if args(2)=def then args(1) else args(2).Op.args(1) end_if)))
        ,def)(op(map(l,generate::mathematica)))
end_proc:

DOM_INT::mathematica:= (x-> (if x>=0 then expr2text(x) else "(".expr2text(x).")" end_if)):
DOM_RAT::mathematica:= (x-> "(".expr2text(x).")"):
DOM_FLOAT::mathematica:= 
  (x-> "(".stringlib::subs(expr2text(x), "e"="*^").")"):
DOM_COMPLEX::mathematica:= 
  (x-> "(".stringlib::subs(expr2text(x), "e"="*^").")"):


DOM_LIST::mathematica:=proc(l)
begin
   "{".generate::mma_exprseq(l,",","")."}"
end_proc:

// represent as a list as there is not rel set in mma 
DOM_SET::mathematica:=DOM_LIST::mathematica:

