/*- 
 admissibleFlow - checks a flow for admissibility
 admissibleFlow(G, flow)
 
 Costs will be filled up with 1 if not existing !

 Parameters:
    G    - Graph
    flow - flow in G (a table with flow[e] = c, when c units flow over the edge e)
 Returns TRUE, if flow is an admissible flow in G. FALSE otherwise.
-*/
Graph::admissibleFlow := proc(G : Graph, flow)
local _edges, _edgeWeights, Eset, item, edge, value;
begin 
  if args(0) <> 2 then
    error("Wrong number of arguments!");
  end_if;
  if not testtype(flow, DOM_TABLE) then
    error("Illegal argument (flow must be a DOM_TABLE)!");
  end_if;
  if not testtype(flow, Type::TableOfIndex(DOM_LIST/*,2,2*/)) then
    error("Illegal argument (flow must be a DOM_TABLE with edges as indices)!");   
  end_if;
  if not testtype(flow, Type::TableOfEntry(Type::Numeric)) then
    error("Illegal argument (flow values must be numeric values)!");
  end_if;
  
  _edges := Graph::getEdges(G);
  _edgeWeights := Graph::getEdgeWeights(G); 

  // Weights might be specified only for a subset of edges
  if _edgeWeights = FAIL then
    _edgeWeights:= table();
  end_if;
  if nops(_edgeWeights) < nops(_edges) then
    for edge in _edges do
      if not contains(_edgeWeights, edge) then
        _edgeWeights[edge] := 1;
      end_if;
    end_for;
  end_if;

  Eset := [];
  for item in flow do 
    edge := op(item,1);
    Eset := append(Eset, edge);
    value := op(item, 2);
    if not Graph::isEdge(G, [edge]) then
       return(FALSE);
    end_if;
    if value < 0 or value > _edgeWeights[edge] then
       return(FALSE);
    end_if;
  end_for;
  if {op(Eset)} <> {op(_edges)} then
     return(FALSE);
  end_if;
  TRUE
end_proc:

// End of file
null():
