/*
  bipartite(G, startVertex)
  finds out if a graph is bipartite or not.
  (Algorithm taken from Jungnickel / Graphen, Netzwerke und Algorithmen p.346)

  Parameters:
  G           - Graph
  Lists/Bool  - returns either two lists in a list (or FAIL) with the two sets of vertices or just TRUE/FALSE. (Default = Bool) 
*/
Graph::bipartite := proc(G : Graph)
local visitedSet, partOne, partTwo, bipart, _color, vertex, v, _adjacentEdges, output, 
      _vertices, toSearch, setToDo, setOne, setTwo;
begin
  output := hold(Bool);
  if args(0) > 1 then
    case args(2)
      of hold(Bool) do
        break;
      of hold(Lists) do
        output := hold(Lists);
        break;
      otherwise
        error("Wrong argument definition.");
    end_case;     
  end_if;

  bipart := TRUE;
  _vertices := Graph::getVertices(G);
  if nops(_vertices) = 0 then
    error("Graph has no vertices!");
  end_if;

  vertex := op(_vertices[1]);
  toSearch := {op(_vertices)} minus {vertex};
  visitedSet := {vertex};
  _color[vertex] := 1;
  setOne := 1;
  setTwo := 0;
  setToDo := {};

  while not nops(visitedSet) = 0 do
    visitedSet := visitedSet minus {vertex};
    // Check the adjacent edges
    _adjacentEdges := { op(Graph::getAdjacentEdgesLeaving(G, [vertex])) };

    // no incoming and no outgoing edge !
    if nops(_adjacentEdges) = 0 then
      if (contains(_color, vertex) = FALSE) then      
        setToDo := setToDo union {vertex};
      end_if;
    else
      if (contains(_color, vertex) = FALSE) then
        if setTwo > setOne then
          _color[vertex] := 1;
          setOne := setOne + 1;
        else
          _color[vertex] := 2;
          setTwo := setTwo + 1;
        end_if;
      end_if;     
    end_if;

    for v in _adjacentEdges do
      if (contains(_color, v) = FALSE) then
        _color[v] := _color[vertex] + 1;
        if _color[v] mod 2 = 1 then
          setOne := setOne + 1;
        else
          setTwo := setTwo + 1;
        end_if;

        visitedSet := visitedSet union {v};
        toSearch := toSearch minus {v}
      else
        if _color[v] = _color[vertex] then
          bipart := FALSE;
        end_if;
      end_if;
    end_for;
    if nops(visitedSet) = 0 then
      if nops(toSearch) > 0 then
        vertex := op(toSearch, 1);
        visitedSet := {vertex};
        toSearch := toSearch minus {vertex};
      end_if;
    else
      vertex := op(visitedSet, 1);      
    end_if;
  end_while;

  // Now add the vertices that are left (not connected to the graph) to the set that has lesser operators.
  for v in setToDo do
    if (contains(_color, v) = FALSE) then // For directed graphs necessary (vertices may be connected!)
      if setTwo > setOne then
        _color[op(v)] := 1;
        setOne := setOne + 1;
      else
        _color[op(v)] := 2;
        setTwo := setTwo + 1;
      end_if;
    end_if;
  end_for;

  if (output = hold(Bool)) then
    bipart;
  else
    if (bipart = TRUE) then
      partOne := {};

      for v in _vertices do
        if _color[v] mod 2 = 0 then
          partOne := partOne union {v}
        end_if;
      end_for;
      partTwo := {op(_vertices)} minus partOne;

      [sort([op(partOne)]), sort([op(partTwo)])];
    else
      FAIL; // output = Table and graph is not bipartite.
    end_if;
  end_if;
end_proc:

// End of file
null():
