/*
 breadthFirstSearch(G <,startVertex>)
 Parameters:
 G           - Graph
 startVertex - a vertex from which to start
*/
Graph::breadthFirstSearch := proc(G : Graph)
local timestamp, _color, _level, _vertices, v, _startVertex, _startTime, _levelTable, _parent, bfsVisit;
begin

  bfsVisit :=  proc(_vertex)
    local _adjacentEdges, visitedList, lastVertex;
  begin
    visitedList := [_vertex];
    lastVertex := _vertex; // because it is deleted immediately (and thus can do no harm).
    timestamp := timestamp + 1;
    _startTime[_vertex] := timestamp;
    _levelTable[_vertex] := _level;
    _level := _level + 1;
    repeat      
      _color[_vertex] := 1;
      delete visitedList[contains(visitedList,_vertex)];
      _adjacentEdges := Graph::getAdjacentEdgesLeaving(G, [_vertex]);
      if (nops(_adjacentEdges) > 0) and (_parent[_vertex] = infinity) then
        _parent[_vertex] := _vertex;
      end_if;
      if (nops(_adjacentEdges) > 0) and contains(visitedList, lastVertex) = 0 then
        lastVertex := _adjacentEdges[ nops(_adjacentEdges) ];
      end_if;
      while not nops(_adjacentEdges) = 0 do
        if _color[op(_adjacentEdges,1)] = 0 then
          timestamp := timestamp + 1;
          _startTime[op(_adjacentEdges,1)] := timestamp;
          _levelTable[op(_adjacentEdges,1)] := _level;
          _parent[op(_adjacentEdges,1)] := _vertex;            
          visitedList := append(visitedList, op(_adjacentEdges,1));
        end_if;
        if _adjacentEdges[1] = lastVertex then
         _level := _level + 1;
        end_if;
        delete _adjacentEdges[1];
      end_while;
      _color[_vertex] := 2;
      _vertex := op(visitedList, 1);
    until nops(visitedList) = 0 end_repeat;
  end_proc;

  _vertices := Graph::getVertices(G);
  // For empty graphs:
  _startTime := table();
  _levelTable := table();
  _parent := table();
  // here it goes on....

  timestamp := 0;
  // Initialize with visiting-time 0
  for v in _vertices do
    _parent[v] := infinity;
    _color[v] := 0;
  end_for;

  _level := 0;
  if args(0) = 2 then
    if op(args(2),1) = hold(StartVertex) then
      _startVertex := op(op(args(2),2));
    else
      error("Wrong argument: ".expr2text(op(args(2),1)).".");
    end_if;
    bfsVisit(op(_startVertex));
  end_if;

  // timestamp was set so complicated, because there might exist several forests.
  for v in _vertices do
    if _color[v] = 0 then
      _level := 0;
      bfsVisit(op(v));
    end_if;
  end_for;

  for v in _startTime do
    userinfo(NoNL, 1, "Vertex " . expr2text(lhs(v)) . " is found at timestamp " . expr2text(rhs(v)) . "\n" );    
  end_for;

  [_startTime, _levelTable, _parent];
end_proc:

// End of file
null():
