/*-
 contract - Contracts vertices

-*/
Graph::contract := proc(G : Graph, Components : DOM_TABLE)
local _edges, _edge, _vertices, _set1, _set2, found1, found2,i,position,
      leftOperator1, rightOperator1, leftOperator2, rightOperator2, vertex1, vertex2, _newEdges, useVertices;
  
begin
  if not Graph::getEdgeWeights(G) = FAIL then
  	 error("Graph is weighted! To contract, it has to be unweighted.");
  end_if;
  if not Graph::getEdgeCosts(G) = FAIL then
  	 error("Graph has edge costs! To contract, edges must not have costs.");
  end_if;
  if not Graph::getEdgeDescriptions(G) = FAIL then
  	 error("Graph has edge descriptions! To contract, edges must not have descriptions.");
  end_if;

  _edges := Graph::getEdges(G);
  _vertices := Graph::getVertices(G);
  _newEdges := [];
  // to check the vertices truly used
  useVertices := table();

  for _edge in _edges do    

    found1 := FALSE;
  	 for _set1 in Components do
      leftOperator1 := op(_set1, 1);
      rightOperator1 := op(_set1, 2);
  	 	 if contains(rightOperator1, op(_edge,1)) > 0 then
        vertex1 := leftOperator1;
        useVertices[leftOperator1] := 0; // rhs does not matter. Only lhs !
  	 	 	 found1 := TRUE;
        break;
  	 	 end_if;
  	 end_for;

    found2 := FALSE;
  	 for _set2 in Components do
      leftOperator2 := op(_set2, 1);
      rightOperator2 := op(_set2, 2);
  	 	 if contains(rightOperator2, op(_edge,2)) > 0 then
        vertex2 := leftOperator2;
        useVertices[leftOperator2] := 0; // rhs does not matter. Only lhs !
  	 	 	 found2 := TRUE;
        break;
  	 	 end_if;
  	 end_for;

    if found1 then
      // Vertex1 was found in sets     
    	 if found2 then
    	 	 // Vertex2 was found in sets
        _newEdges := append(_newEdges, [vertex1, vertex2]);
      else
        // Vertex2 was not found
        _newEdges := append(_newEdges, [vertex1, op(_edge,2)]);
    	 end_if;
    else
      // Vertex1 was not found in sets
    	 if found2 then
    	 	 // Vertex2 was found in sets
        _newEdges := append(_newEdges, [op(_edge,1), vertex2]);
      else
        // Vertex2 was not found
        _newEdges := append(_newEdges, [op(_edge,1), op(_edge,2)]);
    	 end_if;
    end_if;

  end_for;

  for _set1 in Components do
    // add name of set 1 to vertices id it was truly used...
    if contains(useVertices, op(_set1, 1)) then
    	 _vertices := append(_vertices, op(_set1, 1));    	
    end_if;
    // Remove vertices no longer needed from sets:
    _set1 := op(_set1, 2);
    for _set2 in _set1 do
      position := contains(_vertices, _set2);
      if position > 0 then
        delete _vertices[position];
      end_if;
    end_for;
  end_for;

  if not Graph::isDirected(G) then
    for i from 1 to nops(_newEdges) do
      _newEdges[i] := sort(_newEdges[i]);
    end_for;  	
  end_if;

  // remove Duplicate edges
  _newEdges := [op({op(_newEdges)})];

  if Graph::isDirected(G) then
    Graph::new(_vertices, _newEdges, hold(Directed));
  else
    Graph::new(_vertices, _newEdges);
  end_if;
end_proc:

// End of file
null():
